/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class CommandLineProcessor
extends OptionProcessor {
    private final Option openOption = Option.defaultArguments();
    private final Option openOption2 = Option.additionalArguments((char)'o', (String)"open");
    private final String MEMORY_ERROR = NbBundle.getMessage(CommandLineProcessor.class, (String)"CommandLineProcessor.OutOfMemoryError.message");

    protected Set<Option> getOptions() {
        HashSet<Option> set = new HashSet<Option>();
        set.add(this.openOption);
        set.add(this.openOption2);
        return set;
    }

    public void process(Env env, Map values) {
        WindowManager.getDefault().invokeWhenUIReady(() -> new Thread(() -> {
            ArrayList<String> filenameList = new ArrayList<String>();
            Object obj = values.get(this.openOption);
            if (obj != null) {
                filenameList.addAll(Arrays.asList((String[])obj));
            }
            if ((obj = values.get(this.openOption2)) != null) {
                filenameList.addAll(Arrays.asList((String[])obj));
            }
            Logger.getLogger(CommandLineProcessor.class.getName()).info("Handling " + filenameList.size() + " files from command line");
            try {
                for (int i = 0; i < filenameList.size(); ++i) {
                    File file = new File((String)filenameList.get(i));
                    if (!file.isAbsolute()) {
                        file = new File(env.getCurrentDirectory(), (String)filenameList.get(i));
                    }
                    if (!file.exists()) {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(CommandLineProcessor.class, (String)"CommandLineProcessor.fileNotFound", (Object)file.getName()), 2);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
                        return;
                    }
                    Actions.forID((String)"File", (String)"org.gephi.desktop.project.actions.OpenFile").actionPerformed(new ActionEvent(file, 0, null));
                }
            }
            catch (OutOfMemoryError ex) {
                System.gc();
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)this.MEMORY_ERROR, 0);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)("CommandLineParsing " + ex.getMessage()), 0);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            }
        }, "CommandLineProcessor").start());
    }
}

