/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.graph.api.GraphModel;
import org.gephi.project.api.Workspace;
import org.gephi.project.spi.WorkspaceBytesPersistenceProvider;

public class GraphPersistenceProvider
implements WorkspaceBytesPersistenceProvider {
    private static final int GRAPHSTORE_SERIALIZATION_GRAPHMODEL_CONFIG_ID = 205;

    public void writeBytes(DataOutputStream stream, Workspace workspace) {
        GraphModel model = (GraphModel)workspace.getLookup().lookup(GraphModel.class);
        if (model != null) {
            try {
                GraphModel.Serialization.write(stream, model);
            }
            catch (IOException ex) {
                Logger.getLogger("").log(Level.SEVERE, "", ex.getCause());
            }
        }
    }

    public void readBytes(DataInputStream stream, Workspace workspace) {
        GraphModel model = (GraphModel)workspace.getLookup().lookup(GraphModel.class);
        try {
            stream.mark(1);
            int firstFieldType = stream.readUnsignedByte();
            stream.reset();
            model = firstFieldType == 205 ? GraphModel.Serialization.readWithoutVersionHeader(stream, 0.0f) : (model != null ? GraphModel.Serialization.read(stream, model) : GraphModel.Serialization.read(stream));
            workspace.add((Object)model);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getIdentifier() {
        return "graphstore";
    }
}

