# gap> LoadPackage( "ToricVarieties" );
# true
# gap> P2 := Polytope( [[0,0],[1,0],[0,1]] );
# <A polytope in |R^2>
# gap> P2 := ToricVariety( P2 );
# <A projective toric variety of dimension 2>
# gap> CoxRing( P2 );
# polymake: used package cddlib
#   Implementation of the double description method of Motzkin et al.
#   Copyright by Komei Fukuda.
#   http://www.ifor.math.ethz.ch/~fukuda/cdd_home/cdd.html
# 
# ----------------------------------------------------------------
# Loading  IO_ForHomalg 2011.07.25
# by Thomas Bächler (http://wwwb.math.rwth-aachen.de/~thomas/)
#    Mohamed Barakat (http://www.mathematik.uni-kl.de/~barakat/)
#    Max Neunhöffer (http://www-groups.mcs.st-and.ac.uk/~neunhoef/)
#    Daniel Robertz (http://wwwb.math.rwth-aachen.de/~daniel/)
# For help, type: ?IO_ForHomalg package 
# ----------------------------------------------------------------
# ================================================================
#                      SINGULAR                                 /
#  A Computer Algebra System for Polynomial Computations       /   version 3-1-3
#                                                            0<
#  by: W. Decker, G.-M. Greuel, G. Pfister, H. Schoenemann     \   March 2011
# FB Mathematik der Universitaet, D-67653 Kaiserslautern        \
# ================================================================
# Q[x_1,x_2,x_3]
# (weights: [ [ 0, 0, 1 ], [ 0, 0, 1 ], [ 0, 0, 1 ] ])
# gap> ByASmallerPresentation( ClassGroup( P2 ) );
# <A free left module of rank 1 on a free generator>
# gap> CoxRing( P2 );
# Q[x_1,x_2,x_3]
# (weights: [ 1, 1, 1 ])
# gap> IrrelevantIdeal(P2);
# <A torsion-free (left) ideal given by 3 generators>
# gap> Display(last);
# x_3,
# x_1,
# x_2 
# (over a graded ring)
# 
# A (left) ideal generated by the 3 entries of the above matrix
# gap> D:=Divisor([1,2,3],P2);
# <A divisor of a toric variety with coordinates [ 1, 2, 3 ]>
# gap> ClassOfDivisor(D);
# 6
# gap> MonomsOfCoxRingOfDegree(D);
# [ x_3^6, x_2*x_3^5, x_2^2*x_3^4, x_2^3*x_3^3, x_2^4*x_3^2, x_2^5*x_3, x_2^6, x_1*x_3^5, x_1*x_2*x_3^4, x_1*x_2^2*x_3^3, x_1*x_2^3*x_3^2, x_1*x_2^4*x_3, x_1*x_2^5, 
#   x_1^2*x_3^4, x_1^2*x_2*x_3^3, x_1^2*x_2^2*x_3^2, x_1^2*x_2^3*x_3, x_1^2*x_2^4, x_1^3*x_3^3, x_1^3*x_2*x_3^2, x_1^3*x_2^2*x_3, x_1^3*x_2^3, x_1^4*x_3^2, 
#   x_1^4*x_2*x_3, x_1^4*x_2^2, x_1^5*x_3, x_1^5*x_2, x_1^6 ]
# gap> D2:=Divisor([1,0,0],P2);
# <A divisor of a toric variety with coordinates [ 1, 0, 0 ]>
# gap> MonomsOfCoxRingOfDegree(D2);
# [ x_3, x_2, x_1 ]


LoadPackage( "ToricVarieties" );
P2 := Polytope( [[0,0],[1,0],[0,1]] );
P2 := ToricVariety( P2 );
CoxRing( P2 );
ByASmallerPresentation( ClassGroup( P2 ) );
CoxRing( P2 );
IrrelevantIdeal(P2);
Display(last);
D:=Divisor([1,2,3],P2);
ClassOfDivisor(D);
MonomsOfCoxRingOfDegree(D);
D2:=Divisor([1,0,0],P2);
MonomsOfCoxRingOfDegree(D2);