/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.explorer;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.collection.FilterIterator;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;

public class GlobalNodes
implements IExtension,
Iterable<NodeModel> {
    private static final GlobalNodes EMPTY = new GlobalNodes(Collections.emptyMap());
    private final Map<NodeModel, Void> nodes;

    private static boolean isContainedInTheMap(NodeModel key) {
        return key.getMap().getNodeForID(key.getID()) == key;
    }

    private GlobalNodes(Map<NodeModel, Void> nodes) {
        this.nodes = nodes;
    }

    private boolean contains(NodeModel key) {
        return this.nodes.containsKey(key) && GlobalNodes.isContainedInTheMap(key);
    }

    public static GlobalNodes writeableOf(MapModel map) {
        GlobalNodes globalNodes = map.getExtension(GlobalNodes.class);
        if (globalNodes == null) {
            globalNodes = new GlobalNodes(new WeakHashMap<NodeModel, Void>());
            map.addExtension(globalNodes);
        }
        return globalNodes;
    }

    static GlobalNodes readableOf(MapModel map) {
        GlobalNodes globalNodes = map.getExtension(GlobalNodes.class);
        return globalNodes == null ? EMPTY : globalNodes;
    }

    public void makeGlobal(NodeModel node, boolean isGlobal) {
        if (isGlobal) {
            this.makeGlobal(node);
        } else {
            this.makeNotGlobal(node);
        }
    }

    void makeGlobal(NodeModel node) {
        this.nodes.put(node, null);
    }

    private void makeNotGlobal(NodeModel node) {
        this.nodes.remove(node);
    }

    static boolean isGlobal(NodeModel node) {
        return GlobalNodes.readableOf(node.getMap()).contains(node);
    }

    @Override
    public Iterator<NodeModel> iterator() {
        return new FilterIterator<NodeModel>(this.nodes.keySet().iterator(), GlobalNodes::isContainedInTheMap);
    }
}

