/*
 *
 * BRIEF MODULE DESCRIPTION
 *	Low level UART routines to directly access Alchemy UART.
 *
 * Copyright 2001, 2008 MontaVista Software Inc.
 * Author: MontaVista Software, Inc. <source@mvista.com>
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <asm/mach-au1x00/au1000.h>

#define SERIAL_BASE   UART_BASE
#define SER_CMD       0x7
#define SER_DATA      0x1
#define TX_BUSY       0x20

#define TIMEOUT       0xffffff
#define SLOW_DOWN

static volatile unsigned long * const com1 = (unsigned long *)SERIAL_BASE;

#ifdef SLOW_DOWN
static inline void slow_down(void)
{
	int k;

	for (k = 0; k < 10000; k++);
}
#else
#define slow_down()
#endif

void
prom_putchar(const unsigned char c)
{
	unsigned char ch;
	int i = 0;

	do {
		ch = com1[SER_CMD];
		slow_down();
		i++;
		if (i > TIMEOUT)
			break;
	} while (0 == (ch & TX_BUSY));

	com1[SER_DATA] = c;
}
