/**************************************/
/* Rule Set Based Access Control      */
/* Author and (c) 1999-2001: Amon Ott */
/* Data structures / PM               */
/* Last modified: 27/Apr/2001         */
/**************************************/

#ifndef __RSBAC_PM_DATA_STRUC_H
#define __RSBAC_PM_DATA_STRUC_H

#include <linux/types.h>
#include <rsbac/aci.h>
#include <rsbac/types.h>
#include <rsbac/pm_types.h>

#define RSBAC_PM_TASK_SET_LIST_NAME "pm_ta_s"
#define RSBAC_PM_TASK_SET_LIST_PROC_NAME "task_set"

#define RSBAC_PM_TP_SET_LIST_NAME   "pm_tp_s"
#define RSBAC_PM_TP_SET_LIST_PROC_NAME   "tp_set"

#define RSBAC_PM_RU_SET_LIST_NAME   "pm_ru_s"
#define RSBAC_PM_RU_SET_LIST_PROC_NAME   "responsible_user_set"

#define RSBAC_PM_PP_SET_LIST_NAME   "pm_pp_s"
#define RSBAC_PM_PP_SET_LIST_PROC_NAME   "purpose_set"

#define RSBAC_PM_IN_PP_SET_LIST_NAME "input_pp_set"
#define RSBAC_PM_IN_PP_SET_LIST_PROC_NAME "input_purpose_set"

#define RSBAC_PM_OUT_PP_SET_LIST_NAME "output_pp_set"
#define RSBAC_PM_OUT_PP_SET_LIST_PROC_NAME "output_purpose_set"


#define RSBAC_PM_TASK_LIST_NAME     "pm_task"
#define RSBAC_PM_TASK_LIST_PROC_NAME     "task"

#define RSBAC_PM_CLASS_LIST_NAME    "pm_clas"
#define RSBAC_PM_CLASS_LIST_PROC_NAME    "object_class"

#define RSBAC_PM_NA_LIST_NAME       "pm_na"
#define RSBAC_PM_NA_LIST_PROC_NAME       "necessary_accesses"

#define RSBAC_PM_CS_LIST_NAME       "pm_cs"
#define RSBAC_PM_CS_LIST_PROC_NAME       "consent"

#define RSBAC_PM_TP_LIST_NAME       "pm_tp"
#define RSBAC_PM_TP_LIST_PROC_NAME       "tp"

#define RSBAC_PM_PP_LIST_NAME       "pm_pp"
#define RSBAC_PM_PP_LIST_PROC_NAME       "purpose"

#define RSBAC_PM_TKT_LIST_NAME      "pm_tkt"
#define RSBAC_PM_TKT_LIST_PROC_NAME      "ticket"


#define RSBAC_PM_NO_VERSION 1

#define RSBAC_PM_TASK_SET_LIST_VERSION   1
#define RSBAC_PM_TP_SET_LIST_VERSION     1
#define RSBAC_PM_RU_SET_LIST_VERSION     2
#define RSBAC_PM_PP_SET_LIST_VERSION     1

#define RSBAC_PM_TASK_LIST_VERSION       1
#define RSBAC_PM_CLASS_LIST_VERSION      1
#define RSBAC_PM_NA_LIST_VERSION         1
#define RSBAC_PM_CS_LIST_VERSION         1
#define RSBAC_PM_TP_LIST_VERSION         1
#define RSBAC_PM_PP_LIST_VERSION         1
#define RSBAC_PM_TKT_LIST_VERSION        2

#define RSBAC_PM_LIST_KEY 19990820

#define RSBAC_PM_PROC_STATS_NAME "stats_pm"
#define RSBAC_PM_PROC_DIR_NAME "pm"

/**********************************************/
/* Helper lists                               */
/**********************************************/

/* This list represents sets of task-ids, using a set-id and a sublist each */

struct rsbac_pm_task_set_sublist_item_t
    {
      rsbac_pm_task_id_t                        id;
      struct rsbac_pm_task_set_sublist_item_t * prev;
      struct rsbac_pm_task_set_sublist_item_t * next;
    };

struct rsbac_pm_task_set_list_item_t
    {
      rsbac_pm_task_set_id_t                    id;
      int                                       sublist_length;
      struct rsbac_pm_task_set_sublist_item_t * sublist_head;
      struct rsbac_pm_task_set_sublist_item_t * sublist_tail;
      struct rsbac_pm_task_set_list_item_t    * prev;
      struct rsbac_pm_task_set_list_item_t    * next;
    };

struct rsbac_pm_task_set_list_head_t
    {
      struct rsbac_pm_task_set_list_item_t * head;
      struct rsbac_pm_task_set_list_item_t * tail;
      struct rsbac_pm_task_set_list_item_t * curr;
      rwlock_t                               lock;
      boolean                                dirty;
      u_long                                 count;
      boolean                                no_write;
    };


/* This list represents sets of TP-ids, using a set-id and a sublist each */

struct rsbac_pm_tp_set_sublist_item_t
    {
      rsbac_pm_tp_id_t                        id;
      struct rsbac_pm_tp_set_sublist_item_t * prev;
      struct rsbac_pm_tp_set_sublist_item_t * next;
    };

struct rsbac_pm_tp_set_list_item_t
    {
      rsbac_pm_tp_set_id_t                    id;
      int                                     sublist_length;
      struct rsbac_pm_tp_set_sublist_item_t * sublist_head;
      struct rsbac_pm_tp_set_sublist_item_t * sublist_tail;
      struct rsbac_pm_tp_set_list_item_t    * prev;
      struct rsbac_pm_tp_set_list_item_t    * next;
    };

struct rsbac_pm_tp_set_list_head_t
    {
      struct rsbac_pm_tp_set_list_item_t * head;
      struct rsbac_pm_tp_set_list_item_t * tail;
      struct rsbac_pm_tp_set_list_item_t * curr;
      rwlock_t                             lock;
      boolean                              dirty;
      u_int                                count;
      boolean                              no_write;
    };


/* This list represents sets of Responsible-User-ids, using a set-id and a */
/* sublist each */

struct rsbac_pm_ru_set_sublist_item_t
    {
             rsbac_uid_t                      id;
      struct rsbac_pm_ru_set_sublist_item_t * prev;
      struct rsbac_pm_ru_set_sublist_item_t * next;
    };

struct rsbac_pm_ru_set_list_item_t
    {
      rsbac_pm_ru_set_id_t                    id;
      int                                     sublist_length;
      struct rsbac_pm_ru_set_sublist_item_t * sublist_head;
      struct rsbac_pm_ru_set_sublist_item_t * sublist_tail;
      struct rsbac_pm_ru_set_list_item_t    * prev;
      struct rsbac_pm_ru_set_list_item_t    * next;
    };

struct rsbac_pm_ru_set_list_head_t
    {
      struct rsbac_pm_ru_set_list_item_t * head;
      struct rsbac_pm_ru_set_list_item_t * tail;
      struct rsbac_pm_ru_set_list_item_t * curr;
      rwlock_t                             lock;
      boolean                              dirty;
      u_int                                count;
      boolean                              no_write;
    };

/* This list represents sets of purpose-ids, using a set-id and a */
/* sublist each */

struct rsbac_pm_pp_set_sublist_item_t
    {
      rsbac_pm_purpose_id_t                   id;
      struct rsbac_pm_pp_set_sublist_item_t * prev;
      struct rsbac_pm_pp_set_sublist_item_t * next;
    };

struct rsbac_pm_pp_set_list_item_t
    {
      rsbac_pm_pp_set_id_t                    id;
      int                                     sublist_length;
      struct rsbac_pm_pp_set_sublist_item_t * sublist_head;
      struct rsbac_pm_pp_set_sublist_item_t * sublist_tail;
      struct rsbac_pm_pp_set_list_item_t    * prev;
      struct rsbac_pm_pp_set_list_item_t    * next;
    };

struct rsbac_pm_pp_set_list_head_t
    {
      struct rsbac_pm_pp_set_list_item_t * head;
      struct rsbac_pm_pp_set_list_item_t * tail;
      struct rsbac_pm_pp_set_list_item_t * curr;
      rwlock_t                             lock;
      boolean                              dirty;
      u_long                               count;
      boolean                              no_write;
    };

/* This list also represents sets of purpose-ids, using a set-id and a */
/* sublist each */

struct rsbac_pm_in_pp_set_sublist_item_t
    {
      rsbac_pm_purpose_id_t                      id;
      struct rsbac_pm_in_pp_set_sublist_item_t * prev;
      struct rsbac_pm_in_pp_set_sublist_item_t * next;
    };

struct rsbac_pm_in_pp_set_list_item_t
    {
      rsbac_pm_in_pp_set_id_t                    id;
      int                                        sublist_length;
      struct rsbac_pm_in_pp_set_sublist_item_t * sublist_head;
      struct rsbac_pm_in_pp_set_sublist_item_t * sublist_tail;
      struct rsbac_pm_in_pp_set_list_item_t    * prev;
      struct rsbac_pm_in_pp_set_list_item_t    * next;
    };

struct rsbac_pm_in_pp_set_list_head_t
    {
      struct rsbac_pm_in_pp_set_list_item_t * head;
      struct rsbac_pm_in_pp_set_list_item_t * tail;
      struct rsbac_pm_in_pp_set_list_item_t * curr;
      rwlock_t                                lock;
      boolean                                 dirty;
      u_int                                   count;
    };

/* This list also represents sets of purpose-ids, using a set-id and a */
/* sublist each */

struct rsbac_pm_out_pp_set_sublist_item_t
    {
      rsbac_pm_purpose_id_t                      id;
      struct rsbac_pm_out_pp_set_sublist_item_t * prev;
      struct rsbac_pm_out_pp_set_sublist_item_t * next;
    };

struct rsbac_pm_out_pp_set_list_item_t
    {
      rsbac_pm_out_pp_set_id_t                    id;
      int                                        sublist_length;
      struct rsbac_pm_out_pp_set_sublist_item_t * sublist_head;
      struct rsbac_pm_out_pp_set_sublist_item_t * sublist_tail;
      struct rsbac_pm_out_pp_set_list_item_t    * prev;
      struct rsbac_pm_out_pp_set_list_item_t    * next;
    };

struct rsbac_pm_out_pp_set_list_head_t
    {
      struct rsbac_pm_out_pp_set_list_item_t * head;
      struct rsbac_pm_out_pp_set_list_item_t * tail;
      struct rsbac_pm_out_pp_set_list_item_t * curr;
      rwlock_t                                 lock;
      boolean                                  dirty;
      u_int                                    count;
    };


/**********************************************/
/* Main lists                                 */
/**********************************************/

/* List of defined tasks */
/* rsbac_pm_task_data_t is defined in pm_types.h! */

struct rsbac_pm_task_list_item_t
    {
      struct rsbac_pm_task_data_t   data;
      struct rsbac_pm_task_list_item_t * prev;
      struct rsbac_pm_task_list_item_t * next;
    };

struct rsbac_pm_task_list_head_t
    {
      struct rsbac_pm_task_list_item_t * head;
      struct rsbac_pm_task_list_item_t * tail;
      struct rsbac_pm_task_list_item_t * curr;
      rwlock_t                           lock;
      boolean                            dirty;
      u_int                              count;
      boolean                            no_write;
    };

/* List of defined classes */
/* rsbac_pm_class_data_t is defined in pm_types.h! */


struct rsbac_pm_class_list_item_t
    {
      struct rsbac_pm_class_data_t     data;
      struct rsbac_pm_class_list_item_t   * prev;
      struct rsbac_pm_class_list_item_t   * next;
    };

struct rsbac_pm_class_list_head_t
    {
      struct rsbac_pm_class_list_item_t * head;
      struct rsbac_pm_class_list_item_t * tail;
      struct rsbac_pm_class_list_item_t * curr;
      rwlock_t                            lock;
      boolean                             dirty;
      u_int                               count;
      boolean                            no_write;
    };

/* List of defined necessary accesses */
/* rsbac_pm_na_data_t is defined in pm_types.h! */

struct rsbac_pm_na_list_item_t
    {
      struct rsbac_pm_na_data_t     data;
      struct rsbac_pm_na_list_item_t   * prev;
      struct rsbac_pm_na_list_item_t   * next;
    };

struct rsbac_pm_na_list_head_t
    {
      struct rsbac_pm_na_list_item_t * head;
      struct rsbac_pm_na_list_item_t * tail;
      struct rsbac_pm_na_list_item_t * curr;
      rwlock_t                         lock;
      boolean                          dirty;
      u_int                            count;
      boolean                          no_write;
    };


/* List of consents */
/* rsbac_pm_cs_data_t is defined in pm_types.h! */

struct rsbac_pm_cs_list_item_t
    {
      struct rsbac_pm_cs_data_t          data;
      struct rsbac_pm_cs_list_item_t   * prev;
      struct rsbac_pm_cs_list_item_t   * next;
    };

struct rsbac_pm_cs_list_head_t
    {
      struct rsbac_pm_cs_list_item_t * head;
      struct rsbac_pm_cs_list_item_t * tail;
      struct rsbac_pm_cs_list_item_t * curr;
      rwlock_t                         lock;
      boolean                          dirty;
      u_int                            count;
      boolean                          no_write;
    };


/* List of defined transformation procedures */

struct rsbac_pm_tp_list_item_t
    {
      struct rsbac_pm_tp_data_t   data;
      struct rsbac_pm_tp_list_item_t * prev;
      struct rsbac_pm_tp_list_item_t * next;
    };

struct rsbac_pm_tp_list_head_t
    {
      struct rsbac_pm_tp_list_item_t * head;
      struct rsbac_pm_tp_list_item_t * tail;
      struct rsbac_pm_tp_list_item_t * curr;
      rwlock_t                         lock;
      boolean                          dirty;
      u_int                            count;
      boolean                          no_write;
    };


/* List of defined purposes */

struct rsbac_pm_pp_list_item_t
    {
      struct rsbac_pm_pp_data_t   data;
      struct rsbac_pm_pp_list_item_t * prev;
      struct rsbac_pm_pp_list_item_t * next;
    };

struct rsbac_pm_pp_list_head_t
    {
      struct rsbac_pm_pp_list_item_t * head;
      struct rsbac_pm_pp_list_item_t * tail;
      struct rsbac_pm_pp_list_item_t * curr;
      rwlock_t                         lock;
      boolean                          dirty;
      u_int                            count;
      boolean                          no_write;
    };


/* List of valid tickets for PM administration calls */
/* rsbac_pm_tkt_data_t is defined in pm_types.h! */

struct rsbac_pm_tkt_list_item_t
    {
      struct rsbac_pm_tkt_data_t            data;
      struct rsbac_pm_tkt_list_item_t     * prev;
      struct rsbac_pm_tkt_list_item_t     * next;
    };

struct rsbac_pm_tkt_list_head_t
    {
      struct rsbac_pm_tkt_list_item_t * head;
      struct rsbac_pm_tkt_list_item_t * tail;
      struct rsbac_pm_tkt_list_item_t * curr;
      rwlock_t                          lock;
      boolean                           dirty;
      u_int                             count;
      boolean                           no_write;
    };

#endif
