/*
 * ocfsver.c
 *
 * prints the version string
 *
 * Copyright (C) 2003 Oracle Corporation.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 *
 * Authors: Kurt Hackel, Sunil Mushran, Manish Singh, Wim Coekaerts
 */

#include <ocfs.h>

/* added for SuSE build. fix when you update. */
#define OCFS_BUILD_VERSION "1.0.9-pre" 
#define OCFS_BUILD_DATE __DATE__
#define OCFS_BUILD_MD5 "-" 

MODULE_DESCRIPTION("The Oracle Cluster Filesystem (version "
                   OCFS_BUILD_VERSION
                   ")");

char *ocfs_version = OCFS_BUILD_VERSION;

/*
 * ocfs_version_print()
 * 
 */
void ocfs_version_print (void)
{
	printk(KERN_INFO "Oracle Cluster FileSystem "
			 OCFS_BUILD_VERSION " "
			 OCFS_BUILD_DATE " "
			 "(build "  OCFS_BUILD_MD5 ")\n");
}				/* ocfs_version_print */
