/*******************************************************************************

  Copyright(c) 2002 - 2005 Promise Technology, Inc. All rights reserved.
  
  cam_macr.h - defines macros for CAM

  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called LICENSE.
  
  Contact Information:
  Promise Technology, Inc.
  <support@promise.com.tw>	[TAIWAN]
  <support@promise.com>		[U.S.A]
  <support-china@promise.com>	[CHINA]

*******************************************************************************/

#ifdef	_MMIO_
	#define	WritePortUlong(BaseAddress, Offset, Data )\
	{\
		camWriteRegDword(BaseAddress+Offset, Data);\
	}
	
	#define	ReadPortUlong(BaseAddress, Offset, Data )\
	{\
		Data = camReadRegDword(BaseAddress+Offset);\
	}
	
	#define	WritePortUchar(BaseAddress, Offset, Data )\
	{\
		camWriteRegByte(BaseAddress+Offset, Data);\
	}
	
	#define	ReadPortUchar(BaseAddress, Offset, Data )\
	{\
		Data = camReadRegByte(BaseAddress+Offset);\
	}
	
	#define WriteIndexUlong(BaseAddress, Index, Data )\
	{\
		camWriteRegDword(BaseAddress+Index, Data);\
	}	

	#define ReadIndexUlong(BaseAddress, Index, Data )\
	{\
		Data = camReadRegDword( BaseAddress+Index);\
	}	
	
	#define ReadBuffer(BaseIoAddress, Buffer, Count)\
	{\
		U32 i;\
		for (i = 0; i< Count; i++ ) {\
			*(Buffer+i) = camReadRegWord(BaseIoAddress);\
		}\
	}
	
	#define WriteBuffer(BaseIoAddress, Buffer, Count)\
	{\
		U32 i;\
		for (i = 0; i< Count; i++ ) {\
			camWriteRegWord(BaseIoAddress, *(Buffer+i));\
		}\
	}	
#else
	#define	WritePortUlong(BaseAddress, Offset, Data )\
	{\
		camOutPortDword(BaseAddress+Offset, Data);\
	}
	
	#define	ReadPortUlong(BaseAddress, Offset, Data )\
	{\
		Data = camInPortDword(BaseAddress+Offset);\
	}	
	
	#define	WritePortUchar(BaseAddress, Offset, Data )\
	{\
		camOutPortByte(BaseAddress+Offset, Data);\
	}
	
	#define	ReadPortUchar(BaseAddress, Offset, Data )\
	{\
		Data = camInPortByte(BaseAddress+Offset);\
	}
	
	
	#define WriteIndexUlong(BaseAddress, Index, Data )\
	{\
		camOutPortByte(BaseAddress+ INDEX_REGISTER_OFFSET, Index);\
		camOutPortDword(BaseAddress+ DATA_REGISTER_OFFSET, Data);\
	}

	#define ReadIndexUlong(BaseAddress, Index, Data )\
	{\
		camOutPortByte(BaseAddress+ INDEX_REGISTER_OFFSET, Index);\
		Data = camInPortDword(BaseAddress+ DATA_REGISTER_OFFSET);\
	}	
	
	#define ReadBuffer(BaseIoAddress, Buffer, Count)\
	{\
		U32 i;\
		camOutPortByte( BaseIoAddress+ INDEX_REGISTER_OFFSET, iNDEXIDEData);\
		for (i = 0; i< Count; i++ ) {\
			*(Buffer+i) = camInPortWord( BaseIoAddress+ DATA_REGISTER_OFFSET);\
		}\
	}
		
	#define WriteBuffer(BaseIoAddress, Buffer, Count)\
	{\
		U32 i;\
		camOutPortByte( BaseIoAddress+ INDEX_REGISTER_OFFSET, iNDEXIDEData);\
		for (i = 0; i< Count; i++ ) {\
			camOutPortWord( BaseIoAddress+ DATA_REGISTER_OFFSET, *(Buffer+i));\
		}\
	}	
		
#endif

/*
 *  Macros for ATA module 
 */
#define GetStatus(IDEBaseAddress, Status)\
	Status = ReadIndexUchar(IDEBaseAddress, iNDEXIDEAlternateStatus);\

#define GetBaseStatus(IDEBaseAddress, Status)\
	Status = ReadIndexUchar(IDEBaseAddress, iNDEXIDEStatus);\





