#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/sysctl.h>
#include <linux/grinternal.h>

int
gr_handle_sysctl_mod(const char *dirname, const char *name, const int op)
{
#ifdef CONFIG_GRKERNSEC
	if (!strcmp(dirname, "grsecurity") && grsec_lock
	    && strcmp(name, "acl") && (op & 002)) {
		security_alert(GR_SYSCTL_MSG, name, DEFAULTSECARGS);
		return -EACCES;
	}
#endif
	return 0;
}
