/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.check.bootstrap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import tudresden.ocl.OclTree;
import tudresden.ocl.check.bootstrap.AnnotatedCodeFragment;
import tudresden.ocl.check.bootstrap.SableNameAdapter;
import tudresden.ocl.check.bootstrap.SableReflectionFacade;
import tudresden.ocl.check.types.DefaultReflectionAdapter;
import tudresden.ocl.codegen.CodeFragment;
import tudresden.ocl.codegen.JavaCodeGenerator;
import tudresden.ocl.normalize.PreconditionViolatedException;

public class BootstrapGenerator {
    OclTree[] constraints;
    String[] constraintText;
    String javaPackage;
    String javaClass;
    String javaFile;
    JavaCodeGenerator javaCodeGenerator = new JavaCodeGenerator("node", "result");
    private HashMap nodeBuffers = new HashMap();
    protected static String imports = "import tudresden.ocl.lib.*;\nimport tudresden.ocl.parser.node.*;\nimport tudresden.ocl.parser.analysis.*;\n\n";

    public BootstrapGenerator(OclTree[] constraints, String javaPackage, String javaFile) {
        this.constraints = constraints;
        this.javaPackage = javaPackage;
        this.javaFile = javaFile;
        this.javaClass = javaFile.substring(javaFile.lastIndexOf(File.separator) + 1, javaFile.lastIndexOf("."));
    }

    public BootstrapGenerator(String constraintFile, String javaPackage, String javaFile) throws IOException {
        this((OclTree[])null, javaPackage, javaFile);
        this.loadConstraints(constraintFile);
    }

    protected void loadConstraints(String fileName) throws IOException {
        String nextLine;
        File in = new File(fileName);
        BufferedReader br = new BufferedReader(new FileReader(in));
        ArrayList<String> constraintList = new ArrayList<String>();
        String nextConstraint = "";
        do {
            if ((nextLine = br.readLine()) == null || nextLine.trim().equals("")) {
                if (!nextConstraint.equals("")) {
                    constraintList.add(nextConstraint);
                }
                nextConstraint = "";
                continue;
            }
            nextConstraint = nextConstraint + "\n" + nextLine;
        } while (nextLine != null);
        this.constraintText = constraintList.toArray(new String[constraintList.size()]);
        this.constraints = new OclTree[this.constraintText.length];
        String[] packageNames = new String[]{"tudresden.ocl.parser.node"};
        SableReflectionFacade mf = new SableReflectionFacade(packageNames, new DefaultReflectionAdapter(), new SableNameAdapter());
        int i = 0;
        while (i < this.constraintText.length) {
            this.constraints[i] = OclTree.createTree(this.constraintText[i], mf);
            ++i;
        }
    }

    public void writeToFile(File output) throws IOException {
        FileWriter fw = new FileWriter(output);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(this.getCheckingCode());
        bw.flush();
        bw.close();
        fw.close();
    }

    public void writeToFile() throws IOException {
        this.writeToFile(new File(this.javaFile));
    }

    public String getCheckingCode() {
        this.nodeBuffers.clear();
        StringBuffer headerCode = new StringBuffer();
        StringBuffer checkingCode = new StringBuffer();
        ArrayList codeFragments = this.transformToFragments(this.constraints);
        headerCode.append("package " + this.javaPackage + ";\n\n");
        headerCode.append(imports);
        headerCode.append("public class " + this.javaClass + " extends DepthFirstAdapter {\n\n");
        headerCode.append("  public boolean reportProgress=false;\n\n");
        Iterator<Object> iter = ((AbstractList)codeFragments).iterator();
        while (iter.hasNext()) {
            AnnotatedCodeFragment next = (AnnotatedCodeFragment)iter.next();
            if (next.fragment.getKind() != 177) {
                throw new RuntimeException("unexpected fragment kind");
            }
            StringBuffer traversalCode = this.getNodeBuffer(next.fragment.getConstrainedType());
            traversalCode.append("    reportProgress(\"starting " + next.proposedMethodName + "\");\n");
            traversalCode.append("    " + next.proposedMethodName + "(node);\n");
            checkingCode.append("protected void ");
            checkingCode.append(next.proposedMethodName);
            checkingCode.append("(final " + next.fragment.getConstrainedType() + " node) {\n");
            checkingCode.append("  /* " + next.annotation + " */\n");
            checkingCode.append(next.fragment.getCode());
            checkingCode.append("  if ( !" + next.fragment.getResultVariable() + ".isTrue() ) {\n");
            checkingCode.append("    throw new GeneratedTestFailedException(\n");
            checkingCode.append("      \"generated test failed:\\n" + next.annotation + "\\n\"+\n");
            checkingCode.append("      \"violating node:\\n\"+node\n");
            checkingCode.append("    );\n");
            checkingCode.append("  }\n");
            checkingCode.append("}\n\n");
        }
        StringBuffer output = new StringBuffer();
        output.append((Object)headerCode);
        iter = this.nodeBuffers.keySet().iterator();
        while (iter.hasNext()) {
            Object node = iter.next();
            output.append("  public void in" + node + "(" + node + " node) {\n");
            output.append(this.nodeBuffers.get(node));
            output.append("  }\n\n");
        }
        output.append("  protected void reportProgress(String msg) {\n");
        output.append("    if (reportProgress) System.out.println(msg);\n");
        output.append("  }\n\n");
        output.append((Object)checkingCode);
        output.append("}\n\n");
        output.append("class GeneratedTestFailedException extends tudresden.ocl.OclException {\n\n");
        output.append("  GeneratedTestFailedException(String msg) {\n");
        output.append("    super(msg);\n");
        output.append("  }\n");
        output.append("}\n");
        return output.toString();
    }

    protected StringBuffer getNodeBuffer(String nodeType) {
        StringBuffer result = (StringBuffer)this.nodeBuffers.get(nodeType);
        if (result == null) {
            result = new StringBuffer();
            this.nodeBuffers.put(nodeType, result);
        }
        return result;
    }

    protected ArrayList transformToFragments(OclTree[] constraints) {
        ArrayList<AnnotatedCodeFragment> codeFragments = new ArrayList<AnnotatedCodeFragment>();
        int i = 0;
        while (i < constraints.length) {
            try {
                constraints[i].applyDefaultNormalizations();
            }
            catch (Exception e) {
                throw new PreconditionViolatedException("cannot normalize: " + constraints[i].getExpression());
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < constraints.length) {
            CodeFragment[] frags = this.javaCodeGenerator.getCode(constraints[i2]);
            int j = 0;
            while (j < frags.length) {
                AnnotatedCodeFragment acf = new AnnotatedCodeFragment();
                acf.fragment = frags[j];
                acf.annotation = constraints[i2].getExpression();
                acf.proposedMethodName = constraints[0].getNameCreator().getUniqueName("CheckMethod");
                codeFragments.add(acf);
                ++j;
            }
            ++i2;
        }
        return codeFragments;
    }

    public static void main(String[] args) {
        int indexConstraintFile;
        PrintStream output = System.err;
        if (args.length < 3 || args.length > 4) {
            BootstrapGenerator.reportParameters(output);
            return;
        }
        if (args.length == 3) {
            indexConstraintFile = 0;
        } else {
            indexConstraintFile = 1;
            if (args[0].equals("-o")) {
                output = System.out;
            } else {
                BootstrapGenerator.reportParameters(output);
                return;
            }
        }
        try {
            BootstrapGenerator bcg = new BootstrapGenerator(args[0 + indexConstraintFile], args[1 + indexConstraintFile], args[2 + indexConstraintFile]);
            bcg.writeToFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            BootstrapGenerator.reportParameters(output);
        }
    }

    protected static void reportParameters(PrintStream output) {
        output.println("usage: java tudresden.ocl.check.bootstrap.BootstrapGenerator [-o] <constraint_file> <java_package_name> <target_file>");
        output.println("-o redirects error messages to standard out");
        output.println("The name of the generated Java class is extracted from the target file name.");
    }
}

