/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.List;
import org.tigris.gef.base.Geometry;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.Handle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigPoly
extends Fig {
    private static final float MITER_LIMIT = 10.0f;
    private static final long serialVersionUID = -4809619139509617929L;
    private static final double FUDGEFACTOR = 7.0;
    protected int _npoints = 0;
    protected int[] _xpoints = new int[4];
    protected int[] _ypoints = new int[4];
    protected boolean _rectilinear = false;
    public boolean _isComplete = false;
    protected boolean _isSelfLoop = false;
    protected int _fixedHandles = -1;
    private static Handle _TempHandle = new Handle(0);

    public FigPoly(Color lineColor) {
        this.setLineColor(lineColor);
    }

    public FigPoly(Color lineColor, Color fillColor) {
        this.setLineColor(lineColor);
        this.setFillColor(fillColor);
    }

    public FigPoly() {
    }

    public FigPoly(int x, int y) {
        this();
        this.addPoint(x, y);
    }

    @Override
    public Object clone() {
        FigPoly figClone = (FigPoly)super.clone();
        figClone._xpoints = (int[])this._xpoints.clone();
        figClone._ypoints = (int[])this._ypoints.clone();
        return figClone;
    }

    public Polygon getPolygon() {
        return new Polygon(this._xpoints, this._ypoints, this._npoints);
    }

    public void setPolygon(Polygon p) {
        this._npoints = p.npoints;
        this._xpoints = new int[this._npoints];
        this._ypoints = new int[this._npoints];
        System.arraycopy(p.xpoints, 0, this._xpoints, 0, this._npoints);
        System.arraycopy(p.ypoints, 0, this._ypoints, 0, this._npoints);
        this.calcBounds();
    }

    public void setSelfLoop(boolean self) {
        this._isSelfLoop = self;
    }

    @Override
    public int getNumPoints() {
        return this._npoints;
    }

    public boolean getRectilinear() {
        return this._rectilinear;
    }

    public void setRectilinear(boolean r) {
        this._rectilinear = r;
    }

    public int getFixedHandles() {
        return this._fixedHandles;
    }

    public void setFixedHandles(int n) {
        this._fixedHandles = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndPoints(Point start, Point end) {
        while (this._npoints < 2) {
            this.addPoint(start);
        }
        Handle handle = _TempHandle;
        synchronized (handle) {
            FigPoly._TempHandle.index = 0;
            this.moveVertex(_TempHandle, start.x, start.y, true);
            FigPoly._TempHandle.index = this._npoints - 1;
            this.moveVertex(_TempHandle, end.x, end.y, true);
        }
    }

    @Override
    protected void translateImpl(int dx, int dy) {
        Rectangle oldBounds = this.getBounds();
        int i = 0;
        while (i < this._npoints) {
            int n = i;
            this._xpoints[n] = this._xpoints[n] + dx;
            int n2 = i++;
            this._ypoints[n2] = this._ypoints[n2] + dy;
        }
        this._x += dx;
        this._y += dy;
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    @Override
    public void addPoint(int x, int y) {
        this.growIfNeeded();
        this._xpoints[this._npoints] = x;
        this._ypoints[this._npoints] = y;
        ++this._npoints;
        Rectangle oldBounds = this.getBounds();
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public final void addPoint(Point p) {
        this.addPoint(p.x, p.y);
    }

    protected boolean canMoveVertex(int i, boolean ov) {
        return i >= 0 && i < this._npoints && (ov || i >= this._fixedHandles && i < this._npoints - this._fixedHandles);
    }

    public void moveVertex(Handle h, int x, int y, boolean ov) {
        int i = h.index;
        if (!this._rectilinear) {
            this._xpoints[i] = x;
            this._ypoints[i] = y;
        } else {
            if (ov) {
                this._xpoints[i] = x;
                this._ypoints[i] = y;
            }
            if (i == this._fixedHandles) {
                this.prependTwoPoints();
                h.index += 2;
                i += 2;
            }
            if (i == this._npoints - this._fixedHandles - 1) {
                this.appendTwoPoints();
            }
            if (i % 2 == 0) {
                if (this.canMoveVertex(i - 1, ov)) {
                    this._xpoints[i - 1] = x;
                    this._xpoints[i] = x;
                }
                if (this.canMoveVertex(i + 1, ov)) {
                    this._ypoints[i + 1] = y;
                    this._ypoints[i] = y;
                }
            } else {
                if (this.canMoveVertex(i - 1, ov)) {
                    this._ypoints[i - 1] = y;
                    this._ypoints[i] = y;
                }
                if (this.canMoveVertex(i + 1, ov)) {
                    this._xpoints[i + 1] = x;
                    this._xpoints[i] = x;
                }
            }
        }
        Rectangle oldBounds = this.getBounds();
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    protected void prependTwoPoints() {
        int[] tmp = new int[this._npoints + 2];
        System.arraycopy(this._xpoints, 0, tmp, 2, this._npoints);
        this._xpoints = tmp;
        tmp = new int[this._npoints + 2];
        System.arraycopy(this._ypoints, 0, tmp, 2, this._npoints);
        this._ypoints = tmp;
        this._xpoints[0] = this._xpoints[1] = this._xpoints[2];
        this._ypoints[0] = this._ypoints[1] = this._ypoints[2];
        this._npoints += 2;
    }

    protected void appendTwoPoints() {
        int[] tmp = new int[this._npoints + 2];
        System.arraycopy(this._xpoints, 0, tmp, 0, this._npoints);
        this._xpoints = tmp;
        tmp = new int[this._npoints + 2];
        System.arraycopy(this._ypoints, 0, tmp, 0, this._npoints);
        this._ypoints = tmp;
        this._xpoints[this._npoints + 1] = this._xpoints[this._npoints] = this._xpoints[this._npoints - 1];
        this._ypoints[this._npoints + 1] = this._ypoints[this._npoints] = this._ypoints[this._npoints - 1];
        this._npoints += 2;
    }

    @Override
    public void removePoint(int i) {
        if (i < 0 || i >= this._npoints) {
            throw new IllegalArgumentException("Point not found in LayerDiagram");
        }
        if (this._npoints < 3) {
            return;
        }
        int[] tmp = new int[this._npoints];
        if (this._rectilinear && i != 0 && i != this._npoints - 1) {
            if (i % 2 == 0) {
                this._xpoints[i] = this._xpoints[i + 1];
                this._ypoints[i] = this._ypoints[i - 1];
            } else {
                this._xpoints[i] = this._xpoints[i - 1];
                this._ypoints[i] = this._ypoints[i + 1];
            }
        } else {
            System.arraycopy(this._xpoints, i + 1, tmp, 0, this._npoints - i - 1);
            System.arraycopy(tmp, 0, this._xpoints, i, this._npoints - i - 1);
            System.arraycopy(this._ypoints, i + 1, tmp, 0, this._npoints - i - 1);
            System.arraycopy(tmp, 0, this._ypoints, i, this._npoints - i - 1);
            --this._npoints;
        }
        Rectangle oldBounds = this.getBounds();
        this.calcBounds();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    @Override
    public void insertPoint(int i, int x, int y) {
        this.growIfNeeded();
        int[] tmp = new int[this._npoints];
        System.arraycopy(this._xpoints, i + 1, tmp, 0, this._npoints - i - 1);
        this._xpoints[i + 1] = x;
        System.arraycopy(tmp, 0, this._xpoints, i + 2, this._npoints - i - 1);
        System.arraycopy(this._ypoints, i + 1, tmp, 0, this._npoints - i - 1);
        this._ypoints[i + 1] = y;
        System.arraycopy(tmp, 0, this._ypoints, i + 2, this._npoints - i - 1);
        ++this._npoints;
        this.calcBounds();
    }

    protected void growIfNeeded() {
        if (this._npoints >= this._xpoints.length) {
            int[] tmp = new int[this._npoints * 2];
            System.arraycopy(this._xpoints, 0, tmp, 0, this._npoints);
            this._xpoints = tmp;
            tmp = new int[this._npoints * 2];
            System.arraycopy(this._ypoints, 0, tmp, 0, this._npoints);
            this._ypoints = tmp;
        }
    }

    @Override
    public Point getPoint(int i) {
        return new Point(this._xpoints[i], this._ypoints[i]);
    }

    public List<Point> getPointsList() {
        ArrayList<Point> res = new ArrayList<Point>(this._npoints);
        for (int i = 0; i < this._npoints; ++i) {
            res.add(new Point(this._xpoints[i], this._ypoints[i]));
        }
        return res;
    }

    @Override
    public Point[] getPoints() {
        Point[] points = new Point[this.getPointsList().size()];
        for (int i = 0; i < this._npoints; ++i) {
            points[i] = this.getPoint(i);
        }
        return points;
    }

    @Override
    public Point getFirstPoint() {
        return this.getPoint(0);
    }

    @Override
    public Point getLastPoint() {
        return this.getPoint(this._npoints - 1);
    }

    @Override
    public void setPoint(Handle h, int mX, int mY) {
        this.moveVertex(h, mX, mY, false);
    }

    @Override
    public void setPoints(Point[] points) {
        this._npoints = points.length;
        this._xpoints = new int[this._npoints];
        this._ypoints = new int[this._npoints];
        for (int i = 0; i < this._npoints; ++i) {
            this._xpoints[i] = points[i].x;
            this._ypoints[i] = points[i].y;
        }
        this.calcBounds();
    }

    @Override
    public void cleanUp() {
        for (int handleNumber = 1; handleNumber < this._npoints - 1; ++handleNumber) {
            double middleToEndAngle;
            Point start = new Point(this._xpoints[handleNumber - 1], this._ypoints[handleNumber - 1]);
            Point middle = new Point(this._xpoints[handleNumber], this._ypoints[handleNumber]);
            Point end = new Point(this._xpoints[handleNumber + 1], this._ypoints[handleNumber + 1]);
            if (start.equals(middle) || end.equals(middle)) {
                this.removePoint(handleNumber);
                break;
            }
            double startToMiddleAngle = Geometry.segmentAngle(start, middle);
            double difference = Geometry.diffAngle(startToMiddleAngle, middleToEndAngle = Geometry.segmentAngle(middle, end));
            if (!(difference < 7.0)) continue;
            this.removePoint(handleNumber);
        }
        this.calcBounds();
    }

    @Override
    public Point getClosestPoint(Point anotherPt) {
        return Geometry.ptClosestTo(this._xpoints, this._ypoints, this._npoints, anotherPt);
    }

    @Override
    public List getGravityPoints() {
        return this.getPointsList();
    }

    @Override
    public void paint(Graphics g) {
        if (this._filled && this._fillColor != null) {
            if (g instanceof Graphics2D) {
                Graphics2D g2 = (Graphics2D)g;
                Polygon poly = new Polygon(this.getXs(), this.getYs(), this.getNumPoints());
                Rectangle bb = poly.getBounds();
                Paint oldPaint = g2.getPaint();
                g2.setPaint(this.getDefaultPaint(this._fillColor, this._lineColor, bb.x, bb.y, bb.width, bb.height));
                g2.fill(poly);
                g2.setPaint(oldPaint);
            } else {
                g.setColor(this._fillColor);
                g.fillPolygon(this._xpoints, this._ypoints, this._npoints);
            }
        }
        if (this.getLineWidth() > 0 && this._lineColor != null) {
            g.setColor(this._lineColor);
            if (g instanceof Graphics2D) {
                float[] dashes = null;
                if (this.getDashed()) {
                    dashes = this._dashes;
                }
                this.drawPolyLine((Graphics2D)g, this.getLineWidth(), this._npoints, this._xpoints, this._ypoints, dashes, 0.0f);
            } else if (this.getDashed()) {
                this.drawDashedPerimeter(g, this.getLineWidth(), this._npoints, this._xpoints, this._ypoints, this._dashes, this._dashPeriod);
            } else {
                g.drawPolyline(this._xpoints, this._ypoints, this._npoints);
            }
        }
    }

    private void drawDashedPerimeter(Graphics g, int lineWidth, int pointCount, int[] xPoints, int[] yPoints, float[] dashes, int dashPeriod) {
        if (g instanceof Graphics2D) {
            this.drawPolyLine((Graphics2D)g, lineWidth, pointCount, xPoints, yPoints, dashes, 0.0f);
            return;
        }
        int phase = 0;
        for (int i = 1; i < pointCount; ++i) {
            phase = this.drawDashedLine(g, lineWidth, xPoints[i - 1], yPoints[i - 1], xPoints[i], yPoints[i], phase, dashes, dashPeriod);
        }
    }

    private void drawPolyLine(Graphics2D g2, float width, int pointCount, int[] xPoints, int[] yPoints, float[] dashes, float dash_phase) {
        GeneralPath gp = new GeneralPath();
        gp.reset();
        gp.moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < pointCount; ++i) {
            gp.lineTo(xPoints[i], yPoints[i]);
        }
        Stroke originalStroke = g2.getStroke();
        g2.setStroke(this.getDefaultStroke(width, dashes, dash_phase));
        g2.draw(gp);
        g2.setStroke(originalStroke);
    }

    @Override
    public void appendSvg(StringBuffer sb) {
        sb.append("<path id='").append(this.getId()).append("' class='").append(this.getClass().getName()).append("' style='fill:none; stroke-width:").append(this.getLineWidth()).append("; stroke:rgb(").append(this.getLineColor().getRed()).append(",").append(this.getLineColor().getGreen()).append(',').append(this.getLineColor().getBlue()).append(" ;' d='");
        for (int i = 0; i < this.getPoints().length; ++i) {
            if (i == 0) {
                sb.append("M ");
            } else {
                sb.append("L ");
            }
            sb.append(this.getPoint((int)i).x).append(',').append(this.getPoint((int)i).y);
        }
        sb.append(" ' />");
    }

    protected int findHandle(int x, int y) {
        int handleSize = 6;
        int[] xs = this._xpoints;
        int[] ys = this._ypoints;
        for (int i = 0; i < this._npoints; ++i) {
            if (x < xs[i] - handleSize / 2 || y < ys[i] - handleSize / 2 || x > xs[i] + handleSize / 2 || y > ys[i] + handleSize / 2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(int x, int y) {
        Polygon p = this.getPolygon();
        return p.contains(x, y);
    }

    @Override
    public int[] getXs() {
        return this._xpoints;
    }

    @Override
    public int[] getYs() {
        return this._ypoints;
    }

    @Override
    protected void setBoundsImpl(int x, int y, int w, int h) {
        Rectangle oldBounds = this.getBounds();
        if (w > 0 && h > 0) {
            for (int i = 0; i < this._npoints; ++i) {
                this._xpoints[i] = x + (this._xpoints[i] - this._x) * w / this._w;
                this._ypoints[i] = y + (this._ypoints[i] - this._y) * h / this._h;
            }
            this._x = x;
            this._y = y;
            this._w = w;
            this._h = h;
            this.firePropChange("bounds", oldBounds, this.getBounds());
        }
    }

    @Override
    public int getPerimeterLength() {
        int len = 0;
        for (int i = 0; i < this._npoints - 1; ++i) {
            int dx = this._xpoints[i + 1] - this._xpoints[i];
            int dy = this._ypoints[i + 1] - this._ypoints[i];
            len += (int)Math.sqrt(dx * dx + dy * dy);
        }
        return len;
    }

    @Override
    public void stuffPointAlongPerimeter(int dist, Point res) {
        for (int i = 0; i < this._npoints - 1; ++i) {
            int dx = this._xpoints[i + 1] - this._xpoints[i];
            int dy = this._ypoints[i + 1] - this._ypoints[i];
            int segLen = (int)Math.sqrt(dx * dx + dy * dy);
            if (dist < segLen) {
                if (segLen != 0) {
                    res.x = this._xpoints[i] + dx * dist / segLen;
                    res.y = this._ypoints[i] + dy * dist / segLen;
                    return;
                }
                res.x = this._xpoints[i];
                res.y = this._ypoints[i];
                return;
            }
            dist -= segLen;
        }
        res.x = this._xpoints[0];
        res.y = this._ypoints[0];
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public boolean isReshapable() {
        return true;
    }

    @Override
    public boolean isRotatable() {
        return false;
    }

    public boolean isPerimeterClosed() {
        if (this._xpoints.length < 1 || this._npoints < 1) {
            return false;
        }
        if (this._npoints <= this._xpoints.length) {
            return this._xpoints[0] == this._xpoints[this._npoints - 1] && this._ypoints[0] == this._ypoints[this._npoints - 1];
        }
        return this._xpoints[0] == this._xpoints[this._xpoints.length - 1] && this._ypoints[0] == this._ypoints[this._ypoints.length - 1];
    }

    public boolean isComplete() {
        return this._isComplete;
    }

    public void setComplete(boolean complete) {
        this._isComplete = complete;
    }

    @Override
    protected int countCornersContained(int x, int y, int w, int h) {
        if (!this.isPerimeterClosed()) {
            return 0;
        }
        Polygon p = this.getPolygon();
        int cornersHit = 0;
        if (p.contains(x, y)) {
            ++cornersHit;
        }
        if (p.contains(x + w, y)) {
            ++cornersHit;
        }
        if (p.contains(x, y + h)) {
            ++cornersHit;
        }
        if (p.contains(x + w, y + h)) {
            ++cornersHit;
        }
        return cornersHit;
    }

    @Override
    public boolean hit(Rectangle rect) {
        if (super.hit(rect)) {
            return true;
        }
        return this.intersectsPerimeter(rect);
    }

    @Override
    public boolean intersectsPerimeter(Rectangle rect) {
        for (int i = 1; i < this._npoints; ++i) {
            if (!rect.intersectsLine(this._xpoints[i - 1], this._ypoints[i - 1], this._xpoints[i], this._ypoints[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void calcBounds() {
        Rectangle polyBounds = this.getPolygon().getBounds();
        this._x = polyBounds.x;
        this._y = polyBounds.y;
        this._w = polyBounds.width;
        this._h = polyBounds.height;
    }
}

