/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import org.tigris.gef.presentation.Fig;

public class FigCircle
extends Fig {
    private static final long serialVersionUID = 7376986113799307733L;
    public static final double CIRCLE_ADJUST_RADIUS = 0.1;
    protected boolean _isDashed = false;

    public FigCircle(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public FigCircle(int x, int y, int w, int h, Color lColor, Color fColor) {
        super(x, y, w, h, lColor, fColor);
    }

    public FigCircle(int x, int y, int w, int h, boolean resizable) {
        super(x, y, w, h);
        this.resizable = resizable;
    }

    public FigCircle(int x, int y, int w, int h, boolean resizable, Color lColor, Color fColor) {
        super(x, y, w, h, lColor, fColor);
        this.resizable = resizable;
    }

    public void paint(Graphics g) {
        int lineWidth = this.getLineWidth();
        if (g instanceof Graphics2D) {
            this.paint((Graphics2D)g);
        } else if (this._filled && this._fillColor != null) {
            if (lineWidth > 0 && this._lineColor != null) {
                g.setColor(this._lineColor);
                g.fillOval(this._x, this._y, this._w, this._h);
            }
            if (!this._fillColor.equals(this._lineColor)) {
                g.setColor(this._fillColor);
                g.fillOval(this._x + lineWidth, this._y + lineWidth, this._w - lineWidth * 2, this._h - lineWidth * 2);
            }
        } else if (lineWidth > 0 && this._lineColor != null) {
            g.setColor(this._lineColor);
            g.drawOval(this._x, this._y, this._w, this._h);
        }
    }

    private void paint(Graphics2D g2) {
        int lineWidth = this.getLineWidth();
        Stroke oldStroke = g2.getStroke();
        Paint oldPaint = g2.getPaint();
        g2.setStroke(this.getDefaultStroke(lineWidth));
        if (this._filled && this._fillColor != null) {
            g2.setPaint(this.getDefaultPaint(this._fillColor, this._lineColor, this._x, this._y, this._w, this._h));
            g2.fill(new Ellipse2D.Float(this._x + lineWidth, this._y + lineWidth, this._w - 2 * lineWidth, this._h - 2 * lineWidth));
        }
        if (lineWidth > 0 && this._lineColor != null) {
            g2.setPaint(this._lineColor);
            g2.draw(new Ellipse2D.Float(this._x + lineWidth / 2, this._y + lineWidth / 2, this._w - lineWidth, this._h - lineWidth));
        }
        g2.setStroke(oldStroke);
        g2.setPaint(oldPaint);
    }

    public void appendSvg(StringBuffer sb) {
        sb.append("<ellipse id='").append(this.getId()).append("'");
        this.appendSvgStyle(sb);
        sb.append("cx='").append(this.getCenter().x).append("'").append("cy='").append(this.getCenter().y).append("'").append("rx='").append(this.getWidth() / 2).append("'").append("ry='").append(this.getHeight() / 2).append("' />");
    }

    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        double dx = (double)(this._x + this._w / 2 - x) * 2.0 / (double)this._w;
        double dy = (double)(this._y + this._h / 2 - y) * 2.0 / (double)this._h;
        double distSquared = dx * dx + dy * dy;
        return distSquared <= 1.01;
    }

    public Point connectionPoint(Point anotherPt) {
        double rx = this._w / 2;
        double ry = this._h / 2;
        double dx = (double)anotherPt.x - ((double)this._x + rx);
        double dy = (double)anotherPt.y - ((double)this._y + ry);
        double dd = ry * ry * dx * dx + rx * rx * dy * dy;
        double mu = rx * ry / Math.sqrt(dd);
        Point res = new Point((int)(mu * dx + (double)this._x + rx), (int)(mu * dy + (double)this._y + ry));
        return res;
    }
}

