/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import org.tigris.gef.presentation.Decoration;
import org.tigris.gef.presentation.Fig;

public abstract class ArrowHead
extends Decoration {
    public ArrowHead() {
    }

    public ArrowHead(Color line, Color fill) {
        super(line, fill);
    }

    public final void paintAtHead(Object g, Fig path) {
        this.paintAtHead((Graphics)g, path);
    }

    public void paintAtHead(Graphics g, Fig path) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(path.getLineWidth()));
            int[] xs = path.getXs();
            int[] ys = path.getYs();
            this.paint(g2, new Point(xs[1], ys[1]), new Point(xs[0], ys[0]), path.getLineColor(), path.getFillColor());
            g2.setStroke(oldStroke);
        } else {
            int[] xs = path.getXs();
            int[] ys = path.getYs();
            this.paint(g, new Point(xs[1], ys[1]), new Point(xs[0], ys[0]), path.getLineColor(), path.getFillColor());
        }
    }

    public final void paintAtTail(Object g, Fig path) {
        this.paintAtTail((Graphics)g, path);
    }

    public void paintAtTail(Graphics g, Fig path) {
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(path.getLineWidth()));
            int[] xs = path.getXs();
            int[] ys = path.getYs();
            int pointCount = path.getNumPoints();
            this.paint(g2, new Point(xs[pointCount - 2], ys[pointCount - 2]), new Point(xs[pointCount - 1], ys[pointCount - 1]), path.getLineColor(), path.getFillColor());
            g2.setStroke(oldStroke);
        } else {
            int pointCount = path.getNumPoints();
            int[] xs = path.getXs();
            int[] ys = path.getYs();
            this.paint(g, new Point(xs[pointCount - 2], ys[pointCount - 2]), new Point(xs[pointCount - 1], ys[pointCount - 1]), path.getLineColor(), path.getFillColor());
        }
    }
}

