/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Hashtable;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingMode;
import org.tigris.gef.base.ModeImpl;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.undo.UndoManager;

public class FigModifyingModeImpl
extends ModeImpl
implements FigModifyingMode {
    protected Editor editor;
    static final long serialVersionUID = 7960954871341784898L;

    public FigModifyingModeImpl(Editor par) {
        this.setEditor(par);
    }

    public FigModifyingModeImpl(Hashtable parameters) {
        this.init(parameters);
    }

    public FigModifyingModeImpl() {
    }

    public void done() {
        this.setCursor(Cursor.getDefaultCursor());
        this.editor.finishMode();
        UndoManager.getInstance().removeMementoLock(this);
    }

    public void setEditor(Editor w) {
        this.editor = w;
        this.setCursor(this.getInitialCursor());
    }

    public Editor getEditor() {
        return this.editor;
    }

    public Cursor getInitialCursor() {
        return Cursor.getDefaultCursor();
    }

    public String instructions() {
        return "FigModifyingMode: " + this.getClass().getName();
    }

    public void setCursor(Cursor c) {
        if (this.editor != null) {
            this.editor.setCursor(c);
        }
    }

    public void paint(Graphics g) {
        this.paint((Object)g);
    }

    public void print(Graphics g) {
        this.print((Object)g);
    }

    public final void paint(Object graphicsContext) {
    }

    public final void print(Object graphicsContext) {
        this.paint(graphicsContext);
    }

    public boolean isFigEnclosedIn(Fig testedFig, Fig enclosingFig) {
        Rectangle bbox = testedFig.getBounds();
        Rectangle trap = enclosingFig.getTrapRect();
        return trap != null && trap.contains(bbox.x, bbox.y) && trap.contains(bbox.x + bbox.width, bbox.y + bbox.height);
    }
}

