/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.mdr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.argouml.model.UmlException;
import org.argouml.model.XmiException;
import org.argouml.model.XmiReader;
import org.argouml.model.XmiReferenceException;
import org.argouml.model.XmiReferenceRuntimeException;
import org.argouml.model.mdr.MDRModelImplementation;
import org.argouml.model.mdr.XmiReferenceResolverImpl;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.xmi.XMIInputConfig;
import org.netbeans.api.xmi.XMIReader;
import org.netbeans.api.xmi.XMIReaderFactory;
import org.netbeans.api.xmi.XMIReferenceResolver;
import org.netbeans.lib.jmi.xmi.InputConfig;
import org.netbeans.lib.jmi.xmi.UnknownElementsListener;
import org.netbeans.lib.jmi.xmi.XMIHeaderConsumer;
import org.omg.uml.UmlPackage;
import org.openide.ErrorManager;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmiReaderImpl
implements XmiReader,
UnknownElementsListener,
XMIHeaderConsumer {
    static final String TEMP_XMI_FILE_PREFIX = "zargo_model_";
    private static final Logger LOG = Logger.getLogger(XmiReaderImpl.class);
    private static String tempXMIFileURIPrefix;
    private MDRModelImplementation modelImpl;
    private XmiReferenceResolverImpl resolver;
    private boolean unknownElement;
    private String unknownElementName;
    private boolean uml13;
    private String[] ignoredElements = new String[0];
    private int ignoredElementCount;
    private String xmiHeader;
    private static final String STYLE_PATH = "/org/argouml/model/mdr/conversions/";
    private static final String[] UML_13_ELEMENTS;

    XmiReaderImpl(MDRModelImplementation parentModelImplementation) {
        this.modelImpl = parentModelImplementation;
    }

    @Override
    public Collection parse(InputSource inputSource, boolean readOnly) throws UmlException {
        Collection<Object> newElements = Collections.emptyList();
        String extentBase = inputSource.getPublicId();
        if (extentBase == null) {
            extentBase = inputSource.getSystemId();
        }
        if (extentBase == null) {
            extentBase = "model extent";
        }
        String extentName = extentBase;
        UmlPackage extent = (UmlPackage)this.modelImpl.getRepository().getExtent(extentName);
        int serial = 1;
        while (extent != null) {
            extentName = extentBase + " " + serial;
            ++serial;
            extent = (UmlPackage)this.modelImpl.getRepository().getExtent(extentName);
        }
        extent = (UmlPackage)this.modelImpl.createExtent(extentName, readOnly);
        if (extent == null) {
            LOG.error((Object)("Failed to create extent " + extentName));
        }
        try {
            LOG.info((Object)("Loading to extent '" + extentName + "' " + extent));
            InputConfig config = new InputConfig();
            config.setUnknownElementsListener((UnknownElementsListener)this);
            config.setUnknownElementsIgnored(true);
            String pId = inputSource.getPublicId();
            String sId = this.modelImpl.getPublic2SystemIds().get(pId);
            if (sId != null) {
                if (sId.equals(inputSource.getSystemId())) {
                    LOG.info((Object)("Attempt to reread profile - ignoring - publicId = \"" + pId + "\";  systemId = \"" + sId + "\"."));
                    return Collections.emptySet();
                }
                throw new UmlException("Profile with the duplicate publicId is being loaded! publicId = \"" + pId + "\"; existing systemId = \"" + this.modelImpl.getPublic2SystemIds().get(pId) + "\"; new systemId = \"" + sId + "\".");
            }
            this.resolver = new XmiReferenceResolverImpl(new RefPackage[]{extent}, (XMIInputConfig)config, this.modelImpl.getObjectToId(), this.modelImpl.getPublic2SystemIds(), this.modelImpl.getIdToObject(), this.modelImpl.getSearchPath(), readOnly, inputSource.getPublicId(), inputSource.getSystemId(), this.modelImpl);
            config.setReferenceResolver((XMIReferenceResolver)this.resolver);
            config.setHeaderConsumer((XMIHeaderConsumer)this);
            XMIReader xmiReader = XMIReaderFactory.getDefault().createXMIReader((XMIInputConfig)config);
            InputConfig config2 = (InputConfig)xmiReader.getConfiguration();
            config2.setUnknownElementsListener((UnknownElementsListener)this);
            config2.setUnknownElementsIgnored(true);
            this.unknownElement = false;
            this.uml13 = false;
            this.ignoredElementCount = 0;
            this.modelImpl.getModelEventPump().stopPumpingEvents();
            try {
                String systemId = inputSource.getSystemId();
                if (inputSource.getByteStream() != null || inputSource.getCharacterStream() != null) {
                    File file = this.copySource(inputSource);
                    systemId = file.toURI().toURL().toExternalForm();
                    String publicId = inputSource.getPublicId();
                    inputSource = new InputSource(systemId);
                    inputSource.setPublicId(publicId);
                }
                MDRepository repository = this.modelImpl.getRepository();
                repository.beginTrans(true);
                newElements = xmiReader.read(inputSource.getByteStream(), systemId, (RefPackage)extent);
                if (this.uml13) {
                    repository.endTrans(true);
                    repository.beginTrans(true);
                    this.resolver.clearIdMaps();
                    newElements = this.convertAndLoadUml13(inputSource.getSystemId(), (RefPackage)extent, xmiReader, inputSource);
                }
                repository.endTrans();
            }
            catch (Throwable e) {
                try {
                    this.modelImpl.getRepository().endTrans(true);
                }
                catch (Throwable e2) {
                    // empty catch block
                }
                if (e instanceof MalformedXMIException) {
                    throw (MalformedXMIException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                e.printStackTrace();
                throw new MalformedXMIException();
            }
            finally {
                this.modelImpl.getModelEventPump().startPumpingEvents();
            }
            if (this.unknownElement) {
                this.modelImpl.deleteExtent(extent);
                throw new XmiException("Unknown element in XMI file : " + this.unknownElementName);
            }
            if (this.ignoredElementCount > 0) {
                LOG.warn((Object)("Ignored one or more elements from list " + this.ignoredElements));
            }
        }
        catch (MalformedXMIException e) {
            ErrorManager.Annotation[] annotations;
            for (ErrorManager.Annotation annotation : annotations = ErrorManager.getDefault().findAnnotations((Throwable)e)) {
                Throwable throwable = annotation.getStackTrace();
                if (throwable instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)throwable;
                    throw new XmiException(spe.getMessage(), spe.getPublicId(), spe.getSystemId(), spe.getLineNumber(), spe.getColumnNumber(), (Exception)((Object)e));
                }
                if (!(throwable instanceof SAXException)) continue;
                SAXException se = (SAXException)throwable;
                Exception e1 = se.getException();
                if (e1 instanceof XmiReferenceRuntimeException) {
                    String href = ((XmiReferenceRuntimeException)e1).getReference();
                    throw new XmiReferenceException(href, e);
                }
                throw new XmiException(se.getMessage(), se);
            }
            this.modelImpl.deleteExtent(extent);
            throw new XmiException(e);
        }
        catch (IOException e) {
            try {
                this.modelImpl.deleteExtent(extent);
            }
            catch (InvalidObjectException e2) {
                // empty catch block
            }
            throw new XmiException(e);
        }
        return newElements;
    }

    private Collection<RefObject> convertAndLoadUml13(String systemId, RefPackage extent, XMIReader xmiReader, InputSource input) throws FileNotFoundException, UmlException, IOException, MalformedXMIException {
        LOG.info((Object)"XMI file doesn't appear to be UML 1.4 - attempting UML 1.3->UML 1.4 conversion");
        String[] transformFiles = new String[]{"NormalizeNSUML.xsl", "uml13touml14.xsl"};
        this.unknownElement = false;
        InputSource xformedInput = this.serialTransform(transformFiles, input);
        xformedInput.setPublicId(input.getPublicId());
        return xmiReader.read(xformedInput.getByteStream(), xformedInput.getSystemId(), extent);
    }

    static String getTempXMIFileURIPrefix() {
        if (tempXMIFileURIPrefix == null) {
            tempXMIFileURIPrefix = new File(System.getProperty("java.io.tmpdir")).toURI() + TEMP_XMI_FILE_PREFIX;
        }
        return tempXMIFileURIPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getXMIUUIDToObjectMap() {
        if (this.resolver != null) {
            HashMap<String, Object> globalXmiIdToObjectMap = new HashMap<String, Object>(this.resolver.getIdToObjectMap());
            Map<String, Map<String, Object>> idToObjectMaps = this.resolver.getIdToObjectMaps();
            HashSet<Map.Entry<String, Map<String, Object>>> entrySet = null;
            Map<String, Map<String, Object>> map = idToObjectMaps;
            synchronized (map) {
                entrySet = new HashSet<Map.Entry<String, Map<String, Object>>>(idToObjectMaps.entrySet());
                for (Map.Entry entry : entrySet) {
                    entry.setValue(new HashMap((Map)entry.getValue()));
                }
            }
            for (Map.Entry entry : entrySet) {
                String string = ((String)entry.getKey()).startsWith(XmiReaderImpl.getTempXMIFileURIPrefix()) ? "" : (String)entry.getKey() + "#";
                for (Map.Entry innerMapEntry : ((Map)entry.getValue()).entrySet()) {
                    String id = string + (String)innerMapEntry.getKey();
                    if (globalXmiIdToObjectMap.containsKey(id)) continue;
                    globalXmiIdToObjectMap.put(id, innerMapEntry.getValue());
                }
            }
            return globalXmiIdToObjectMap;
        }
        return null;
    }

    private InputSource chainedTransform(String[] styles, InputSource input) throws XmiException {
        SAXTransformerFactory stf = (SAXTransformerFactory)TransformerFactory.newInstance();
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser parser = spf.newSAXParser();
            XMLReader last = parser.getXMLReader();
            for (int i = 0; i < styles.length; ++i) {
                String xsltFileName = STYLE_PATH + styles[i];
                URL xsltUrl = this.getClass().getResource(xsltFileName);
                if (xsltUrl == null) {
                    throw new IOException("Error opening XSLT style sheet : " + xsltFileName);
                }
                StreamSource xsltStreamSource = new StreamSource(xsltUrl.openStream());
                xsltStreamSource.setSystemId(xsltUrl.toExternalForm());
                XMLFilter filter = stf.newXMLFilter(xsltStreamSource);
                filter.setParent(last);
                last = filter;
            }
            SAXSource transformSource = new SAXSource(last, input);
            File tmpFile = File.createTempFile(TEMP_XMI_FILE_PREFIX, ".xmi");
            tmpFile.deleteOnExit();
            StreamResult result = new StreamResult(new FileOutputStream(tmpFile));
            Transformer transformer = stf.newTransformer();
            transformer.transform(transformSource, result);
            return new InputSource(new FileInputStream(tmpFile));
        }
        catch (SAXException e) {
            throw new XmiException(e);
        }
        catch (ParserConfigurationException e) {
            throw new XmiException(e);
        }
        catch (IOException e) {
            throw new XmiException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new XmiException(e);
        }
        catch (TransformerException e) {
            throw new XmiException(e);
        }
    }

    private InputSource serialTransform(String[] styles, InputSource input) throws UmlException {
        SAXSource myInput = new SAXSource(input);
        SAXTransformerFactory stf = (SAXTransformerFactory)TransformerFactory.newInstance();
        try {
            for (int i = 0; i < styles.length; ++i) {
                URL xsltUrl;
                String xsltFileName = STYLE_PATH + styles[i];
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Transforming with " + xsltFileName));
                }
                if ((xsltUrl = this.getClass().getResource(xsltFileName)) == null) {
                    throw new UmlException("Error opening XSLT style sheet : " + xsltFileName);
                }
                StreamSource xsltStreamSource = new StreamSource(xsltUrl.openStream());
                xsltStreamSource.setSystemId(xsltUrl.toExternalForm());
                File tmpOutFile = File.createTempFile(TEMP_XMI_FILE_PREFIX, ".xmi");
                tmpOutFile.deleteOnExit();
                StreamResult result = new StreamResult(new FileOutputStream(tmpOutFile));
                Transformer transformer = stf.newTransformer(xsltStreamSource);
                transformer.transform(myInput, result);
                LOG.info((Object)("Wrote converted XMI file - " + tmpOutFile + " converted using : " + xsltFileName));
                myInput = new SAXSource(new InputSource(new FileInputStream(tmpOutFile)));
                myInput.setSystemId(tmpOutFile.toURI().toURL().toExternalForm());
            }
            return myInput.getInputSource();
        }
        catch (IOException e) {
            throw new UmlException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new UmlException(e);
        }
        catch (TransformerException e) {
            throw new UmlException(e);
        }
    }

    private File copySource(InputSource input) throws IOException {
        int len;
        byte[] buf = new byte[2048];
        File tmpOutFile = File.createTempFile(TEMP_XMI_FILE_PREFIX, ".xmi");
        tmpOutFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tmpOutFile);
        String systemId = input.getSystemId();
        if (systemId != null) {
            input = new InputSource(new URL(systemId).openStream());
        }
        InputStream in = input.getByteStream();
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
        out.close();
        LOG.debug((Object)("Wrote copied XMI file to " + tmpOutFile));
        return tmpOutFile;
    }

    public void elementFound(String name) {
        int i;
        if (this.ignoredElements != null) {
            for (i = 0; i < this.ignoredElements.length; ++i) {
                if (!name.equals(this.ignoredElements[i])) continue;
                ++this.ignoredElementCount;
                return;
            }
        }
        if (name.startsWith("Foundation.")) {
            this.uml13 = true;
            return;
        }
        for (i = 0; i < UML_13_ELEMENTS.length; ++i) {
            if (!name.endsWith(UML_13_ELEMENTS[i])) continue;
            this.uml13 = true;
            return;
        }
        this.unknownElement = true;
        if (this.unknownElementName == null) {
            this.unknownElementName = name;
        }
        LOG.error((Object)("Unknown XMI element named : " + name));
    }

    @Override
    public boolean setIgnoredElements(String[] elementNames) {
        this.ignoredElements = elementNames == null ? new String[0] : elementNames;
        return true;
    }

    @Override
    public String[] getIgnoredElements() {
        return this.ignoredElements;
    }

    @Override
    public int getIgnoredElementCount() {
        return this.ignoredElementCount;
    }

    @Override
    public String getTagName() {
        return "XMI";
    }

    @Override
    public void addSearchPath(String path) {
        this.modelImpl.addSearchPath(path);
    }

    @Override
    public void removeSearchPath(String path) {
        this.modelImpl.removeSearchPath(path);
    }

    @Override
    public List<String> getSearchPath() {
        return this.modelImpl.getSearchPath();
    }

    public void consumeHeader(InputStream stream) {
        try {
            int length = stream.available();
            byte[] bytes = new byte[length];
            stream.read(bytes, 0, length);
            this.xmiHeader = new String(bytes);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception reading XMI file header", (Throwable)e);
        }
    }

    @Override
    public String getHeader() {
        return this.xmiHeader;
    }

    static {
        UML_13_ELEMENTS = new String[]{"TaggedValue.value", "TaggedValue.tag", "ModelElement.templateParameter2", "ModelElement.templateParameter3", "Classifier.structuralFeature", "Classifier.parameter", "AssociationEnd.type", "Node.resident", "ElementResidence.implementationLocation", "TemplateParameter.modelElement", "TemplateParameter.modelElement2", "Constraint.constrainedElement2", "UseCase.include2", "StateMachine.subMachineState", "ClassifierRole.message1", "ClassifierRole.message2", "Message.message3", "Message.message4", "ElementImport.modelElement", "ModelElement.elementResidence", "ModelElement.presentation", "ModelElement.supplierDependency", "ModelElement.templateParameter2", "ModelElement.templateParameter3", "ModelElement.binding", "GeneralizableElement.specialization", "Classifier.associationEnd", "Classifier.participant", "Operation.method", "Stereotype.extendedElement", "Stereotype.requiredTag", "TaggedValue.stereotype", "Signal.context", "Signal.reception", "Signal.sendAction", "UseCase.include2", "UseCase.extend2", "ExtensionPoint.extend", "Link.stimulus", "Instance.attributeLink", "Action.stimulus", "Event.state", "Event.transition", "Transition.state", "ClassifierRole.message1", "ClassifierRole.message2", "Message.message3", "Message.message4", "Action.state1", "Action.state2", "Action.state3", "Instance.stimulus1", "Instance.stimulus2", "Instance.stimulus3"};
    }
}

