/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.cpp.reveng;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.argouml.language.cpp.profile.ProfileCpp;
import org.argouml.language.cpp.reveng.MemberModeler;
import org.argouml.model.Model;

class OperationModeler
extends MemberModeler {
    private Object oper;
    private final boolean ignorable;

    boolean isIgnorable() {
        return this.ignorable;
    }

    Object getOperation() {
        return this.oper;
    }

    OperationModeler(Object theParent, Object visibility, Object returnType, boolean ignore, ProfileCpp theProfile) {
        super(theParent, visibility, theProfile);
        this.ignorable = ignore;
        if (!this.ignorable) {
            this.oper = this.buildOperation(this.getOwner(), returnType);
            Model.getCoreHelper().setLeaf(this.oper, true);
            if (visibility != null) {
                Model.getCoreHelper().setVisibility(this.oper, visibility);
            }
        }
    }

    Object buildOperation(Object me, Object returnType) {
        return Model.getCoreFactory().buildOperation(me, returnType);
    }

    void finish() {
        if (!this.isIgnorable()) {
            if (Model.getFacade().isLeaf(this.oper) && this.hasNonLeafBaseOperation(this.oper, this.getOwner())) {
                Model.getCoreHelper().setLeaf(this.oper, false);
            }
            this.removeOperationIfDuplicate(this.oper);
        }
    }

    boolean hasNonLeafBaseOperation(Object operation, Object clazz) {
        for (Object generalization : Model.getFacade().getGeneralizations(clazz)) {
            Object base = Model.getFacade().getGeneral(generalization);
            for (Object baseOper : Model.getFacade().getOperations(base)) {
                if (!Model.getFacade().getName(operation).equals(Model.getFacade().getName(baseOper)) || !this.equalParameters(operation, baseOper)) continue;
                return !Model.getFacade().isLeaf(baseOper);
            }
            if (!this.hasNonLeafBaseOperation(operation, base)) continue;
            return true;
        }
        return false;
    }

    void removeOperationIfDuplicate(Object operation) {
        for (Object possibleDuplicate : Model.getFacade().getOperations(this.getOwner())) {
            if (operation == possibleDuplicate || !Model.getFacade().getName(operation).equals(Model.getFacade().getName(possibleDuplicate)) || !this.equalParameters(operation, possibleDuplicate)) continue;
            Model.getCoreHelper().removeFeature(this.getOwner(), operation);
        }
    }

    private boolean equalParameters(Object oper1, Object oper2) {
        List parameters1 = Model.getFacade().getParametersList(oper1);
        List parameters2 = Model.getFacade().getParametersList(oper2);
        if (parameters1.size() == parameters2.size()) {
            Iterator it1 = parameters1.iterator();
            Iterator it2 = parameters2.iterator();
            while (it1.hasNext()) {
                Object parameter2;
                Object parameter1 = it1.next();
                if (this.equalParameter(parameter1, parameter2 = it2.next())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean equalParameter(Object parameter1, Object parameter2) {
        if (Model.getFacade().getName(parameter1) != null && Model.getFacade().getName(parameter1).equals(Model.getFacade().getName(parameter2))) {
            return this.equalTaggedValues(Model.getFacade().getTaggedValuesCollection(parameter1), Model.getFacade().getTaggedValuesCollection(parameter2));
        }
        if (Model.getFacade().getName(parameter1) == null && Model.getFacade().getName(parameter2) == null) {
            return this.equalTaggedValues(Model.getFacade().getTaggedValuesCollection(parameter1), Model.getFacade().getTaggedValuesCollection(parameter2));
        }
        return false;
    }

    private boolean equalTaggedValues(Collection taggedValues1, Collection taggedValues2) {
        return true;
    }

    void declarationSpecifiers(List declSpecs) {
        if (declSpecs.contains("virtual")) {
            Model.getCoreHelper().setLeaf(this.oper, false);
        }
    }

    void setType(Object theType) {
        super.setType(theType);
        this.setReturnType();
    }

    private void setReturnType() {
        Object rv = Model.getCoreHelper().getReturnParameters(this.oper).iterator().next();
        Model.getCoreHelper().setType(rv, this.getType());
    }

    void setDefinedInClass() {
        if (!this.isIgnorable()) {
            this.getProfile().applyCppOperationStereotype(this.getOperation());
            this.getProfile().applyInlineTaggedValue2Operation(this.getOperation(), "defInClass");
        }
    }
}

