/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Component;
import javax.swing.JComponent;
import org.tigris.swidgets.Horizontal;
import org.tigris.swidgets.Orientation;
import org.tigris.swidgets.Splitter;
import org.tigris.swidgets.SplitterLayout;
import org.tigris.swidgets.Vertical;

public class MultipleSplitPane
extends JComponent {
    public static final Orientation HORIZONTAL_SPLIT = Horizontal.getInstance();
    public static final Orientation VERTICAL_SPLIT = Vertical.getInstance();
    private Splitter[] splitterArray;

    public MultipleSplitPane(Component[] componentArray) {
        this(componentArray.length);
    }

    public MultipleSplitPane(Component[] componentArray, Orientation orientation) {
        this(componentArray.length, orientation);
    }

    public MultipleSplitPane(int n) {
        this(n, HORIZONTAL_SPLIT);
    }

    public MultipleSplitPane(int n, Orientation orientation) {
        this.setLayout(new SplitterLayout(orientation));
        int n2 = n - 1;
        if (n2 >= 0) {
            this.splitterArray = new Splitter[n - 1];
            for (int i = 0; i < n2; ++i) {
                this.splitterArray[i] = new Splitter(orientation);
                this.add(this.splitterArray[i]);
            }
        }
        if (n2 > 1) {
            this.splitterArray[0].setQuickHide(0);
            this.splitterArray[n2 - 1].setQuickHide(1);
        }
    }

    public Component add(Component component, int n) {
        if (!(component instanceof Splitter)) {
            SplitterLayout splitterLayout = (SplitterLayout)this.getLayout();
            if (n > 0) {
                n = splitterLayout.getComponentPosition(this.splitterArray[n - 1]) + 1;
            }
        }
        if (n < this.getComponentCount() && !(this.getComponent(n) instanceof Splitter)) {
            super.remove(n);
        }
        return super.add(component, n);
    }

    public void add(Component component, Object object, int n) {
        if (!(component instanceof Splitter)) {
            SplitterLayout splitterLayout = (SplitterLayout)this.getLayout();
            if (n > 0) {
                n = splitterLayout.getComponentPosition(this.splitterArray[n - 1]) + 1;
            }
        }
        if (n < this.getComponentCount() && !(this.getComponent(n) instanceof Splitter)) {
            super.remove(n);
        }
        super.add(component, object, n);
    }

    public void remove(int n) {
        SplitterLayout splitterLayout = (SplitterLayout)this.getLayout();
        if ((n = n >= this.splitterArray.length ? splitterLayout.getComponentPosition(this.splitterArray[n - 1]) + 1 : splitterLayout.getComponentPosition(this.splitterArray[n]) - 1) >= 0 && !(this.getComponent(n) instanceof Splitter)) {
            super.remove(n);
        }
    }

    public void remove(Component component) {
        Component component2 = null;
        int n = this.getComponents().length;
        for (int i = 0; i < n; ++i) {
            Component component3 = this.getComponents()[i];
            if (component3 == component) {
                super.remove(i);
                if (component2 instanceof Splitter) {
                    super.remove(i - 1);
                } else if (i + 1 < n && this.getComponents()[i] instanceof Splitter) {
                    super.remove(i);
                }
                return;
            }
            component2 = component3;
        }
    }
}

