/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public abstract class DecoratedIcon
extends ImageIcon {
    public static final int ROLLOVER = 0;
    public static final int STANDARD = 1;
    private int[][] imageBuffer;
    private int popupIconWidth = 11;
    private int popupIconHeight = 16;
    private int popupIconOffset = 5;
    private ImageIcon imageIcon;

    DecoratedIcon(ImageIcon imageIcon) {
        this.imageIcon = imageIcon;
    }

    protected void init(int[][] nArray) {
        this.imageBuffer = nArray;
        this.popupIconWidth = this.imageBuffer[0].length;
        this.popupIconHeight = this.imageBuffer.length;
        BufferedImage bufferedImage = new BufferedImage(this.imageIcon.getIconWidth() + this.popupIconOffset + this.popupIconWidth, this.imageIcon.getIconHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(this.imageIcon.getImage(), null, null);
        this.setImage(bufferedImage);
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        super.paintIcon(component, graphics, n, n2);
        int n3 = n + this.imageIcon.getIconWidth() + this.popupIconOffset;
        Color[] colorArray = new Color[]{component.getBackground(), UIManager.getColor("controlDkShadow"), UIManager.getColor("infoText"), UIManager.getColor("controlHighlight")};
        for (int i = 0; i < this.popupIconWidth; ++i) {
            for (int j = 0; j < this.popupIconHeight; ++j) {
                if (this.imageBuffer[j][i] == 0) continue;
                graphics.setColor(colorArray[this.imageBuffer[j][i]]);
                graphics.drawLine(n3 + i, n2 + j, n3 + i, n2 + j);
            }
        }
    }
}

