/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.toolbutton;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.tigris.toolbar.ToolBar;
import org.tigris.toolbar.ToolBarManager;
import org.tigris.toolbar.toolbutton.ModalButton;
import org.tigris.toolbar.toolbutton.PopupToolBox;
import org.tigris.toolbar.toolbutton.ToolButton;

public class OverflowButton
extends ToolButton {
    private static final long serialVersionUID = -684520584458885655L;
    private ToolBar toolBar;
    private static final int X = 2;
    private static final int Y = 6;

    public OverflowButton(ToolBar toolBar, boolean bl) {
        super((Action)null);
        this.toolBar = toolBar;
        super.setAction(new OverflowAction());
    }

    private void popup() {
        EventListener eventListener;
        Component[] componentArray = this.toolBar.getOverflowActions();
        PopupToolBox popupToolBox = new PopupToolBox(componentArray.length, 1, this.isRolloverEnabled());
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JButton)) continue;
            eventListener = ((JButton)componentArray[i]).getAction();
            popupToolBox.add((Action)eventListener);
        }
        final JPopupMenu jPopupMenu = new JPopupMenu();
        eventListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Component component = mouseEvent.getComponent();
                if (component instanceof ModalButton) {
                    Action action = ((ModalButton)component).getRealAction();
                    OverflowButton.this.setAction(action);
                    action.putValue("popped", true);
                    OverflowButton.this.setSelected(true);
                    ButtonModel buttonModel = OverflowButton.this.getModel();
                    buttonModel.setRollover(true);
                    if (!ToolBarManager.alwaysUseStandardRollover()) {
                        OverflowButton.this.setBorderPainted(true);
                    }
                    buttonModel.setArmed(true);
                }
                jPopupMenu.setVisible(false);
            }
        };
        popupToolBox.setButtonMouseListener((MouseListener)eventListener);
        popupToolBox.rebuild();
        jPopupMenu.add(popupToolBox);
        jPopupMenu.show(this, 0, this.getHeight());
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(UIManager.getColor("controlText"));
        for (int i = 0; i < 5; ++i) {
            this.dualDrawLine(graphics, 2 + (2 - Math.abs(i - 2)), i + 6);
        }
    }

    private void dualDrawLine(Graphics graphics, int n, int n2) {
        graphics.drawLine(n, n2, n + 1, n2);
        graphics.drawLine(n + 4, n2, n + 5, n2);
    }

    private class OverflowAction
    extends AbstractAction {
        private static final long serialVersionUID = 3031308217208709369L;

        OverflowAction() {
            super(" ");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OverflowButton.this.popup();
        }
    }
}

