/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.query;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.netbeans.lib.jmi.query.Query;
import org.netbeans.lib.jmi.query.QueryIterator;

public class UnionQuery
implements Query {
    Query[] queries;

    public UnionQuery(Query queryA, Query queryB) {
        this.queries = new Query[]{queryA, queryB};
    }

    public UnionQuery(Query[] queries) {
        this.queries = queries;
    }

    public Iterator iterator() {
        return new UnionIterator();
    }

    public boolean contains(Object object) {
        for (int i = 0; i < this.queries.length; ++i) {
            if (!this.queries[i].contains(object)) continue;
            return true;
        }
        return false;
    }

    private class UnionIterator
    extends QueryIterator {
        int index = 0;
        Iterator current = null;

        UnionIterator() {
            if (UnionQuery.this.queries.length > 0) {
                this.current = UnionQuery.this.queries[0].iterator();
            }
        }

        public boolean hasNext() {
            if (this.current == null) {
                return false;
            }
            if (this.current.hasNext()) {
                return true;
            }
            ++this.index;
            if (this.index >= UnionQuery.this.queries.length) {
                this.current = null;
                return false;
            }
            this.current = UnionQuery.this.queries[this.index].iterator();
            return this.hasNext();
        }

        public Object next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            if (this.current.hasNext()) {
                return this.current.next();
            }
            ++this.index;
            if (this.index >= UnionQuery.this.queries.length) {
                this.current = null;
                throw new NoSuchElementException();
            }
            this.current = UnionQuery.this.queries[this.index].iterator();
            return this.next();
        }
    }
}

