/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.transformer;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.apache.log4j.Logger;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.model.Model;
import org.argouml.transformer.Transformer;
import org.argouml.transformer.TransformerAction;
import org.argouml.uml.diagram.DiagramSettings;
import org.argouml.uml.diagram.state.ui.FigCompositeState;
import org.argouml.uml.diagram.state.ui.FigSimpleState;
import org.argouml.uml.diagram.state.ui.FigTransition;
import org.argouml.uml.diagram.ui.FigEdgeModelElement;
import org.argouml.uml.diagram.ui.FigNodeModelElement;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleStateTransformer
implements Transformer {
    private static final Logger LOG = Logger.getLogger(SimpleStateTransformer.class);

    SimpleStateTransformer() {
    }

    @Override
    public List<Action> actions(Project p, Object sourceModelElement) {
        assert (Model.getFacade().isASimpleState(sourceModelElement));
        ArrayList<Action> result = new ArrayList<Action>();
        result.add((Action)((Object)new SimpleStateToCompositeState(p, sourceModelElement)));
        return result;
    }

    @Override
    public boolean canTransform(Object sourceModelElement) {
        return Model.getFacade().isASimpleState(sourceModelElement);
    }

    class SimpleStateToCompositeState
    extends TransformerAction {
        SimpleStateToCompositeState(Project project, Object sourceModelElement) {
            super(Translator.localize((String)"transform.button.new-compositestate"), project, sourceModelElement);
        }

        public void actionPerformed(ActionEvent e) {
            LOG.debug((Object)"Transforming a SimpleState into a CompositeState");
            super.actionPerformed(e);
            Object entry = Model.getFacade().getEntry(this.getSource());
            Object exit = Model.getFacade().getExit(this.getSource());
            ArrayList deferEvts = new ArrayList(Model.getFacade().getDeferrableEvents(this.getSource()));
            ArrayList intTrans = new ArrayList(Model.getFacade().getInternalTransitions(this.getSource()));
            Object doActivity = Model.getFacade().getDoActivity(this.getSource());
            Object sm = Model.getFacade().getStateMachine(this.getSource());
            Object container = Model.getFacade().getContainer(this.getSource());
            ArrayList outgoings = new ArrayList(Model.getFacade().getOutgoings(this.getSource()));
            ArrayList incomings = new ArrayList(Model.getFacade().getIncomings(this.getSource()));
            outgoings.removeAll(intTrans);
            incomings.removeAll(intTrans);
            LOG.debug((Object)("Transformer found " + intTrans.size() + " internal transitions."));
            LOG.debug((Object)("Transformer found " + incomings.size() + " incoming transitions."));
            LOG.debug((Object)("Transformer found " + outgoings.size() + " outgoing transitions."));
            String name = Model.getFacade().getName(this.getSource());
            Object cs = Model.getStateMachinesFactory().buildCompositeState(container);
            Model.getStateMachinesHelper().setEntry(this.getSource(), null);
            Model.getStateMachinesHelper().setEntry(cs, entry);
            Model.getStateMachinesHelper().setExit(this.getSource(), null);
            Model.getStateMachinesHelper().setExit(cs, exit);
            for (Object de : deferEvts) {
                Model.getStateMachinesHelper().removeDeferrableEvent(this.getSource(), de);
                Model.getStateMachinesHelper().addDeferrableEvent(cs, de);
            }
            Model.getStateMachinesHelper().setInternalTransitions(this.getSource(), (Collection)Collections.EMPTY_LIST);
            Model.getStateMachinesHelper().setInternalTransitions(cs, intTrans);
            Model.getStateMachinesHelper().setDoActivity(this.getSource(), null);
            Model.getStateMachinesHelper().setDoActivity(cs, doActivity);
            Model.getStateMachinesHelper().setStateMachine(cs, sm);
            for (Object to : outgoings) {
                Model.getStateMachinesHelper().setSource(to, null);
                Model.getStateMachinesHelper().setSource(to, cs);
            }
            for (Object ti : incomings) {
                Model.getCommonBehaviorHelper().setTarget(ti, null);
                Model.getCommonBehaviorHelper().setTarget(ti, cs);
            }
            Model.getCoreHelper().setName(cs, name);
            Collection figs = this.getProject().findAllPresentationsFor(this.getSource());
            LOG.debug((Object)("Transformer found " + figs.size() + " representations (Figs)."));
            for (Fig ssFig : figs) {
                LOG.debug((Object)("Transformer found a Fig: " + ssFig));
                assert (ssFig.getOwner() == this.getSource());
                assert (ssFig instanceof FigSimpleState);
                Rectangle bounds = ssFig.getBounds();
                DiagramSettings settings = ((FigNodeModelElement)ssFig).getSettings();
                Layer lay = ssFig.getLayer();
                ssFig.removeFromDiagram();
                FigCompositeState fcs = new FigCompositeState(cs, bounds, settings);
                lay.add((Fig)fcs);
                fcs.setBounds(bounds);
                ((LayerPerspective)lay).putInPosition((Fig)fcs);
                fcs.renderingChanged();
                for (Object to : outgoings) {
                    this.makeTransition(settings, lay, to);
                }
                for (Object ti : incomings) {
                    this.makeTransition(settings, lay, ti);
                }
            }
            Model.getUmlFactory().delete(this.getSource());
        }

        private void makeTransition(DiagramSettings settings, Layer lay, Object transUml) {
            FigTransition transFig = new FigTransition(transUml, settings);
            this.setPorts(lay, (FigEdge)transFig);
            lay.add((Fig)transFig);
            transFig.computeRoute();
            transFig.renderingChanged();
        }

        protected final void setPorts(Layer layer, FigEdge newEdge) {
            Object modelElement = newEdge.getOwner();
            if (newEdge.getSourcePortFig() == null) {
                Object tSource = Model.getUmlHelper().getSource(modelElement);
                FigNode sourceNode = this.getNodePresentationFor(layer, tSource);
                assert (sourceNode != null) : "No FigNode found for " + tSource;
                this.setSourcePort(newEdge, sourceNode);
            }
            if (newEdge.getDestPortFig() == null) {
                Object tDest = Model.getUmlHelper().getDestination(newEdge.getOwner());
                this.setDestPort(newEdge, this.getNodePresentationFor(layer, tDest));
            }
            if (newEdge.getSourcePortFig() == null || newEdge.getDestPortFig() == null) {
                throw new IllegalStateException("Edge of type " + newEdge.getClass().getName() + " created with no source or destination port");
            }
        }

        private void setSourcePort(FigEdge edge, FigNode source) {
            edge.setSourcePortFig((Fig)source);
            edge.setSourceFigNode(source);
        }

        private void setDestPort(FigEdge edge, FigNode dest) {
            edge.setDestPortFig((Fig)dest);
            edge.setDestFigNode(dest);
        }

        private FigNode getNodePresentationFor(Layer lay, Object modelElement) {
            assert (modelElement != null) : "A modelElement must be supplied";
            for (Object fig : lay.getContentsNoEdges()) {
                if (!(fig instanceof FigNode) || !modelElement.equals(((FigNode)fig).getOwner())) continue;
                return (FigNode)fig;
            }
            for (Object fig : lay.getContentsEdgesOnly()) {
                if (!(fig instanceof FigEdgeModelElement) || !modelElement.equals(((FigEdgeModelElement)fig).getOwner())) continue;
                return ((FigEdgeModelElement)fig).getEdgePort();
            }
            return null;
        }
    }
}

