/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import org.apache.log4j.Logger;
import org.argouml.core.propertypanels.ui.UMLLinkedList;
import org.argouml.core.propertypanels.ui.UMLModelElementListModel;
import org.argouml.model.Model;
import org.argouml.uml.ui.AbstractActionAddModelElement2;
import org.argouml.uml.ui.AbstractActionNewModelElement;
import org.argouml.uml.ui.AbstractActionRemoveElement;

class UMLMutableLinkedList
extends UMLLinkedList
implements MouseListener {
    private static final Logger LOG = Logger.getLogger(UMLMutableLinkedList.class);
    private boolean deletePossible = true;
    private boolean addPossible = false;
    private boolean newPossible = false;
    private JPopupMenu popupMenu;
    private AbstractActionAddModelElement2 addAction = null;
    private AbstractActionNewModelElement newAction = null;
    private AbstractActionRemoveElement deleteAction = null;

    public UMLMutableLinkedList(DefaultListModel dataModel, AbstractActionAddModelElement2 theAddAction, AbstractActionNewModelElement theNewAction, AbstractActionRemoveElement theDeleteAction) {
        super((ListModel)dataModel, true);
        this.setAddAction(theAddAction);
        this.setNewAction(theNewAction);
        this.deleteAction = theDeleteAction;
        this.addMouseListener(this);
    }

    public UMLMutableLinkedList(UMLModelElementListModel dataModel, AbstractActionAddModelElement2 theAddAction, AbstractActionNewModelElement theNewAction) {
        this(dataModel, theAddAction, theNewAction, null);
    }

    public UMLMutableLinkedList(UMLModelElementListModel dataModel, AbstractActionAddModelElement2 theAddAction) {
        this(dataModel, theAddAction, null, null);
    }

    public UMLMutableLinkedList(UMLModelElementListModel dataModel, AbstractActionNewModelElement theNewAction) {
        this(dataModel, null, theNewAction, null);
    }

    protected UMLMutableLinkedList(UMLModelElementListModel dataModel) {
        this(dataModel, dataModel.getAddAction(), dataModel.getNewAction(), dataModel.getRemoveAction());
    }

    public UMLMutableLinkedList(UMLModelElementListModel dataModel, JPopupMenu popup, boolean showIcon) {
        super((ListModel)dataModel, showIcon);
        this.setPopupMenu(popup);
    }

    public UMLMutableLinkedList(UMLModelElementListModel dataModel, JPopupMenu popup) {
        this(dataModel, popup, false);
    }

    public boolean isAdd() {
        return this.addAction != null && this.addPossible;
    }

    public boolean isDelete() {
        return this.deleteAction != null & this.deletePossible;
    }

    public boolean isNew() {
        return this.newAction != null && this.newPossible;
    }

    public AbstractActionAddModelElement2 getAddAction() {
        return this.addAction;
    }

    public AbstractActionNewModelElement getNewAction() {
        return this.newAction;
    }

    public void setAddAction(AbstractActionAddModelElement2 action) {
        if (action != null) {
            this.addPossible = true;
        }
        this.addAction = action;
    }

    public void setNewAction(AbstractActionNewModelElement action) {
        if (action != null) {
            this.newPossible = true;
        }
        this.newAction = action;
    }

    protected void initActions() {
        if (this.isAdd()) {
            this.addAction.setTarget(this.getTarget());
        }
        if (this.isNew()) {
            this.newAction.setTarget(this.getTarget());
        }
        if (this.isDelete()) {
            this.deleteAction.setObjectToRemove(this.getSelectedValue());
            this.deleteAction.setTarget(this.getTarget());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() && !Model.getModelManagementHelper().isReadOnly(this.getTarget())) {
            Point point = e.getPoint();
            int index = this.locationToIndex(point);
            JPopupMenu popup = this.getPopupMenu();
            ListModel model = this.getModel();
            if (model instanceof UMLModelElementListModel) {
                ((UMLModelElementListModel)model).buildPopup(popup, index);
            }
            if (popup.getComponentCount() > 0) {
                this.initActions();
                LOG.info((Object)("Showing popup at " + e.getX() + "," + e.getY()));
                popup.show(this, e.getX(), e.getY());
            }
            e.consume();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() && !Model.getModelManagementHelper().isReadOnly(this.getTarget())) {
            JPopupMenu popup = this.getPopupMenu();
            if (popup.getComponentCount() > 0) {
                this.initActions();
                LOG.debug((Object)("Showing popup at " + e.getX() + "," + e.getY()));
                this.getPopupMenu().show(this, e.getX(), e.getY());
            }
            e.consume();
        }
    }

    public JPopupMenu getPopupMenu() {
        this.popupMenu = new PopupMenu();
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu menu) {
        this.popupMenu = menu;
    }

    public AbstractActionRemoveElement getDeleteAction() {
        return this.deleteAction;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger() && !Model.getModelManagementHelper().isReadOnly(this.getTarget())) {
            JPopupMenu popup = this.getPopupMenu();
            if (popup.getComponentCount() > 0) {
                this.initActions();
                LOG.info((Object)("Showing popup at " + e.getX() + "," + e.getY()));
                this.getPopupMenu().show(this, e.getX(), e.getY());
            }
            e.consume();
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private class PopupMenu
    extends JPopupMenu {
        public PopupMenu() {
            if (UMLMutableLinkedList.this.isAdd()) {
                UMLMutableLinkedList.this.addAction.setTarget(UMLMutableLinkedList.this.getTarget());
                this.add((Action)UMLMutableLinkedList.this.addAction);
                if (UMLMutableLinkedList.this.isNew() || UMLMutableLinkedList.this.isDelete()) {
                    this.addSeparator();
                }
            }
            if (UMLMutableLinkedList.this.isNew()) {
                UMLMutableLinkedList.this.newAction.setTarget(UMLMutableLinkedList.this.getTarget());
                this.add((Action)UMLMutableLinkedList.this.newAction);
                if (UMLMutableLinkedList.this.isDelete()) {
                    this.addSeparator();
                }
            }
            if (UMLMutableLinkedList.this.isDelete()) {
                UMLMutableLinkedList.this.deleteAction.setObjectToRemove(UMLMutableLinkedList.this.getSelectedValue());
                UMLMutableLinkedList.this.deleteAction.setTarget(UMLMutableLinkedList.this.getTarget());
                this.add((Action)UMLMutableLinkedList.this.deleteAction);
            }
        }
    }
}

