/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.csharp.importer.csparser.main;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.argouml.language.csharp.importer.csparser.collections.ExpressionList;
import org.argouml.language.csharp.importer.csparser.collections.NodeCollection;
import org.argouml.language.csharp.importer.csparser.collections.ParseStateCollection;
import org.argouml.language.csharp.importer.csparser.collections.Stack;
import org.argouml.language.csharp.importer.csparser.collections.TokenCollection;
import org.argouml.language.csharp.importer.csparser.enums.IntegralType;
import org.argouml.language.csharp.importer.csparser.enums.Modifier;
import org.argouml.language.csharp.importer.csparser.enums.TokenID;
import org.argouml.language.csharp.importer.csparser.interfaces.IMemberAccessible;
import org.argouml.language.csharp.importer.csparser.interfaces.IType;
import org.argouml.language.csharp.importer.csparser.main.FeatureNotSupportedException;
import org.argouml.language.csharp.importer.csparser.main.Token;
import org.argouml.language.csharp.importer.csparser.members.AccessorNode;
import org.argouml.language.csharp.importer.csparser.members.ConstantNode;
import org.argouml.language.csharp.importer.csparser.members.ConstructorNode;
import org.argouml.language.csharp.importer.csparser.members.DestructorNode;
import org.argouml.language.csharp.importer.csparser.members.EventNode;
import org.argouml.language.csharp.importer.csparser.members.FieldNode;
import org.argouml.language.csharp.importer.csparser.members.IndexerNode;
import org.argouml.language.csharp.importer.csparser.members.InterfaceEventNode;
import org.argouml.language.csharp.importer.csparser.members.InterfaceIndexerNode;
import org.argouml.language.csharp.importer.csparser.members.InterfaceMethodNode;
import org.argouml.language.csharp.importer.csparser.members.InterfacePropertyNode;
import org.argouml.language.csharp.importer.csparser.members.MethodNode;
import org.argouml.language.csharp.importer.csparser.members.OperatorNode;
import org.argouml.language.csharp.importer.csparser.members.ParamDeclNode;
import org.argouml.language.csharp.importer.csparser.members.PropertyNode;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.ArgumentNode;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.ArrayCreationExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.ArrayInitializerExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.AssignmentExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.BaseAccessExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.BinaryExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.CheckedExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.ConditionalExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.ConstantExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.ElementAccessExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.ExpressionNode;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.IdentifierExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.InvocationExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.MemberAccessExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.ObjectCreationExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.OutNode;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.ParenthesizedExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.PostDecrementExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.PostIncrementExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.PrimaryExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.RefNode;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.TypeNode;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.TypeOfExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.UnaryCastExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.UnaryExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.UncheckedExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.primitive.BooleanPrimitive;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.primitive.CharPrimitive;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.primitive.IntegralPrimitive;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.primitive.NullPrimitive;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.primitive.RealPrimitive;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.primitive.StringPrimitive;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.primitive.VoidPrimitive;
import org.argouml.language.csharp.importer.csparser.preprocessornodes.PPDefineNode;
import org.argouml.language.csharp.importer.csparser.preprocessornodes.PPEndIfNode;
import org.argouml.language.csharp.importer.csparser.preprocessornodes.PPNode;
import org.argouml.language.csharp.importer.csparser.statements.BlockStatement;
import org.argouml.language.csharp.importer.csparser.statements.BreakStatement;
import org.argouml.language.csharp.importer.csparser.statements.CaseNode;
import org.argouml.language.csharp.importer.csparser.statements.CatchNode;
import org.argouml.language.csharp.importer.csparser.statements.CheckedStatement;
import org.argouml.language.csharp.importer.csparser.statements.ContinueStatement;
import org.argouml.language.csharp.importer.csparser.statements.DoStatement;
import org.argouml.language.csharp.importer.csparser.statements.ExpressionStatement;
import org.argouml.language.csharp.importer.csparser.statements.FinallyNode;
import org.argouml.language.csharp.importer.csparser.statements.ForEachStatement;
import org.argouml.language.csharp.importer.csparser.statements.ForStatement;
import org.argouml.language.csharp.importer.csparser.statements.GotoStatement;
import org.argouml.language.csharp.importer.csparser.statements.IfStatement;
import org.argouml.language.csharp.importer.csparser.statements.LabeledStatement;
import org.argouml.language.csharp.importer.csparser.statements.LocalDeclarationStatement;
import org.argouml.language.csharp.importer.csparser.statements.LockStatement;
import org.argouml.language.csharp.importer.csparser.statements.ReturnStatement;
import org.argouml.language.csharp.importer.csparser.statements.StatementNode;
import org.argouml.language.csharp.importer.csparser.statements.SwitchStatement;
import org.argouml.language.csharp.importer.csparser.statements.ThrowNode;
import org.argouml.language.csharp.importer.csparser.statements.TryStatement;
import org.argouml.language.csharp.importer.csparser.statements.UncheckedStatement;
import org.argouml.language.csharp.importer.csparser.statements.UsingStatement;
import org.argouml.language.csharp.importer.csparser.statements.WhileStatement;
import org.argouml.language.csharp.importer.csparser.structural.AttributeArgumentNode;
import org.argouml.language.csharp.importer.csparser.structural.AttributeNode;
import org.argouml.language.csharp.importer.csparser.structural.CompilationUnitNode;
import org.argouml.language.csharp.importer.csparser.structural.NamespaceNode;
import org.argouml.language.csharp.importer.csparser.structural.UsingDirectiveNode;
import org.argouml.language.csharp.importer.csparser.types.ClassNode;
import org.argouml.language.csharp.importer.csparser.types.DelegateNode;
import org.argouml.language.csharp.importer.csparser.types.EnumNode;
import org.argouml.language.csharp.importer.csparser.types.InterfaceNode;
import org.argouml.language.csharp.importer.csparser.types.StructNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    boolean success = true;
    public static Token EOF = new Token(254);
    private static Hashtable<Integer, Long> modMap;
    private static Hashtable<String, Byte> preprocessor;
    private static Hashtable<String, Byte> ppDefs;
    private static int[] precedence;
    private CompilationUnitNode cu;
    private TokenCollection tokens;
    private List<String> strings;
    private java.util.Stack<NamespaceNode> namespaceStack;
    private java.util.Stack<ClassNode> typeStack;
    private Stack<ExpressionNode> exprStack;
    public ParseStateCollection CurrentState;
    private InterfaceNode curInterface;
    private Token curtok;
    private long curmods;
    private NodeCollection<AttributeNode> curAttributes;
    private int index = 0;
    private boolean isLocalConst = false;
    private int lineCount = 1;
    private boolean ppCondition = false;
    private boolean inPPDirective = false;

    public Parser() {
        modMap = new Hashtable();
        modMap.put(103, Modifier.New);
        modMap.put(107, Modifier.Public);
        modMap.put(9, Modifier.Partial);
        modMap.put(108, Modifier.Protected);
        modMap.put(102, Modifier.Internal);
        modMap.put(106, Modifier.Private);
        modMap.put(97, Modifier.Abstract);
        modMap.put(112, Modifier.Sealed);
        modMap.put(111, Modifier.Static);
        modMap.put(114, Modifier.Virtual);
        modMap.put(105, Modifier.Override);
        modMap.put(99, Modifier.Extern);
        modMap.put(110, Modifier.Readonly);
        modMap.put(113, Modifier.Volatile);
        modMap.put(109, Modifier.Ref);
        modMap.put(104, Modifier.Out);
        modMap.put(160, Modifier.Assembly);
        modMap.put(163, Modifier.Field);
        modMap.put(153, Modifier.Event);
        modMap.put(162, Modifier.Method);
        modMap.put(164, Modifier.Param);
        modMap.put(161, Modifier.Property);
        modMap.put(142, Modifier.Return);
        modMap.put(165, Modifier.Type);
        precedence = new int[255];
        Parser.precedence[91] = 144;
        Parser.precedence[40] = 128;
        Parser.precedence[42] = 127;
        Parser.precedence[47] = 127;
        Parser.precedence[37] = 127;
        Parser.precedence[43] = 126;
        Parser.precedence[45] = 126;
        Parser.precedence[72] = 125;
        Parser.precedence[74] = 125;
        Parser.precedence[60] = 124;
        Parser.precedence[62] = 124;
        Parser.precedence[55] = 124;
        Parser.precedence[56] = 124;
        Parser.precedence[53] = 123;
        Parser.precedence[54] = 123;
        Parser.precedence[38] = 122;
        Parser.precedence[94] = 121;
        Parser.precedence[124] = 120;
        Parser.precedence[50] = 119;
        Parser.precedence[51] = 118;
        preprocessor = new Hashtable();
        preprocessor.put("define", (byte)1);
        preprocessor.put("undef", (byte)2);
        preprocessor.put("if", (byte)3);
        preprocessor.put("elif", (byte)4);
        preprocessor.put("else", (byte)5);
        preprocessor.put("endif", (byte)6);
        preprocessor.put("line", (byte)7);
        preprocessor.put("error", (byte)8);
        preprocessor.put("warning", (byte)9);
        preprocessor.put("region", (byte)10);
        preprocessor.put("endregion", (byte)11);
        preprocessor.put("pragma", (byte)12);
    }

    public CompilationUnitNode parse(TokenCollection tokens, List<String> strings) throws FeatureNotSupportedException {
        this.tokens = tokens;
        this.strings = strings;
        this.curmods = Modifier.Empty;
        this.curAttributes = new NodeCollection();
        this.CurrentState = new ParseStateCollection();
        this.cu = new CompilationUnitNode();
        this.namespaceStack = new java.util.Stack();
        this.namespaceStack.push(this.cu.DefaultNamespace);
        this.typeStack = new java.util.Stack();
        this.exprStack = new Stack();
        this.advance();
        this.parseNamespaceOrTypes();
        return this.cu;
    }

    private void parseNamespaceOrTypes() throws FeatureNotSupportedException {
        block11: while (!this.curtok.equals(EOF)) {
            this.parsePossibleAttributes(true);
            if (this.curAttributes.size() > 0) {
                for (AttributeNode an : this.curAttributes) {
                    this.cu.attributes.add(an);
                }
                this.curAttributes.clear();
            }
            switch (this.curtok.id) {
                case 159: {
                    this.parseUsingDirectives();
                    continue block11;
                }
                case 9: 
                case 97: 
                case 102: 
                case 103: 
                case 106: 
                case 107: 
                case 108: 
                case 111: 
                case 112: {
                    this.curmods |= modMap.get(this.curtok.id).longValue();
                    this.advance();
                    continue block11;
                }
                case 154: {
                    this.parseNamespace();
                    continue block11;
                }
                case 115: {
                    this.parseClass();
                    continue block11;
                }
                case 119: {
                    this.parseStruct();
                    continue block11;
                }
                case 118: {
                    this.parseInterface();
                    continue block11;
                }
                case 117: {
                    this.parseEnum();
                    continue block11;
                }
                case 116: {
                    this.parseDelegate();
                    continue block11;
                }
                case 59: {
                    this.advance();
                    continue block11;
                }
            }
            return;
        }
    }

    private void parseUsingDirectives() throws FeatureNotSupportedException {
        do {
            this.advance();
            UsingDirectiveNode node = new UsingDirectiveNode();
            IdentifierExpression nameOrAlias = this.parseQualifiedIdentifier();
            if (this.curtok.id == 61) {
                this.advance();
                IdentifierExpression target = this.parseQualifiedIdentifier();
                node.setAliasName(nameOrAlias);
                node.Target = target;
            } else {
                node.Target = nameOrAlias;
            }
            this.AssertAndAdvance(59);
            this.cu.UsingDirectives.add(node);
        } while (this.curtok.id == 159);
    }

    private PPNode parsePreprocessorDirective() throws FeatureNotSupportedException {
        PPNode result = null;
        int startLine = this.lineCount;
        this.inPPDirective = true;
        this.advance();
        IdentifierExpression ie = this.parseIdentifierOrKeyword();
        String ppKind = ie.Identifier[0];
        byte id = 0;
        if (preprocessor.containsKey(ppKind)) {
            id = preprocessor.get(ppKind);
        } else {
            this.ReportError("Preprocessor directive must be valid identifier, rather than \"" + ppKind + "\".");
        }
        switch (id) {
            case 1: {
                IdentifierExpression def = this.parseIdentifierOrKeyword();
                if (!ppDefs.containsKey(def.Identifier[0])) {
                    ppDefs.put(def.Identifier[0], (byte)0);
                }
                result = new PPDefineNode(def);
                break;
            }
            case 2: {
                IdentifierExpression undef = this.parseIdentifierOrKeyword();
                if (ppDefs.containsKey(undef.Identifier[0])) {
                    ppDefs.remove(undef.Identifier[0]);
                }
                result = new PPDefineNode(undef);
                break;
            }
            case 3: {
                if (this.curtok.id == 40) {
                    this.advance();
                }
                int startCount = this.lineCount;
                this.ppCondition = false;
                IdentifierExpression ifexpr = this.parseIdentifierOrKeyword();
                if (ppDefs.containsKey(ifexpr.Identifier[0])) {
                    this.ppCondition = true;
                }
                if (this.curtok.id == 41) {
                    this.advance();
                }
                if (this.ppCondition) break;
                this.SkipToElseOrEndIf();
                break;
            }
            case 4: {
                this.SkipToEOL(startLine);
                break;
            }
            case 5: {
                if (!this.ppCondition) break;
                this.SkipToElseOrEndIf();
                break;
            }
            case 6: {
                result = new PPEndIfNode();
                this.ppCondition = false;
                break;
            }
            case 7: {
                this.SkipToEOL(startLine);
                break;
            }
            case 8: {
                this.SkipToEOL(startLine);
                break;
            }
            case 9: {
                this.SkipToEOL(startLine);
                break;
            }
            case 10: {
                this.SkipToEOL(startLine);
                break;
            }
            case 11: {
                this.SkipToEOL(startLine);
                break;
            }
            case 12: {
                this.SkipToEOL(startLine);
                break;
            }
        }
        this.inPPDirective = false;
        return result;
    }

    private void parsePossibleAttributes(boolean isGlobal) throws FeatureNotSupportedException {
        while (this.curtok.id == 91) {
            long attribMask;
            this.advance();
            this.curmods = this.parseAttributeModifiers();
            if (!(isGlobal && this.curmods == Modifier.GlobalAttributeMods || (this.curmods & (attribMask = Modifier.AttributeMods ^ 0xFFFFFFFFFFFFFFFFL)) == Modifier.Empty)) {
                this.ReportError("Attribute contains illegal modifiers.");
            }
            long curAttribMods = this.curmods;
            this.curmods = Modifier.Empty;
            if (curAttribMods != Modifier.Empty) {
                this.AssertAndAdvance(58);
            }
            AttributeNode node = new AttributeNode();
            this.curAttributes.add(node);
            node.Modifiers = curAttribMods;
            while (this.curtok.id != 93 && this.curtok.id != 254) {
                node.Name = this.parseQualifiedIdentifier();
                if (this.curtok.id == 40) {
                    this.advance();
                    while (this.curtok.id != 41 && this.curtok.id != 254) {
                        AttributeArgumentNode aNode = new AttributeArgumentNode();
                        if (this.tokens.size() > this.index + 2 && this.curtok.id == 5 && ((Token)this.tokens.get((int)this.index)).id == 61) {
                            aNode.ArgumentName = this.parseQualifiedIdentifier();
                            this.advance();
                        }
                        aNode.Expression = this.ParseExpression();
                        node.Arguments.add(aNode);
                        if (this.curtok.id != 44) continue;
                        this.advance();
                    }
                    this.AssertAndAdvance(41);
                    if (this.tokens.size() > this.index + 2 && this.curtok.id == 44 && ((Token)this.tokens.get((int)this.index)).id != 93) {
                        this.advance();
                        node = new AttributeNode();
                        this.curAttributes.add(node);
                        node.Modifiers = curAttribMods;
                    }
                }
                if (this.curtok.id != 44) continue;
                this.advance();
            }
            this.AssertAndAdvance(93);
        }
    }

    private void parseNamespace() throws FeatureNotSupportedException {
        if (this.curmods != Modifier.Empty) {
            this.ReportError("Namespace can not contain modifiers");
        }
        NamespaceNode node = new NamespaceNode();
        if (this.cu.Namespaces.size() == 1 && this.cu.Namespaces.get(0) == this.cu.DefaultNamespace) {
            this.cu.Namespaces.clear();
        }
        this.cu.Namespaces.add(node);
        this.namespaceStack.push(node);
        this.advance();
        node.Name = this.parseQualifiedIdentifier();
        this.AssertAndAdvance(123);
        this.parseNamespaceOrTypes();
        this.AssertAndAdvance(125);
        this.namespaceStack.pop();
    }

    private void parseClass() throws FeatureNotSupportedException {
        long classMask = Modifier.ClassMods ^ 0xFFFFFFFFFFFFFFFFL;
        if ((this.curmods & classMask) != Modifier.Empty) {
            this.ReportError("Class contains illegal modifiers.");
        }
        ClassNode node = new ClassNode();
        this.typeStack.push(node);
        this.namespaceStack.peek().Classes.add(node);
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        node.Modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        this.advance();
        node.Name = this.parseQualifiedIdentifier();
        if (this.curtok.id == 58) {
            this.advance();
            node.BaseClasses.add(this.parseType());
            while (this.curtok.id == 44) {
                this.advance();
                node.BaseClasses.add(this.parseType());
            }
        }
        this.AssertAndAdvance(123);
        while (this.curtok.id != 125) {
            this.parseClassMember();
        }
        this.AssertAndAdvance(125);
        this.typeStack.pop();
    }

    private void parseInterface() throws FeatureNotSupportedException {
        InterfaceNode node = new InterfaceNode();
        this.namespaceStack.peek().Interfaces.add(node);
        this.curInterface = node;
        long interfaceMask = Modifier.InterfaceMods ^ 0xFFFFFFFFFFFFFFFFL;
        if ((this.curmods & interfaceMask) != Modifier.Empty) {
            this.ReportError("Interface contains illegal modifiers");
        }
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        node.Modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        this.advance();
        node.Name = this.parseQualifiedIdentifier();
        if (this.curtok.id == 58) {
            this.advance();
            node.BaseClasses.add(this.parseType());
            while (this.curtok.id == 44) {
                this.advance();
                node.BaseClasses.add(this.parseType());
            }
        }
        this.AssertAndAdvance(123);
        while (this.curtok.id != 125) {
            this.parseInterfaceMember();
        }
        this.AssertAndAdvance(125);
        this.curInterface = null;
    }

    private void parseStruct() throws FeatureNotSupportedException {
        StructNode node = new StructNode();
        this.typeStack.push(node);
        this.namespaceStack.peek().Structs.add(node);
        long structMask = Modifier.StructMods ^ 0xFFFFFFFFFFFFFFFFL;
        if ((this.curmods & structMask) != Modifier.Empty) {
            this.ReportError("Struct contains illegal modifiers");
        }
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        node.Modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        this.advance();
        node.Name = this.parseQualifiedIdentifier();
        if (this.curtok.id == 58) {
            this.advance();
            node.BaseClasses.add(this.parseType());
            while (this.curtok.id == 44) {
                this.advance();
                node.BaseClasses.add(this.parseType());
            }
        }
        this.AssertAndAdvance(123);
        while (this.curtok.id != 125) {
            this.parseClassMember();
        }
        this.AssertAndAdvance(125);
        this.typeStack.pop();
    }

    private void parseEnum() throws FeatureNotSupportedException {
        long enumMask;
        EnumNode node = new EnumNode();
        this.namespaceStack.peek().Enums.add(node);
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        if ((this.curmods & (enumMask = Modifier.EnumMods ^ 0xFFFFFFFFFFFFFFFFL)) != Modifier.Empty) {
            this.ReportError("Enum contains illegal modifiers");
        }
        node.Modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        this.advance();
        node.Name = this.parseQualifiedIdentifier();
        if (this.curtok.id == 58) {
            this.advance();
            node.BaseClass = this.parseType();
        }
        this.AssertAndAdvance(123);
        while (this.curtok.id != 125) {
            this.parseEnumMember();
        }
        this.AssertAndAdvance(125);
        if (this.curtok.id == 59) {
            this.advance();
        }
    }

    private void parseDelegate() throws FeatureNotSupportedException {
        long delegateMask;
        DelegateNode node = new DelegateNode();
        this.namespaceStack.peek().Delegates.add(node);
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        if ((this.curmods & (delegateMask = Modifier.DelegateMods ^ 0xFFFFFFFFFFFFFFFFL)) != Modifier.Empty) {
            this.ReportError("Delegate contains illegal modifiers");
        }
        node.Modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        this.advance();
        node.Type = this.parseType();
        node.Name = this.parseQualifiedIdentifier();
        node.Params = this.parseParamList();
        this.AssertAndAdvance(59);
    }

    private void parseClassMember() throws FeatureNotSupportedException {
        this.parsePossibleAttributes(false);
        this.parseModifiers();
        block0 : switch (this.curtok.id) {
            case 115: {
                this.parseClass();
                break;
            }
            case 118: {
                this.parseInterface();
                break;
            }
            case 119: {
                this.parseStruct();
                break;
            }
            case 117: {
                this.parseEnum();
                break;
            }
            case 116: {
                this.parseDelegate();
                break;
            }
            case 98: {
                this.parseConst();
                break;
            }
            case 153: {
                this.parseEvent();
                break;
            }
            case 126: {
                this.parseDestructor();
                break;
            }
            case 100: 
            case 101: {
                this.parseOperatorDecl(null);
                break;
            }
            default: {
                TypeNode type = this.parseType();
                if (type == null) {
                    this.ReportError("Expected type or ident in member definition");
                }
                switch (this.curtok.id) {
                    case 155: {
                        this.parseOperatorDecl(type);
                        break block0;
                    }
                    case 40: {
                        this.parseCtor(type);
                        break block0;
                    }
                    case 149: {
                        this.parseIndexer(type, null);
                        break block0;
                    }
                }
                IdentifierExpression name2 = this.parseQualifiedIdentifier();
                if (name2 == null) {
                    this.ReportError("Expected name or ident in member definition");
                }
                switch (this.curtok.id) {
                    case 149: {
                        this.parseIndexer(type, name2);
                        break block0;
                    }
                    case 44: 
                    case 59: 
                    case 61: {
                        this.parseField(type, name2);
                        break block0;
                    }
                    case 40: {
                        this.parseMethod(type, name2);
                        break block0;
                    }
                    case 123: {
                        this.parseProperty(type, name2);
                        break block0;
                    }
                }
                this.ReportError("Invalid member syntax");
            }
        }
    }

    private void parseInterfaceMember() throws FeatureNotSupportedException {
        this.parsePossibleAttributes(false);
        this.parseModifiers();
        block0 : switch (this.curtok.id) {
            case 153: {
                InterfaceEventNode node = new InterfaceEventNode();
                this.curInterface.Events.add(node);
                if (this.curAttributes.size() > 0) {
                    node.attributes = this.curAttributes;
                    this.curAttributes = new NodeCollection();
                }
                node.modifiers = this.curmods;
                this.curmods = Modifier.Empty;
                this.AssertAndAdvance(153);
                node.type = this.parseType();
                node.names.add(this.parseQualifiedIdentifier());
                this.AssertAndAdvance(59);
                break;
            }
            default: {
                TypeNode type = this.parseType();
                if (type == null) {
                    this.ReportError("Expected type or ident in interface member definition.");
                }
                switch (this.curtok.id) {
                    case 149: {
                        InterfaceIndexerNode iiNode = new InterfaceIndexerNode();
                        if (this.curAttributes.size() > 0) {
                            iiNode.attributes = this.curAttributes;
                            this.curAttributes = new NodeCollection();
                        }
                        iiNode.type = type;
                        this.advance();
                        iiNode.params = this.parseParamList(91, 93);
                        Boolean[] bx = new Boolean[2];
                        this.parseInterfaceAccessors(bx);
                        iiNode.hasGetter = bx[0];
                        iiNode.hasSetter = bx[1];
                        break block0;
                    }
                }
                IdentifierExpression name = this.parseQualifiedIdentifier();
                if (name == null) {
                    this.ReportError("Expected name or ident in member definition.");
                }
                switch (this.curtok.id) {
                    case 40: {
                        InterfaceMethodNode mnode = new InterfaceMethodNode();
                        this.curInterface.Methods.add(mnode);
                        if (this.curAttributes.size() > 0) {
                            mnode.attributes = this.curAttributes;
                            this.curAttributes = new NodeCollection();
                        }
                        mnode.modifiers = this.curmods;
                        this.curmods = Modifier.Empty;
                        mnode.names.add(name);
                        mnode.type = type;
                        mnode.params = this.parseParamList();
                        this.AssertAndAdvance(59);
                        break block0;
                    }
                    case 123: {
                        InterfacePropertyNode pnode = new InterfacePropertyNode();
                        this.curInterface.Properties.add(pnode);
                        if (this.curAttributes.size() > 0) {
                            pnode.attributes = this.curAttributes;
                            this.curAttributes = new NodeCollection();
                        }
                        pnode.modifiers = this.curmods;
                        this.curmods = Modifier.Empty;
                        pnode.names.add(name);
                        pnode.type = type;
                        Boolean[] bx = new Boolean[2];
                        this.parseInterfaceAccessors(bx);
                        this.parseInterfaceAccessors(bx);
                        pnode.hasGetter = bx[0];
                        pnode.hasSetter = bx[1];
                        if (this.curtok.id != 59) break block0;
                        this.AssertAndAdvance(59);
                        break block0;
                    }
                    default: {
                        this.ReportError("Invalid interface member syntax.");
                    }
                }
            }
        }
    }

    private void parseCtor(TypeNode type) throws FeatureNotSupportedException {
        long mask;
        ConstructorNode node = new ConstructorNode();
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        if ((this.curmods & Modifier.Static) != Modifier.Empty) {
            node.isStaticConstructor = true;
            this.curmods &= Modifier.Static ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if ((this.curmods & (mask = Modifier.ConstructorMods ^ 0xFFFFFFFFFFFFFFFFL)) != Modifier.Empty) {
            this.ReportError("constructor declaration contains illegal modifiers");
        }
        this.typeStack.peek().Constructors.add(node);
        node.modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        node.type = type;
        node.names.add(this.typeStack.peek().Name);
        node.params = this.parseParamList();
        if (this.curtok.id == 58) {
            this.advance();
            if (this.curtok.id == 121) {
                this.advance();
                node.hasBase = true;
                node.thisBaseArgs = this.parseArgs();
            } else if (this.curtok.id == 149) {
                this.advance();
                node.hasThis = true;
                node.thisBaseArgs = this.parseArgs();
            } else {
                this.RecoverFromError("constructor requires this or base calls after colon", 121);
            }
        }
        this.parseBlock(node.statementBlock);
    }

    private void parseDestructor() throws FeatureNotSupportedException {
        long mask;
        this.advance();
        DestructorNode node = new DestructorNode();
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        if ((this.curmods & (mask = Modifier.DestructorMods ^ 0xFFFFFFFFFFFFFFFFL)) != Modifier.Empty) {
            this.ReportError("destructor declaration contains illegal modifiers");
        }
        this.typeStack.peek().Destructors.add(node);
        node.modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        if (this.curtok.id == 5) {
            node.names.add(this.parseQualifiedIdentifier());
        } else {
            this.ReportError("Destructor requires identifier as name.");
        }
        this.AssertAndAdvance(40);
        this.AssertAndAdvance(41);
        this.parseBlock(node.statementBlock);
    }

    private void parseOperatorDecl(TypeNode type) throws FeatureNotSupportedException {
        long mask;
        OperatorNode node = new OperatorNode();
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        if ((this.curmods & (mask = Modifier.OperatorMods ^ 0xFFFFFFFFFFFFFFFFL)) != Modifier.Empty) {
            this.ReportError("operator declaration contains illegal modifiers");
        }
        node.modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        if (type == null && this.curtok.id == 100) {
            this.advance();
            node.isExplicit = true;
            this.AssertAndAdvance(155);
            type = this.parseType();
        } else if (type == null && this.curtok.id == 101) {
            this.advance();
            node.isImplicit = true;
            this.AssertAndAdvance(155);
            type = this.parseType();
        } else {
            this.AssertAndAdvance(155);
            node.operator = this.curtok.id;
            this.advance();
        }
        NodeCollection<ParamDeclNode> paramList = this.parseParamList();
        if (paramList.size() == 0 || paramList.size() > 2) {
            this.ReportError("operator declarations must only have one or two parameters.");
        }
        node.param1 = (ParamDeclNode)paramList.get(0);
        if (paramList.size() == 2) {
            node.param2 = (ParamDeclNode)paramList.get(1);
        }
        this.parseBlock(node.statements);
    }

    private void parseIndexer(TypeNode type, IdentifierExpression interfaceType) throws FeatureNotSupportedException {
        long mask;
        IndexerNode node = new IndexerNode();
        this.typeStack.peek().Indexers.add(node);
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        if ((this.curmods & (mask = Modifier.IndexerMods ^ 0xFFFFFFFFFFFFFFFFL)) != Modifier.Empty) {
            this.ReportError("indexer declaration contains illegal modifiers");
        }
        node.modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        node.type = type;
        if (interfaceType != null) {
            node.interfaceType = new TypeNode(interfaceType);
        }
        this.AssertAndAdvance(149);
        node.params = this.parseParamList(91, 93);
        this.AssertAndAdvance(123);
        if (this.curtok.id != 5) {
            this.RecoverFromError("At least one get or set required in accessor", this.curtok.id);
        }
        boolean parsedGet = false;
        if (this.strings.get(this.curtok.data).equals("get")) {
            node.getter = this.parseAccessor();
            parsedGet = true;
        }
        if (this.curtok.id == 5 && this.strings.get(this.curtok.data).equals("set")) {
            node.getter = this.parseAccessor();
        }
        if (!parsedGet && this.curtok.id == 5 && this.strings.get(this.curtok.data).equals("get")) {
            node.getter = this.parseAccessor();
        }
        this.AssertAndAdvance(125);
    }

    private void parseMethod(TypeNode type, IdentifierExpression name) throws FeatureNotSupportedException {
        long mask = Modifier.MethodMods ^ 0xFFFFFFFFFFFFFFFFL;
        if ((this.curmods & mask) != Modifier.Empty) {
            this.ReportError("method declaration contains illegal modifiers");
        }
        MethodNode node = new MethodNode();
        this.typeStack.peek().Methods.add(node);
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        node.modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        node.type = type;
        node.names.add(name);
        node.params = this.parseParamList();
        this.parseBlock(node.statementBlock);
    }

    private void parseField(TypeNode type, IdentifierExpression name) throws FeatureNotSupportedException {
        long mask = Modifier.FieldMods ^ 0xFFFFFFFFFFFFFFFFL;
        if ((this.curmods & mask) != Modifier.Empty) {
            this.ReportError("field declaration contains illegal modifiers");
        }
        FieldNode node = new FieldNode();
        this.typeStack.peek().Fields.add(node);
        node.modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        node.type = type;
        node.names.add(name);
        if (this.curtok.id == 61) {
            this.advance();
            node.Value = this.parseConstExpr();
            if (this.curtok.id == 44) {
                node = new FieldNode();
                this.typeStack.peek().Fields.add(node);
                node.modifiers = this.curmods;
                node.type = type;
            }
        }
        while (this.curtok.id == 44) {
            this.advance();
            IdentifierExpression ident = this.parseQualifiedIdentifier();
            node.names.add(ident);
            if (this.curtok.id != 61) continue;
            this.advance();
            node.Value = this.parseConstExpr();
            if (this.curtok.id != 44) continue;
            node = new FieldNode();
            this.typeStack.peek().Fields.add(node);
            node.modifiers = this.curmods;
            node.type = type;
        }
        if (this.curtok.id == 59) {
            this.advance();
        }
    }

    private void parseProperty(TypeNode type, IdentifierExpression name) throws FeatureNotSupportedException {
        long mask = Modifier.PropertyMods ^ 0xFFFFFFFFFFFFFFFFL;
        if ((this.curmods & mask) != Modifier.Empty) {
            this.ReportError("field declaration contains illegal modifiers");
        }
        PropertyNode node = new PropertyNode();
        this.typeStack.peek().Properties.add(node);
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        node.modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        node.type = type;
        node.names.add(name);
        this.AssertAndAdvance(123);
        this.parsePossibleAttributes(false);
        if (this.curAttributes.size() > 0) {
            this.curAttributes = new NodeCollection();
        }
        if (this.curtok.id != 5) {
            this.RecoverFromError("At least one get or set required in accessor", this.curtok.id);
        }
        boolean parsedGet = false;
        if (this.strings.get(this.curtok.data).equals("get")) {
            node.getter = this.parseAccessor();
            parsedGet = true;
        }
        this.parsePossibleAttributes(false);
        if (this.curAttributes.size() > 0) {
            this.curAttributes = new NodeCollection();
        }
        if (this.curtok.id == 5 && this.strings.get(this.curtok.data).equals("set")) {
            node.setter = this.parseAccessor();
        }
        this.parsePossibleAttributes(false);
        if (this.curAttributes.size() > 0) {
            this.curAttributes = new NodeCollection();
        }
        if (!parsedGet && this.curtok.id == 5 && this.strings.get(this.curtok.data).equals("get")) {
            node.getter = this.parseAccessor();
        }
        this.AssertAndAdvance(125);
    }

    private void parseEvent() throws FeatureNotSupportedException {
        long mask = Modifier.EventMods ^ 0xFFFFFFFFFFFFFFFFL;
        if ((this.curmods & mask) != Modifier.Empty) {
            this.ReportError("Event contains illegal modifiers");
        }
        EventNode node = new EventNode();
        this.typeStack.peek().Events.add(node);
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        node.modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        this.advance();
        node.type = this.parseType();
        if (this.curtok.id != 5) {
            this.ReportError("Expected event member name.");
        }
        while (this.curtok.id == 5) {
            node.names.add(this.parseQualifiedIdentifier());
        }
        if (this.curtok.id == 123) {
            this.advance();
            if (this.curtok.id != 5) {
                this.ReportError("Event accessor requires add or remove clause.");
            }
            String curAccessor = this.strings.get(this.curtok.data);
            this.advance();
            if (curAccessor.equals("add")) {
                this.parseBlock(node.addBlock);
                if (this.curtok.id == 5 && this.strings.get(this.curtok.data).equals("remove")) {
                    this.advance();
                    this.parseBlock(node.removeBlock);
                } else {
                    this.ReportError("Event accessor expected remove clause.");
                }
            } else if (curAccessor.equals("remove")) {
                this.parseBlock(node.removeBlock);
                if (this.curtok.id == 5 && this.strings.get(this.curtok.data).equals("add")) {
                    this.advance();
                    this.parseBlock(node.addBlock);
                } else {
                    this.ReportError("Event accessor expected add clause.");
                }
            } else {
                this.ReportError("Event accessor requires add or remove clause.");
            }
        } else {
            this.AssertAndAdvance(59);
        }
    }

    private void parseConst() throws FeatureNotSupportedException {
        long mask = Modifier.ConstantMods ^ 0xFFFFFFFFFFFFFFFFL;
        if ((this.curmods & mask) != Modifier.Empty) {
            this.ReportError("const declaration contains illegal modifiers");
        }
        ConstantNode node = new ConstantNode();
        this.typeStack.peek().Constants.add(node);
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        node.modifiers = this.curmods;
        this.curmods = Modifier.Empty;
        this.advance();
        node.type = this.parseType();
        boolean hasEqual = false;
        node.names.add(this.parseQualifiedIdentifier());
        if (this.curtok.id == 61) {
            this.advance();
            hasEqual = true;
        }
        while (this.curtok.id == 44) {
            this.advance();
            node.names.add(this.parseQualifiedIdentifier());
            if (this.curtok.id == 61) {
                this.advance();
                hasEqual = true;
                continue;
            }
            hasEqual = false;
        }
        if (hasEqual) {
            node.Value = this.parseConstExpr();
        }
        this.AssertAndAdvance(59);
    }

    private EnumNode parseEnumMember() throws FeatureNotSupportedException {
        EnumNode result = new EnumNode();
        this.parsePossibleAttributes(false);
        if (this.curAttributes.size() > 0) {
            result.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        if (this.curtok.id != 5) {
            this.ReportError("Enum members must be legal identifiers.");
        }
        String name = this.strings.get(this.curtok.data);
        result.Name = new IdentifierExpression(new String[]{name});
        this.advance();
        if (this.curtok.id == 61) {
            this.advance();
            result.Value = this.ParseExpression();
        }
        if (this.curtok.id == 44) {
            this.advance();
        }
        return result;
    }

    private NodeCollection<ParamDeclNode> parseParamList() throws FeatureNotSupportedException {
        return this.parseParamList(40, 41);
    }

    private NodeCollection<ParamDeclNode> parseParamList(int openToken, int closeToken) throws FeatureNotSupportedException {
        this.AssertAndAdvance(openToken);
        if (this.curtok.id == closeToken) {
            this.advance();
            return null;
        }
        NodeCollection<ParamDeclNode> result = new NodeCollection<ParamDeclNode>();
        boolean isParams = false;
        boolean hasComma = false;
        do {
            ParamDeclNode node = new ParamDeclNode();
            result.add(node);
            isParams = false;
            this.parsePossibleAttributes(false);
            if (this.curtok.id == 109) {
                node.modifiers |= Modifier.Ref;
                this.advance();
            } else if (this.curtok.id == 104) {
                node.modifiers |= Modifier.Out;
                this.advance();
            } else if (this.curtok.id == 156) {
                isParams = true;
                node.modifiers |= Modifier.Params;
                this.advance();
            }
            node.type = this.parseType();
            if (isParams) {
                // empty if block
            }
            if (this.curtok.id == 5) {
                node.name = this.strings.get(this.curtok.data);
                this.advance();
            }
            hasComma = false;
            if (this.curtok.id != 44) continue;
            this.advance();
            hasComma = true;
        } while (!isParams && hasComma);
        this.AssertAndAdvance(closeToken);
        return result;
    }

    private ParamDeclNode parseParamDecl() throws FeatureNotSupportedException {
        ParamDeclNode node = new ParamDeclNode();
        this.parsePossibleAttributes(false);
        if (this.curAttributes.size() > 0) {
            node.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        node.type = this.parseType();
        if (this.curtok.id == 5) {
            node.name = this.strings.get(this.curtok.data);
            this.advance();
        } else {
            this.RecoverFromError("Expected arg name.", 5);
        }
        return node;
    }

    private NodeCollection<ArgumentNode> parseArgs() throws FeatureNotSupportedException {
        this.AssertAndAdvance(40);
        if (this.curtok.id == 41) {
            this.advance();
            return null;
        }
        boolean hasComma = false;
        NodeCollection<ArgumentNode> result = new NodeCollection<ArgumentNode>();
        do {
            ArgumentNode node = new ArgumentNode();
            result.add(node);
            if (this.curtok.id == 109) {
                node.isRef = true;
                this.advance();
            } else if (this.curtok.id == 104) {
                node.isOut = true;
                this.advance();
            }
            node.expression = this.ParseExpression();
            hasComma = false;
            if (this.curtok.id != 44) continue;
            this.advance();
            hasComma = true;
        } while (hasComma);
        this.AssertAndAdvance(41);
        return result;
    }

    private AccessorNode parseAccessor() throws FeatureNotSupportedException {
        AccessorNode result = new AccessorNode();
        this.parsePossibleAttributes(false);
        if (this.curAttributes.size() > 0) {
            result.attributes = this.curAttributes;
            this.curAttributes = new NodeCollection();
        }
        String kind = "";
        if (this.curtok.id == 5) {
            kind = this.strings.get(this.curtok.data);
        } else {
            this.RecoverFromError("Must specify accessor kind in accessor.", this.curtok.id);
        }
        result.kind = kind;
        this.advance();
        if (this.curtok.id == 59) {
            result.isAbstractOrInterface = true;
            this.advance();
        } else {
            this.parseBlock(result.statementBlock);
        }
        return result;
    }

    private ConstantExpression parseConstExpr() throws FeatureNotSupportedException {
        ConstantExpression node = new ConstantExpression();
        node.Value = this.ParseExpression();
        return node;
    }

    private void parseModifiers() throws FeatureNotSupportedException {
        block3: while (!this.curtok.equals(EOF)) {
            switch (this.curtok.id) {
                case 9: 
                case 97: 
                case 99: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: {
                    long mod = modMap.get(this.curtok.id);
                    if ((this.curmods & mod) > 0L) {
                        this.ReportError("Duplicate modifier.");
                    }
                    this.curmods |= mod;
                    this.advance();
                    continue block3;
                }
            }
            return;
        }
    }

    private long parseAttributeModifiers() throws FeatureNotSupportedException {
        long result = Modifier.Empty;
        String curIdent = "";
        boolean isMod = true;
        block5: while (isMod) {
            switch (this.curtok.id) {
                case 5: {
                    curIdent = this.strings.get(this.curtok.data);
                    if (curIdent.equals("field")) {
                        result |= Modifier.Field;
                    } else if (curIdent.equals("method")) {
                        result |= Modifier.Method;
                    } else if (curIdent.equals("param")) {
                        result |= Modifier.Param;
                    } else if (curIdent.equals("property")) {
                        result |= Modifier.Property;
                    } else if (curIdent.equals("type")) {
                        result |= Modifier.Type;
                    } else if (curIdent.equals("module")) {
                        result |= Modifier.Module;
                    } else if (curIdent.equals("assembly")) {
                        result |= Modifier.Assembly;
                    } else {
                        isMod = false;
                    }
                    this.advance();
                    continue block5;
                }
                case 142: {
                    result |= Modifier.Return;
                    this.advance();
                    continue block5;
                }
                case 153: {
                    result |= Modifier.Event;
                    this.advance();
                    continue block5;
                }
            }
            isMod = false;
        }
        return result;
    }

    private TypeNode parseType() throws FeatureNotSupportedException {
        IdentifierExpression idPart = this.parseQualifiedIdentifier();
        TypeNode result = new TypeNode(idPart);
        while (this.curtok.id == 91 && (this.index >= this.tokens.size() || ((Token)this.tokens.get((int)this.index)).id == 93 || ((Token)this.tokens.get((int)this.index)).id == 44)) {
            this.advance();
            int commaCount = 0;
            while (this.curtok.id == 44) {
                ++commaCount;
                this.advance();
            }
            result.RankSpecifiers.add(commaCount);
            this.AssertAndAdvance(93);
        }
        return result;
    }

    private IdentifierExpression parseQualifiedIdentifier() throws FeatureNotSupportedException {
        IdentifierExpression result = new IdentifierExpression();
        ArrayList<String> qualName = new ArrayList<String>();
        switch (this.curtok.id) {
            case 5: {
                qualName.add(this.strings.get(this.curtok.data));
                this.advance();
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 121: 
            case 149: 
            case 150: {
                qualName.add(TokenID.getFieldName(this.curtok.id));
                result.StartingPredefinedType = this.curtok.id;
                this.advance();
                break;
            }
            default: {
                this.RecoverFromError(5);
            }
        }
        while (this.curtok.id == 46) {
            this.advance();
            if (this.curtok.id == 5) {
                qualName.add(this.strings.get(this.curtok.data));
                this.advance();
                continue;
            }
            if (this.curtok.id == 149) continue;
            this.RecoverFromError(5);
        }
        result.Identifier = new String[qualName.toArray().length];
        qualName.toArray(result.Identifier);
        return result;
    }

    private IdentifierExpression parseIdentifierOrKeyword() throws FeatureNotSupportedException {
        IdentifierExpression result = new IdentifierExpression();
        switch (this.curtok.id) {
            case 5: {
                result.Identifier = new String[]{this.strings.get(this.curtok.data)};
                this.advance();
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 121: 
            case 132: 
            case 138: 
            case 149: 
            case 150: {
                String predef = TokenID.getFieldName(this.curtok.id);
                result.Identifier = new String[]{predef};
                result.StartingPredefinedType = this.curtok.id;
                this.advance();
                break;
            }
            default: {
                this.RecoverFromError(5);
            }
        }
        return result;
    }

    private void parseInterfaceAccessors(Boolean[] bx) throws FeatureNotSupportedException {
        this.AssertAndAdvance(123);
        this.parsePossibleAttributes(false);
        if (this.curtok.id == 5 && this.strings.get(this.curtok.data).equals("get")) {
            if (this.curAttributes.size() > 0) {
                this.curAttributes = new NodeCollection();
            }
            bx[0] = true;
            this.advance();
            this.AssertAndAdvance(59);
            if (this.curtok.id == 5) {
                if (this.strings.get(this.curtok.data).equals("set")) {
                    bx[1] = true;
                    this.advance();
                    this.AssertAndAdvance(59);
                } else {
                    this.RecoverFromError("Expected set in interface property def.", this.curtok.id);
                }
            }
        } else if (this.curtok.id == 5 && this.strings.get(this.curtok.data).equals("set")) {
            if (this.curAttributes.size() > 0) {
                this.curAttributes = new NodeCollection();
            }
            bx[1] = true;
            this.advance();
            this.AssertAndAdvance(59);
            if (this.curtok.id == 5) {
                if (this.strings.get(this.curtok.data).equals("get")) {
                    bx[0] = true;
                    this.advance();
                    this.AssertAndAdvance(59);
                } else {
                    this.RecoverFromError("Expected get in interface property def.", this.curtok.id);
                }
            }
        } else {
            this.RecoverFromError("Expected get or set in interface property def.", this.curtok.id);
        }
        this.AssertAndAdvance(125);
    }

    private void parseStatement(NodeCollection<StatementNode> node) throws FeatureNotSupportedException {
        switch (this.curtok.id) {
            case 123: {
                BlockStatement newBlock = new BlockStatement();
                node.add(newBlock);
                this.parseBlock(newBlock);
                break;
            }
            case 59: {
                this.advance();
                node.add(new StatementNode());
                break;
            }
            case 138: {
                node.add(this.parseIf());
                break;
            }
            case 144: {
                node.add(this.parseSwitch());
                break;
            }
            case 151: {
                node.add(this.parseWhile());
                break;
            }
            case 130: {
                node.add(this.parseDo());
                break;
            }
            case 133: {
                node.add(this.parseFor());
                break;
            }
            case 134: {
                node.add(this.parseForEach());
                break;
            }
            case 122: {
                node.add(this.parseBreak());
                break;
            }
            case 128: {
                node.add(this.parseContinue());
                break;
            }
            case 137: {
                node.add(this.parseGoto());
                break;
            }
            case 142: {
                node.add(this.parseReturn());
                break;
            }
            case 146: {
                node.add(this.parseThrow());
                break;
            }
            case 147: {
                node.add(this.parseTry());
                break;
            }
            case 152: {
                node.add(this.parseChecked());
                break;
            }
            case 158: {
                node.add(this.parseUnchecked());
                break;
            }
            case 141: {
                node.add(this.parseLock());
                break;
            }
            case 159: {
                node.add(this.ParseUsing());
                break;
            }
            case 98: {
                this.isLocalConst = true;
                this.advance();
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 40: 
            case 48: 
            case 49: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 103: 
            case 121: 
            case 149: {
                ExpressionStatement enode = new ExpressionStatement(this.ParseExpression());
                node.add(enode);
                if (this.curtok.id != 59) break;
                this.advance();
                break;
            }
            case 5: {
                if (this.tokens.size() > this.index + 1 && ((Token)this.tokens.get((int)this.index)).id == 58) {
                    LabeledStatement lsnode = new LabeledStatement();
                    lsnode.Name = this.parseQualifiedIdentifier();
                    this.AssertAndAdvance(58);
                    this.parseStatement(lsnode.Statements);
                    node.add(lsnode);
                } else {
                    ExpressionStatement inode = new ExpressionStatement(this.ParseExpression());
                    node.add(inode);
                }
                if (this.curtok.id != 59) break;
                this.advance();
                break;
            }
            case 157: {
                this.ParseUnsafeCode();
                break;
            }
            default: {
                System.out.println("Unhandled case in statement parsing: \"" + this.curtok.id + "\" in line: " + this.lineCount);
                ExpressionStatement dnode = new ExpressionStatement(this.ParseExpression());
                node.add(dnode);
                if (this.curtok.id != 59) break;
                this.advance();
            }
        }
    }

    private void parseBlock(BlockStatement node) throws FeatureNotSupportedException {
        this.parseBlock(node, false);
    }

    private void parseBlock(BlockStatement node, boolean isCase) throws FeatureNotSupportedException {
        if (this.curtok.id == 123) {
            this.advance();
            while (this.curtok.id != 254 && this.curtok.id != 125) {
                this.parseStatement(node.Statements);
            }
            this.AssertAndAdvance(125);
        } else if (isCase) {
            while (this.curtok.id != 254 && this.curtok.id != 129 && this.curtok.id != 131 && this.curtok.id != 125) {
                this.parseStatement(node.Statements);
            }
        } else {
            this.parseStatement(node.Statements);
        }
    }

    private IfStatement parseIf() throws FeatureNotSupportedException {
        IfStatement node = new IfStatement();
        this.advance();
        this.AssertAndAdvance(40);
        node.Test = this.ParseExpression();
        this.AssertAndAdvance(41);
        this.parseBlock(node.Statements);
        if (this.curtok.id == 132) {
            this.advance();
            this.parseBlock(node.ElseStatements);
        }
        if (this.curtok.id == 59) {
            this.advance();
        }
        return node;
    }

    private SwitchStatement parseSwitch() throws FeatureNotSupportedException {
        SwitchStatement node = new SwitchStatement();
        this.advance();
        this.AssertAndAdvance(40);
        node.Test = this.ParseExpression();
        this.AssertAndAdvance(41);
        this.AssertAndAdvance(123);
        while (this.curtok.id == 129 || this.curtok.id == 131) {
            node.Cases.add(this.parseCase());
        }
        this.AssertAndAdvance(125);
        if (this.curtok.id == 59) {
            this.advance();
        }
        return node;
    }

    private CaseNode parseCase() throws FeatureNotSupportedException {
        CaseNode node = new CaseNode();
        boolean isDefault = this.curtok.id == 131;
        this.advance();
        if (!isDefault) {
            node.Ranges.add(this.ParseExpression());
        } else {
            node.IsDefaultCase = true;
        }
        this.AssertAndAdvance(58);
        while (this.curtok.id == 129 || this.curtok.id == 131) {
            isDefault = this.curtok.id == 131;
            this.advance();
            if (!isDefault) {
                node.Ranges.add(this.ParseExpression());
            } else {
                node.IsDefaultCase = true;
            }
            this.AssertAndAdvance(58);
        }
        if (this.curtok.id != 123) {
            node.StatementBlock.setHasBraces(false);
        }
        this.parseBlock(node.StatementBlock, true);
        return node;
    }

    private WhileStatement parseWhile() throws FeatureNotSupportedException {
        WhileStatement node = new WhileStatement();
        this.advance();
        this.AssertAndAdvance(40);
        node.Test = this.ParseExpression();
        this.AssertAndAdvance(41);
        this.parseBlock(node.Statements);
        if (this.curtok.id == 59) {
            this.advance();
        }
        return node;
    }

    private DoStatement parseDo() throws FeatureNotSupportedException {
        DoStatement node = new DoStatement();
        this.advance();
        this.parseBlock(node.Statements);
        this.AssertAndAdvance(151);
        this.AssertAndAdvance(40);
        node.Test = this.ParseExpression();
        this.AssertAndAdvance(41);
        this.AssertAndAdvance(59);
        return node;
    }

    private ForStatement parseFor() throws FeatureNotSupportedException {
        ForStatement node = new ForStatement();
        this.advance();
        this.AssertAndAdvance(40);
        if (this.curtok.id != 59) {
            node.Init.add(this.ParseExpression());
            while (this.curtok.id == 44) {
                this.AssertAndAdvance(44);
                node.Init.add(this.ParseExpression());
            }
        }
        this.AssertAndAdvance(59);
        if (this.curtok.id != 59) {
            node.Test.add(this.ParseExpression());
            while (this.curtok.id == 44) {
                this.AssertAndAdvance(44);
                node.Test.add(this.ParseExpression());
            }
        }
        this.AssertAndAdvance(59);
        if (this.curtok.id != 41) {
            node.Inc.add(this.ParseExpression());
            while (this.curtok.id == 44) {
                this.AssertAndAdvance(44);
                node.Inc.add(this.ParseExpression());
            }
        }
        this.AssertAndAdvance(41);
        this.parseBlock(node.Statements);
        if (this.curtok.id == 59) {
            this.advance();
        }
        return node;
    }

    private ForEachStatement parseForEach() throws FeatureNotSupportedException {
        ForEachStatement node = new ForEachStatement();
        this.advance();
        this.AssertAndAdvance(40);
        node.Iterator = this.parseParamDecl();
        this.AssertAndAdvance(139);
        node.Collection = this.ParseExpression();
        this.AssertAndAdvance(41);
        if (this.curtok.id == 59) {
            this.advance();
        }
        return node;
    }

    private BreakStatement parseBreak() throws FeatureNotSupportedException {
        BreakStatement node = new BreakStatement();
        this.advance();
        if (this.curtok.id == 59) {
            this.advance();
        }
        return node;
    }

    private ContinueStatement parseContinue() throws FeatureNotSupportedException {
        ContinueStatement node = new ContinueStatement();
        this.advance();
        if (this.curtok.id == 59) {
            this.advance();
        }
        return node;
    }

    private GotoStatement parseGoto() throws FeatureNotSupportedException {
        this.advance();
        GotoStatement gn = new GotoStatement();
        if (this.curtok.id == 129) {
            this.advance();
            gn.IsCase = true;
        } else if (this.curtok.id == 131) {
            this.advance();
            gn.IsDefaultCase = true;
        }
        if (!gn.IsDefaultCase) {
            gn.Target = this.ParseExpression();
        }
        this.AssertAndAdvance(59);
        return gn;
    }

    private ReturnStatement parseReturn() throws FeatureNotSupportedException {
        ReturnStatement node = new ReturnStatement();
        this.advance();
        if (this.curtok.id == 59) {
            this.advance();
        } else {
            node.ReturnValue = this.ParseExpression();
            this.AssertAndAdvance(59);
        }
        return node;
    }

    private ThrowNode parseThrow() throws FeatureNotSupportedException {
        ThrowNode node = new ThrowNode();
        this.advance();
        if (this.curtok.id != 59) {
            node.ThrowExpression = this.ParseExpression();
        }
        if (this.curtok.id == 59) {
            this.advance();
        }
        return node;
    }

    private TryStatement parseTry() throws FeatureNotSupportedException {
        TryStatement node = new TryStatement();
        this.advance();
        this.parseBlock(node.TryBlock);
        while (this.curtok.id == 127) {
            CatchNode cn = new CatchNode();
            node.CatchBlocks.add(cn);
            this.advance();
            if (this.curtok.id == 40) {
                this.advance();
                cn.ClassType = this.parseType();
                if (this.curtok.id == 5) {
                    cn.Identifier = new IdentifierExpression(new String[]{this.strings.get(this.curtok.data)});
                    this.advance();
                }
                this.AssertAndAdvance(41);
                this.parseBlock(cn.CatchBlock);
                continue;
            }
            this.parseBlock(cn.CatchBlock);
            break;
        }
        if (this.curtok.id == 135) {
            FinallyNode fn;
            this.advance();
            node.FinallyBlock = fn = new FinallyNode();
            this.parseBlock(fn.FinallyBlock);
        }
        if (this.curtok.id == 59) {
            this.advance();
        }
        return node;
    }

    private CheckedStatement parseChecked() throws FeatureNotSupportedException {
        CheckedStatement node = new CheckedStatement();
        this.advance();
        if (this.curtok.id == 59) {
            this.advance();
        }
        return node;
    }

    private UncheckedStatement parseUnchecked() throws FeatureNotSupportedException {
        UncheckedStatement node = new UncheckedStatement();
        this.advance();
        if (this.curtok.id == 59) {
            this.advance();
        }
        return node;
    }

    private LockStatement parseLock() throws FeatureNotSupportedException {
        LockStatement node = new LockStatement();
        this.advance();
        this.AssertAndAdvance(40);
        node.Target = this.ParseExpression();
        this.AssertAndAdvance(41);
        this.parseBlock(node.Statements);
        if (this.curtok.id == 59) {
            this.advance();
        }
        return node;
    }

    private UsingStatement ParseUsing() throws FeatureNotSupportedException {
        UsingStatement node = new UsingStatement();
        this.advance();
        this.AssertAndAdvance(40);
        node.Resource = this.ParseExpression();
        this.AssertAndAdvance(41);
        this.parseBlock(node.Statements);
        if (this.curtok.id == 59) {
            this.advance();
        }
        return node;
    }

    private void ParseUnsafeCode() throws FeatureNotSupportedException {
        this.advance();
        this.AssertAndAdvance(123);
        int lcount = 1;
        while (this.curtok.id != 254 && lcount != 0) {
            this.advance();
            if (this.curtok.id == 125) {
                --lcount;
                continue;
            }
            if (this.curtok.id != 123) continue;
            ++lcount;
        }
        if (this.curtok.id != 254) {
            this.advance();
        }
    }

    private ExpressionNode ParseExpression(int endToken) throws FeatureNotSupportedException {
        int id = this.curtok.id;
        while (id != endToken && id != 254 && id != 59 && id != 41 && id != 44 && id != 58) {
            this.ParseExpressionSegment();
            id = this.curtok.id;
        }
        return this.exprStack.pop();
    }

    private ExpressionNode ParseExpression() throws FeatureNotSupportedException {
        int id = this.curtok.id;
        while (id != 254 && id != 125 && id != 59 && id != 41 && id != 44 && id != 58) {
            this.ParseExpressionSegment();
            id = this.curtok.id;
        }
        return this.exprStack.pop();
    }

    private void ParseExpressionSegment() throws FeatureNotSupportedException {
        ExpressionNode tempNode = null;
        int startToken = this.curtok.id;
        switch (this.curtok.id) {
            case 8: {
                this.exprStack.push(new NullPrimitive());
                this.advance();
                break;
            }
            case 6: {
                this.exprStack.push(new BooleanPrimitive(true));
                this.advance();
                this.ParseContinuingPrimary();
                break;
            }
            case 7: {
                this.exprStack.push(new BooleanPrimitive(false));
                this.advance();
                this.ParseContinuingPrimary();
                break;
            }
            case 13: {
                this.exprStack.push(new IntegralPrimitive(this.strings.get(this.curtok.data), IntegralType.Int));
                this.advance();
                this.ParseContinuingPrimary();
                break;
            }
            case 15: {
                this.exprStack.push(new IntegralPrimitive(this.strings.get(this.curtok.data), IntegralType.UInt));
                this.advance();
                this.ParseContinuingPrimary();
                break;
            }
            case 16: {
                this.exprStack.push(new IntegralPrimitive(this.strings.get(this.curtok.data), IntegralType.Long));
                this.advance();
                this.ParseContinuingPrimary();
                break;
            }
            case 17: {
                this.exprStack.push(new IntegralPrimitive(this.strings.get(this.curtok.data), IntegralType.ULong));
                this.advance();
                this.ParseContinuingPrimary();
                break;
            }
            case 19: {
                this.exprStack.push(new RealPrimitive(this.strings.get(this.curtok.data)));
                this.advance();
                this.ParseContinuingPrimary();
                break;
            }
            case 20: {
                this.exprStack.push(new CharPrimitive(this.strings.get(this.curtok.data)));
                this.advance();
                this.ParseContinuingPrimary();
                break;
            }
            case 21: {
                String sval = this.strings.get(this.curtok.data);
                this.exprStack.push(new StringPrimitive(sval));
                this.advance();
                this.ParseContinuingPrimary();
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                IdentifierExpression qe = this.parseQualifiedIdentifier();
                this.exprStack.push(qe);
                this.ParseContinuingPrimary();
                break;
            }
            case 43: {
                tempNode = this.ConsumeBinary(startToken);
                if (tempNode == null) break;
                this.exprStack.push(new UnaryExpression(startToken, tempNode));
                break;
            }
            case 45: {
                tempNode = this.ConsumeBinary(startToken);
                if (tempNode == null) break;
                this.exprStack.push(new UnaryExpression(startToken, tempNode));
                break;
            }
            case 37: 
            case 38: 
            case 42: 
            case 47: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 62: 
            case 72: 
            case 74: 
            case 94: 
            case 120: 
            case 124: 
            case 140: {
                this.ConsumeBinary(startToken);
                break;
            }
            case 33: 
            case 48: 
            case 49: 
            case 126: {
                this.ConsumeUnary(startToken);
                break;
            }
            case 63: {
                ExpressionNode condTest = this.exprStack.pop();
                this.advance();
                ExpressionNode cond1 = this.ParseExpression(58);
                this.AssertAndAdvance(58);
                ExpressionNode cond2 = this.ParseExpression();
                this.exprStack.push(new ConditionalExpression(condTest, cond1, cond2));
                break;
            }
            case 109: {
                this.advance();
                this.ParseExpressionSegment();
                this.exprStack.push(new RefNode(this.exprStack.pop()));
                break;
            }
            case 104: {
                this.advance();
                this.ParseExpressionSegment();
                this.exprStack.push(new OutNode(this.exprStack.pop()));
                break;
            }
            case 149: {
                this.exprStack.push(this.parseQualifiedIdentifier());
                this.ParseContinuingPrimary();
                break;
            }
            case 150: {
                this.advance();
                this.exprStack.push(new VoidPrimitive());
                break;
            }
            case 121: {
                this.advance();
                int newToken = this.curtok.id;
                if (newToken == 46) {
                    this.advance();
                    String baseIdent = this.strings.get(this.curtok.data);
                    IdentifierExpression ide = new IdentifierExpression(new String[]{baseIdent});
                    this.advance();
                    this.exprStack.push(new BaseAccessExpression(ide));
                } else if (newToken == 91) {
                    this.advance();
                    ExpressionList el = this.ParseExpressionList(93);
                    this.exprStack.push(new BaseAccessExpression(el));
                }
                this.ParseContinuingPrimary();
                break;
            }
            case 148: {
                this.advance();
                this.AssertAndAdvance(40);
                this.exprStack.push(new TypeOfExpression(this.ParseExpression(41)));
                this.AssertAndAdvance(41);
                this.ParseContinuingPrimary();
                break;
            }
            case 152: {
                this.advance();
                this.AssertAndAdvance(40);
                this.ParseExpressionSegment();
                this.exprStack.push(new CheckedExpression(this.exprStack.pop()));
                this.AssertAndAdvance(41);
                this.ParseContinuingPrimary();
                break;
            }
            case 158: {
                this.advance();
                this.AssertAndAdvance(40);
                this.ParseExpressionSegment();
                this.exprStack.push(new UncheckedExpression(this.exprStack.pop()));
                this.AssertAndAdvance(41);
                this.ParseContinuingPrimary();
                break;
            }
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: {
                int op = this.curtok.id;
                this.advance();
                if (this.exprStack.size() > 0 && !(this.exprStack.peek() instanceof PrimaryExpression) && !(this.exprStack.peek() instanceof UnaryCastExpression)) {
                    this.ReportError("Left hand side of assignment must be a variable.");
                }
                ExpressionNode assignVar = this.exprStack.pop();
                ExpressionNode rightSide = this.ParseExpression();
                this.exprStack.push(new AssignmentExpression(op, assignVar, rightSide));
                break;
            }
            case 123: {
                this.advance();
                ArrayInitializerExpression aie = new ArrayInitializerExpression();
                this.exprStack.push(aie);
                aie.Expressions = this.ParseExpressionList(125);
                break;
            }
            case 103: {
                this.advance();
                TypeNode newType = this.parseType();
                if (this.curtok.id == 40) {
                    this.advance();
                    ExpressionList newList = this.ParseExpressionList(41);
                    this.exprStack.push(new ObjectCreationExpression(newType, newList));
                } else if (this.curtok.id == 91) {
                    this.ParseArrayCreation(newType);
                }
                this.ParseContinuingPrimary();
                break;
            }
            case 5: {
                boolean isDecl = this.isAfterType();
                if (isDecl) {
                    this.ParseLocalDeclaration();
                    break;
                }
                this.exprStack.push(this.parseQualifiedIdentifier());
                this.ParseContinuingPrimary();
                break;
            }
            case 40: {
                this.advance();
                this.ParseCastOrGroup();
                break;
            }
            default: {
                this.AssertAndAdvance(20);
            }
        }
    }

    private void ConsumeUnary(int startOp) throws FeatureNotSupportedException {
        this.advance();
        this.ParseExpressionSegment();
        while (precedence[this.curtok.id] > precedence[startOp]) {
            this.ParseExpressionSegment();
        }
        UnaryExpression uNode = new UnaryExpression(startOp);
        uNode.Child = this.exprStack.pop();
        this.exprStack.push(uNode);
    }

    private ExpressionNode ConsumeBinary(int startOp) throws FeatureNotSupportedException {
        ExpressionNode result = null;
        if (this.exprStack.size() == 0 || precedence[((Token)this.tokens.get((int)(this.index - 2))).id] > 0) {
            this.advance();
            this.ParseExpressionSegment();
            while (precedence[this.curtok.id] > precedence[startOp]) {
                this.ParseExpressionSegment();
            }
            result = this.exprStack.pop();
        } else {
            this.advance();
            BinaryExpression bNode = new BinaryExpression(startOp);
            bNode.Left = this.exprStack.pop();
            this.exprStack.push(bNode);
            this.ParseExpressionSegment();
            while (precedence[this.curtok.id] > precedence[startOp]) {
                this.ParseExpressionSegment();
            }
            bNode.Right = this.exprStack.pop();
        }
        return result;
    }

    private boolean isAfterType() {
        boolean result = false;
        if (this.exprStack.size() > 0) {
            if (this.exprStack.peek() instanceof IdentifierExpression) {
                IdentifierExpression ie = (IdentifierExpression)this.exprStack.pop();
                this.exprStack.push(new TypeNode(ie));
                result = true;
            } else if (this.exprStack.peek() instanceof TypeNode || this.exprStack.peek() instanceof MemberAccessExpression) {
                result = true;
            }
        }
        return result;
    }

    private ExpressionList ParseExpressionList(int termChar) throws FeatureNotSupportedException {
        ExpressionList list = new ExpressionList();
        int id = this.curtok.id;
        while (id != 254 && id != termChar) {
            while (id != 254 && id != termChar && id != 44) {
                this.ParseExpressionSegment();
                id = this.curtok.id;
            }
            if (this.curtok.id == 44) {
                this.advance();
            }
            list.getExpressions().add(this.exprStack.pop());
            id = this.curtok.id;
        }
        if (this.curtok.id == termChar) {
            this.advance();
        }
        return list;
    }

    private void ParseLocalDeclaration() throws FeatureNotSupportedException {
        IdentifierExpression declIdentifier = this.parseQualifiedIdentifier();
        IType type = (IType)((Object)this.exprStack.pop());
        LocalDeclarationStatement lnode = new LocalDeclarationStatement();
        lnode.Identifiers.add(declIdentifier);
        if (this.isLocalConst) {
            lnode.IsConstant = true;
        }
        this.isLocalConst = false;
        lnode.Type = type;
        while (this.curtok.id != 254 && this.curtok.id != 59 && this.curtok.id != 41) {
            while (this.curtok.id == 44) {
                this.advance();
                declIdentifier = this.parseQualifiedIdentifier();
                lnode.Identifiers.add(declIdentifier);
            }
            if (this.curtok.id != 61) continue;
            this.advance();
            lnode.RightSide = this.ParseExpression(44);
            if (this.curtok.id != 44) continue;
            this.exprStack.push(lnode);
            lnode = new LocalDeclarationStatement();
            lnode.Type = type;
        }
        this.exprStack.push(lnode);
    }

    private void ParseCastOrGroup() throws FeatureNotSupportedException {
        ExpressionNode interior = this.ParseExpression();
        this.AssertAndAdvance(41);
        int rightTok = this.curtok.id;
        if (!(interior instanceof IType) || rightTok == 59 || rightTok == 41 || rightTok == 125 || rightTok == 93 || rightTok == 44) {
            this.exprStack.push(new ParenthesizedExpression(interior));
            this.ParseContinuingPrimary();
        } else {
            ParenthesizedExpression pe = new ParenthesizedExpression();
            this.exprStack.push(pe);
            this.ParseExpressionSegment();
            ExpressionNode peek = this.exprStack.peek();
            if (peek instanceof PrimaryExpression || peek instanceof UnaryExpression) {
                UnaryCastExpression castNode = new UnaryCastExpression();
                castNode.Type = (IType)((Object)interior);
                castNode.Child = this.exprStack.pop();
                this.exprStack.pop();
                this.exprStack.push(castNode);
            } else {
                pe.Expression = interior;
                this.ParseContinuingPrimary();
            }
        }
    }

    private void ParseArrayCreation(TypeNode type) throws FeatureNotSupportedException {
        ArrayCreationExpression arNode = new ArrayCreationExpression();
        this.exprStack.push(arNode);
        arNode.Type = type;
        int nextToken = 255;
        if (this.tokens.size() > this.index) {
            nextToken = ((Token)this.tokens.get((int)this.index)).id;
        }
        if (nextToken != 255 && nextToken != 44 && nextToken != 93) {
            this.advance();
            arNode.RankSpecifier = this.ParseExpressionList(93);
        }
        while (this.curtok.id == 91) {
            this.advance();
            int commaCount = 0;
            while (this.curtok.id == 44) {
                ++commaCount;
                this.advance();
            }
            arNode.AdditionalRankSpecifiers.add(commaCount);
            this.AssertAndAdvance(93);
        }
        if (this.curtok.id == 123) {
            this.advance();
            arNode.Initializer = new ArrayInitializerExpression();
            arNode.Initializer.Expressions = this.ParseExpressionList(125);
        }
    }

    private void ParseContinuingPrimary() throws FeatureNotSupportedException {
        boolean isContinuing;
        boolean bl = isContinuing = this.curtok.id == 91 || this.curtok.id == 46 || this.curtok.id == 40;
        while (isContinuing) {
            switch (this.curtok.id) {
                case 46: {
                    this.ParseMemberAccess();
                    break;
                }
                case 40: {
                    this.ParseInvocation();
                    break;
                }
                case 91: {
                    isContinuing = this.ParseElementAccess();
                    break;
                }
                default: {
                    isContinuing = false;
                }
            }
            if (!isContinuing) continue;
            isContinuing = this.curtok.id == 91 || this.curtok.id == 46 || this.curtok.id == 40;
        }
        if (this.curtok.id == 48) {
            this.advance();
            this.exprStack.push(new PostIncrementExpression(this.exprStack.pop()));
        } else if (this.curtok.id == 49) {
            this.advance();
            this.exprStack.push(new PostDecrementExpression(this.exprStack.pop()));
        }
    }

    private void ParseMemberAccess() throws FeatureNotSupportedException {
        this.advance();
        if (this.curtok.id != 5) {
            this.ReportError("Right side of member access must be identifier");
        }
        IdentifierExpression identifier = this.parseQualifiedIdentifier();
        if (this.exprStack.size() > 0 && this.exprStack.peek() instanceof IMemberAccessible) {
            IMemberAccessible ima = (IMemberAccessible)((Object)this.exprStack.pop());
            this.exprStack.push(new MemberAccessExpression(ima, identifier));
        } else {
            this.ReportError("Left side of member access must be PrimaryExpression or PredefinedType.");
        }
    }

    private void ParseInvocation() throws FeatureNotSupportedException {
        this.advance();
        PrimaryExpression leftSide = (PrimaryExpression)this.exprStack.pop();
        ExpressionList list = this.ParseExpressionList(41);
        this.exprStack.push(new InvocationExpression(leftSide, list));
    }

    private boolean ParseElementAccess() throws FeatureNotSupportedException {
        boolean isElementAccess = true;
        this.advance();
        ExpressionNode type = this.exprStack.pop();
        if (this.curtok.id == 44 || this.curtok.id == 93) {
            isElementAccess = false;
            if (type instanceof IdentifierExpression) {
                IdentifierExpression ie = (IdentifierExpression)type;
                TypeNode tp = new TypeNode(ie);
                this.exprStack.push(tp);
                this.ParseArrayRank(tp);
            }
        } else if (type instanceof PrimaryExpression) {
            PrimaryExpression tp = (PrimaryExpression)type;
            ExpressionList el = this.ParseExpressionList(93);
            this.exprStack.push(new ElementAccessExpression(tp, el));
        } else {
            this.ReportError("Left side of Element Access must be primary expression.");
        }
        return isElementAccess;
    }

    private void ParseArrayRank(TypeNode type) throws FeatureNotSupportedException {
        boolean firstTime = true;
        while (this.curtok.id == 91 || firstTime) {
            if (!firstTime) {
                this.advance();
            }
            firstTime = false;
            int commaCount = 0;
            while (this.curtok.id == 44) {
                ++commaCount;
                this.advance();
            }
            type.RankSpecifiers.add(commaCount);
            this.AssertAndAdvance(93);
        }
    }

    private void RecoverFromError(int id) throws FeatureNotSupportedException {
        this.RecoverFromError("", id);
    }

    private void RecoverFromError(String message, int id) throws FeatureNotSupportedException {
        String msg = "Error: Expected " + id + " found: " + this.curtok.id;
        if (message != null) {
            msg = message + msg;
        }
        this.ReportError(msg);
        if (id == 20) {
            this.success = false;
            throw new FeatureNotSupportedException("Delegates not supported");
        }
        this.advance();
    }

    private void ReportError(String message) {
        System.out.println(message + " in token " + this.index + " [" + this.curtok.id + "]");
    }

    private void AssertAndAdvance(int id) throws FeatureNotSupportedException {
        if (this.curtok.id != id) {
            this.RecoverFromError(id);
        }
        this.advance();
    }

    private void advance() throws FeatureNotSupportedException {
        boolean skipping = true;
        block6: do {
            this.curtok = this.index < this.tokens.size() ? (Token)this.tokens.get(this.index) : EOF;
            ++this.index;
            switch (this.curtok.id) {
                case 2: {
                    break;
                }
                case 3: {
                    String[] s = this.strings.get(this.curtok.data).split("\n");
                    this.lineCount += s.length - 1;
                    break;
                }
                case 1: {
                    ++this.lineCount;
                    break;
                }
                case 35: {
                    if (!this.inPPDirective) {
                        this.parsePreprocessorDirective();
                        if (this.curtok.id != 1 && this.curtok.id != 2 && this.curtok.id != 3 && this.curtok.id != 35) {
                            skipping = false;
                            break;
                        }
                        if (this.curtok.id != 35) continue block6;
                        --this.index;
                        break;
                    }
                    skipping = false;
                    break;
                }
                default: {
                    skipping = false;
                }
            }
        } while (skipping);
    }

    private void SkipToEOL(int startLine) {
        if (this.lineCount > startLine) {
            return;
        }
        boolean skipping = true;
        do {
            if (this.index < this.tokens.size()) {
                this.curtok = (Token)this.tokens.get(this.index);
            } else {
                this.curtok = EOF;
                skipping = false;
            }
            ++this.index;
            if (this.curtok.id != 1) continue;
            ++this.lineCount;
            skipping = false;
        } while (skipping);
    }

    private void SkipToNextHash() {
        boolean skipping = true;
        do {
            if (this.index < this.tokens.size()) {
                this.curtok = (Token)this.tokens.get(this.index);
            } else {
                this.curtok = EOF;
                skipping = false;
            }
            ++this.index;
            if (this.curtok.id == 35) {
                skipping = false;
                continue;
            }
            if (this.curtok.id != 1) continue;
            ++this.lineCount;
        } while (skipping);
    }

    private void SkipToElseOrEndIf() {
        boolean firstPassHash;
        int endCount = 1;
        boolean bl = firstPassHash = this.curtok.id == 35;
        while (endCount > 0) {
            if (!firstPassHash) {
                this.SkipToNextHash();
            }
            firstPassHash = false;
            if (this.index >= this.tokens.size()) break;
            if (((Token)this.tokens.get((int)this.index)).id == 5) {
                String sKind = this.strings.get(((Token)this.tokens.get((int)this.index)).data);
                if (sKind.equals("endif")) {
                    --endCount;
                    continue;
                }
                if (!sKind.equals("elif") || endCount != 1) continue;
                break;
            }
            if (((Token)this.tokens.get((int)this.index)).id == 138) {
                ++endCount;
                continue;
            }
            if (((Token)this.tokens.get((int)this.index)).id == 132 && endCount != 1) continue;
            break;
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    static {
        ppDefs = new Hashtable();
    }
}

