/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PairTest
extends AbstractLangTest {
    @Test
    public void testAccept() {
        Pair pair1 = Pair.of((Object)"A", (Object)"D");
        Pair pair2 = Pair.of((Object)"B", (Object)"C");
        HashMap map = new HashMap();
        pair1.accept(map::put);
        pair2.accept(map::put);
        Assertions.assertEquals((Object)"D", map.get("A"));
        Assertions.assertEquals((Object)"C", map.get("B"));
        pair1.accept(map::put);
        pair2.accept(map::put);
        Assertions.assertEquals((Object)"D", map.get("A"));
        Assertions.assertEquals((Object)"C", map.get("B"));
    }

    @Test
    public void testApply() {
        Pair pair1 = Pair.of((Object)"A", (Object)"D");
        Pair pair2 = Pair.of((Object)"B", (Object)"C");
        HashMap map = new HashMap();
        Assertions.assertEquals(null, (Object)pair1.apply(map::put));
        Assertions.assertEquals(null, (Object)pair2.apply(map::put));
        Assertions.assertEquals((Object)"D", map.get("A"));
        Assertions.assertEquals((Object)"C", map.get("B"));
        Assertions.assertEquals((Object)"D", (Object)pair1.apply(map::put));
        Assertions.assertEquals((Object)"C", (Object)pair2.apply(map::put));
        Assertions.assertEquals((Object)"D", map.get("A"));
        Assertions.assertEquals((Object)"C", map.get("B"));
    }

    @Test
    public void testComparable1() {
        Pair pair1 = Pair.of((Object)"A", (Object)"D");
        Pair pair2 = Pair.of((Object)"B", (Object)"C");
        Assertions.assertEquals((int)0, (int)pair1.compareTo(pair1));
        Assertions.assertTrue((pair1.compareTo(pair2) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)pair2.compareTo(pair2));
        Assertions.assertTrue((pair2.compareTo(pair1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testComparable2() {
        Pair pair1 = Pair.of((Object)"A", (Object)"C");
        Pair pair2 = Pair.of((Object)"A", (Object)"D");
        Assertions.assertEquals((int)0, (int)pair1.compareTo(pair1));
        Assertions.assertTrue((pair1.compareTo(pair2) < 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)pair2.compareTo(pair2));
        Assertions.assertTrue((pair2.compareTo(pair1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompatibilityBetweenPairs() {
        ImmutablePair pair = ImmutablePair.of((Object)0, (Object)"foo");
        MutablePair pair2 = MutablePair.of((Object)0, (Object)"foo");
        Assertions.assertEquals((Object)pair, (Object)pair2);
        Assertions.assertEquals((int)pair.hashCode(), (int)pair2.hashCode());
        HashSet<ImmutablePair> set = new HashSet<ImmutablePair>();
        set.add(pair);
        Assertions.assertTrue((boolean)set.contains(pair2));
        pair2.setValue((Object)"bar");
        Assertions.assertNotEquals((Object)pair, (Object)pair2);
        Assertions.assertNotEquals((int)pair.hashCode(), (int)pair2.hashCode());
    }

    @Test
    public void testEmptyArrayGenerics() {
        Pair[] empty = Pair.emptyArray();
        Assertions.assertEquals((int)0, (int)empty.length);
    }

    @Test
    public void testEmptyArrayLength() {
        Pair[] empty = Pair.EMPTY_ARRAY;
        Assertions.assertEquals((int)0, (int)empty.length);
    }

    @Test
    public void testFormattable_padded() {
        Pair pair = Pair.of((Object)"Key", (Object)"Value");
        Assertions.assertEquals((Object)"         (Key,Value)", (Object)String.format("%1$20s", pair));
    }

    @Test
    public void testFormattable_simple() {
        Pair pair = Pair.of((Object)"Key", (Object)"Value");
        Assertions.assertEquals((Object)"(Key,Value)", (Object)String.format("%1$s", pair));
    }

    @Test
    public void testMapEntry() {
        ImmutablePair pair = ImmutablePair.of((Object)0, (Object)"foo");
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "foo");
        Map.Entry entry = map.entrySet().iterator().next();
        Assertions.assertEquals((Object)pair, entry);
        Assertions.assertEquals((int)pair.hashCode(), (int)entry.hashCode());
    }

    @Test
    public void testOfNonNull() {
        Assertions.assertThrows(NullPointerException.class, () -> Pair.ofNonNull(null, null));
        Assertions.assertThrows(NullPointerException.class, () -> Pair.ofNonNull(null, (Object)"x"));
        Assertions.assertThrows(NullPointerException.class, () -> Pair.ofNonNull((Object)"x", null));
        Pair pair = Pair.ofNonNull((Object)"x", (Object)"y");
        Assertions.assertEquals((Object)"x", (Object)pair.getLeft());
        Assertions.assertEquals((Object)"y", (Object)pair.getRight());
    }

    @Test
    public void testPairOfMapEntry() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, "foo");
        Map.Entry entry = map.entrySet().iterator().next();
        Pair pair = Pair.of(entry);
        Assertions.assertEquals((Integer)((Integer)entry.getKey()), (Integer)((Integer)pair.getLeft()));
        Assertions.assertEquals(entry.getValue(), (Object)pair.getRight());
    }

    @Test
    public void testPairOfObjects() {
        Pair pair = Pair.of((Object)0, (Object)"foo");
        Assertions.assertTrue((boolean)(pair instanceof ImmutablePair));
        Assertions.assertEquals((int)0, (int)((Integer)((ImmutablePair)pair).left));
        Assertions.assertEquals((Object)"foo", (Object)((ImmutablePair)pair).right);
        Pair pair2 = Pair.of(null, (Object)"bar");
        Assertions.assertTrue((boolean)(pair2 instanceof ImmutablePair));
        Assertions.assertNull((Object)((ImmutablePair)pair2).left);
        Assertions.assertEquals((Object)"bar", (Object)((ImmutablePair)pair2).right);
        Pair pair3 = Pair.of(null, null);
        Assertions.assertNull((Object)pair3.getLeft());
        Assertions.assertNull((Object)pair3.getRight());
    }

    @Test
    public void testToString() {
        Pair pair = Pair.of((Object)"Key", (Object)"Value");
        Assertions.assertEquals((Object)"(Key,Value)", (Object)pair.toString());
    }

    @Test
    public void testToStringCustom() {
        Calendar date = Calendar.getInstance();
        date.set(2011, 3, 25);
        Pair pair = Pair.of((Object)"DOB", (Object)date);
        Assertions.assertEquals((Object)"Test created on 04-25-2011", (Object)pair.toString("Test created on %2$tm-%2$td-%2$tY"));
    }
}

