// Source: https://github.com/atlassian/react-beautiful-dnd

import getDistanceThresholds from './get-distance-thresholds';
import getValue from './get-value';
export default (({
  container,
  distanceToEdges,
  dragStartTime,
  axis,
  shouldUseTimeDampening
}) => {
  const thresholds = getDistanceThresholds(container, axis);
  const isCloserToEnd = distanceToEdges[axis.end] < distanceToEdges[axis.start];
  if (isCloserToEnd) {
    return getValue({
      distanceToEdge: distanceToEdges[axis.end],
      thresholds,
      dragStartTime,
      shouldUseTimeDampening
    });
  }
  return -1 * getValue({
    distanceToEdge: distanceToEdges[axis.start],
    thresholds,
    dragStartTime,
    shouldUseTimeDampening
  });
});