/********************************************************************************************************
 * QRNA - Comparative analysis of biological sequences 
 *         with pair hidden Markov models, pair stochastic context-free
 *        grammars, and probabilistic evolutionary  models.
 *       
 * Version 2.0.3 (MAY 2004)
 *
 * Copyright (C) 2000-2004 Howard Hughes Medical Institute/Washington University School of Medicine
 * All Rights Reserved
 * 
 *     This source code is distributed under the terms of the
 *     GNU General Public License. See the files COPYING and LICENSE
 *     for details.
 ***********************************************************************************************************/

/* evolfuncs.h
 * ANSI prototypes for "evol" external functions.
 * 
 */
#ifndef EVOLFUNCSH_INCLUDED
#define EVOLFUNCSH_INCLUDED

#include <stdio.h>
#include "globals.h"
#include "squid.h"
#include "structs.h"


/* from evolcodmodel.c:
 */
extern void EvolChangeCODProbsNaive(FILE *ofp, double *targetfreq, double **ret_pnewcod, struct psubs_s *codprob, int isindep, int verbose);
extern void EvolChangeCODProbsYuAltchul(FILE *ofp, double *targetfreq, double **ret_pnewcod, struct psubs_s *codprob, int verbose);
extern void EvolConstructCODEmitProbs(double **pammodel, double *pmut, double **pcodon, int verbose);
extern void EvolConstructCODModel(struct psubs_s *pam_star, struct psubs_s *codprob_star, struct psubs_s *mutpxy_star,
				  double *codon_joint, int add_codon, double **hexa, int win, double tfactor, 
				  double *targetfreq, int changefreq, struct codmodel_s *cod, int add_hexamer, int pedantic, int verbose);
extern void MarginalizeCODProbs(double *pcod, double *pmar, int verbose);

/* from evolemissions.c:
 */
extern void   AllocSubsProbs(int L, struct psubs_s **ret_psubs);
extern void   AllocNonSubsProbs(int L, struct pnonsubs_s **ret_pnonsubs);
extern double DeltaPrimeFromDelta (double indel);
extern void   EvolCalCODRate(struct psubs_s *cod, int verbose);
extern void   EvolCalMutRateFromCOD(struct psubs_s *codprob_star, int L, struct psubs_s **ret_mutpxy_star, 
				    double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolCalMutRateFromRIBOUnparied(fullmat_t *ribomat, int L, struct psubs_s *mutpxy_star, 
					     struct psubs_s **ret_mutpxy_rna_unparied_star, 
					     double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolCalMutRateFromRIBOPaired(struct psubs_s *riboprob_star, int L, struct psubs_s *mutpxy_star, 
					   struct psubs_s **ret_mutpxy_rna_paired_star, 
					   double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolCalMut5RateFromCOD(struct psubs_s *codprob_star, int L5, struct psubs_s **ret_mut5pxy_star, 
				     double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolCalMut5RateFromRIBOUnparied(fullmat_t *ribomat, int L5, struct psubs_s *mutpxy_star, struct psubs_s *mut5pxy_star, 
					      struct psubs_s *mutpxy_rna_unpaired_star, struct psubs_s **ret_mut5pxy_rna_unparied_star, 
					      double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolCalMut5RateLoopFromRIBOUnparied(fullmat_t *ribomat, int L5, struct psubs_s *mutpxy_star, struct psubs_s *mut5pxy_star, 
						  struct psubs_s *mutpxy_rna_loop_star, struct psubs_s **ret_mut5pxy_rna_loop_star, 
						  double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolCalMut5RateFromRIBOPaired(struct psubs_s *riboprob_star, int L5, struct psubs_s *mut5pxy_star, 
					    struct psubs_s *mutpxy_rna_paired_star, struct psubs_s **ret_mut5pxy_rna_paired_star, 
					    double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolCalPAMRate(int **pam, double scale, int L, struct psubs_s **ret_pam_star, double *codon_joint, int add_codon, 
			     int pedantic, int verbose);
extern void   EvolCalPair5Rate(double *cfg5prob, struct psubs_s *mutpxy_star, int L5, 
			       struct pnonsubs_s **ret_pairprob_star, struct pnonsubs_s **ret_pair5prob_star, 
			       double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolCalRIBORate(fullmat_t *ribomat, struct psubs_s *mutpxy_star, struct pnonsubs_s *pairprob_star, struct psubs_s **ret_riboprob_star, 
			      int changefreq, int pedantic, int verbose);
extern void   EvolCalRIBOApproxRate(struct psubs_s *mutpxy_star, struct pnonsubs_s *pairprob_star, struct psubs_s **ret_riboprobapprox_star, 
				    int changefreq, int pedantic, int verbose);
extern void   EvolChangeFreqCODProbsGW(struct psubs_s *codprob, double *targetfreq, int pedantic, int verbose);
extern void   EvolChangeFreqCODProbsIterate(struct psubs_s *codprob, double *targetfreq, int pedantic, int verbose);
extern void   EvolChangeFreqCODProbsNaive(struct psubs_s *codprob, double *targetfreq, int pedantic, int verbose);
extern void   EvolChangeFreqCODProbsYuAltchul(struct psubs_s *codprob, double *targetfreq, int pedantic, int verbose);
extern void   EvolChangeFreqMutProbsModifRate(struct psubs_s *mutpxy, double *targetfreq, int pedantic, int verbose);
extern void   EvolChangeFreqMutProbsRecalRate(struct psubs_s *mutpxy, double *targetfreq, int pedantic, int verbose);
extern void   EvolChangeFreqMut5ProbsModifRate(struct psubs_s *mut5pxy, double *targetfreq, int pedantic, int verbose);
extern void   EvolChangeFreqMut5ProbsRecalRate(struct psubs_s *mut5pxy, double *targetfreq, int pedantic, int verbose);
extern void   EvolChangeFreqPair5Probs(struct pnonsubs_s *pair5prob, double *targetfreq, int pedantic, int verbose);
extern void   EvolChangeRIBORate(FILE *ofp, struct psubs_s *riboprob, struct pnonsubs_s *pair5prob, int verbose);
extern void   EvolCODProbsStar(struct psubs_s *pam_star, struct psubs_s **ret_codprob, double *codon_joint, int add_codon, 
			       double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolCODProbs(struct psubs_s *pam_star, struct psubs_s *codprob_star, double tfactor, 
			   struct psubs_s **ret_codprob, double *codon_joint, int add_codon, 
			   double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolveIndelMarginalsByReversability(FILE *ofp, double *Q, double *pm, int L, int pedantic, int verbose);
extern void   EvolMutProbs(struct psubs_s *mutpxy_star, double time, struct psubs_s **ret_mutpxy, 
			   double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolMut5Probs(struct psubs_s *mut5pxy_star, double time, struct psubs_s **ret_mut5pxy, 
			    double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolPair5Probs(struct pnonsubs_s *pair5prob_star, double time, struct pnonsubs_s **ret_pair5prob, 
			     double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolRIBOProbs(struct psubs_s *riboprob_star, double time, struct psubs_s **ret_riboprob, 
			    double *targetfreq, int changefreq, int pedantic, int verbose);
extern void   EvolRIBO5Probs_OldMethod(struct psubs_s *riboprob_star, struct psubs_s *mut5pxy, struct pnonsubs_s *pair5prob, 
				       struct psubs_s **ret_ribo5prob, int verbose);
extern void   FreeSubsProbs(struct psubs_s *psubs);
extern void   FreeNonSubsProbs(struct pnonsubs_s *pnonsubs);
extern double RescaleMutRate(FILE *ofp, int L, double *scaleRate, double *Rate, int hasindel, int verbose);
extern double RescaleCalculateRIBOScale(FILE *ofp, double target_subs, struct psubs_s *riboprob, int verbose);
extern double RescaleRIBORate(FILE *ofp, struct psubs_s *riboprob, struct psubs_s *mutpxy, int verbose);
extern double RIBOAverageSubsperSite (FILE *ofp, struct psubs_s *riboprob, int verbose);
extern double RIBOMutSubsperSite (FILE *ofp, struct psubs_s *riboprob, int verbose);
extern double SubsPerSite(FILE *ofp, int L, double *Rate, double *pm, int verbose);

/* from evolmisc.c:
 */
extern void EvolAllocModels(struct emodel_s **ret_emodel);
extern void EvolCalculateNaiveTargetError(double tfactor, int L, double *targerfreq, double *pmar_old, double *pmar_new, int verbose);
extern void EvolCalculateMutProbsTargetError(FILE *ofp, double *targetfreq, struct psubs_s *pmutxy, int verbose);
extern void EvolCalculateMut5ProbsTargetError(FILE *ofp, double *targetfreq, struct psubs_s *pmut5xy, int verbose);
extern void EvolConstructModels_phase1(FILE *ofp, char *codonfile, char *hexapfile, char *pamfile, char *cfgfile, char *ribofile,
				       double *targetfreq, struct emodel_s **ret_emodel, 
				       double ****ret_cfg_node, double ***ret_hexa, double **ret_codon_joint,
				       struct psubs_s **ret_pam_star,  struct psubs_s **ret_codprob_star, 
				       struct psubs_s **ret_mutpxy_star, struct psubs_s **ret_mut5pxy_star,
				       struct psubs_s **ret_riboprob_star, struct psubs_s **ret_riboprobapprox_star, struct pnonsubs_s **ret_pair5prob_star, 
				       struct psubs_s **ret_mutpxy_rna_unpaired_star, struct psubs_s **ret_mut5pxy_rna_unpaired_star,
				       struct psubs_s **ret_mut5pxy_rna_loop_star,
				       struct psubs_s **ret_mutpxy_rna_paired_star, struct psubs_s **ret_mut5pxy_rna_paired_star,
				       int add_codon, int add_hexamer, int approx, int areon, int changefreq, int changefreqoverall, 
				       int logodds, int pedantic, int verbose);
extern void EvolConstructModels_phase2(FILE *ofp, int win, double ***cfg_node, double **hexa, double *codon_joint, 
				       double *freqX, double *freqY, struct emodel_s *emodel, struct three_times_s time, 
				       struct psubs_s *pam_star, struct psubs_s *codprob_star, 
				       struct psubs_s *mutpxy_star, struct psubs_s *mut5pxy_star,
				       struct psubs_s *riboprob_star, struct pnonsubs_s *pair5prob_star, 
				       struct psubs_s *mutpxy_rna_unpaired_star, struct psubs_s *mut5pxy_rna_unpaired_star,
				       struct psubs_s *mut5pxy_rna_loop_star,
				       struct psubs_s *mutpxy_rna_paired_star, struct psubs_s *mut5pxy_rna_paired_star,
				       int add_codon, int add_hexamer, int changefreq, int changfreqoverall, 
				       int logodds, int use_ribo_oldrna, int pedantic, int verbose);
extern void EvolFreeModels(struct emodel_s *emodel);
extern void EvolModelLog2ToOdds(struct emodel_s *emodel);
extern void EvolPatternModels(struct emodel_s *emodel, int areon);
extern void EvolPrintTrProbs(struct emodel_s *emodel);
extern int  NullProbs (double *p, int L);

/* from evolnullmodel.c:
 */
extern void EvolConstructNullModel(struct psubs_s *mytpxy_star, struct nullmodel_s *null, 
				   struct nullparam_s param, struct nullparam_s param_zero, struct nullparam_s param_infty, 
				   double tfactor, double *targetfreq, int changefreq, int verbose);

/* from evolothmodel.c:
 */
extern void EvolConstructOTHModel(struct psubs_s *mutpxy_star,  
				  struct othparam_s othparam, struct othparam_s othparam_zero, struct othparam_s othparam_infty, 
				  double win, double win_zero, double win_infty, double tfactor, double *targetfreq, int changefreq, 
				  struct othmodel_s *oth, int pedantic, int verbose);

/* from evolqrnaversions.c:
 */
extern void EvolScoreScanFast(FILE *ofp, 
			      FILE *printqfp,  char *printqfile, 
			      FILE *regressfp, char *regressionfile, 
			      int format, 
			      SQINFO sqinfoX, int *isegX, int *iseqX, double *freqX,
			      SQINFO sqinfoY, int *isegY, int *iseqY, double *freqY,
			      char *aliss,
			      int Lw, int leg, int win, int slide,
			      double id_ali, double id_win_mean, double id_win_sd,
			      double            ***cfg_node,
			      double             **hexa,
			      double              *codon_joint,
			      struct psubs_s      *pammodel_star,
			      struct psubs_s      *codprob_star,
			      struct psubs_s      *mutpxy_star,
			      struct psubs_s      *mut5pxy_star,
			      struct psubs_s      *riboprob_star,
			      struct pnonsubs_s   *pair5prob_star,
			      struct psubs_s      *mutpxy_rna_unpaired_star,
			      struct psubs_s      *mut5pxy_rna_unpaired_star,
			      struct psubs_s      *mut5pxy_rna_loop_star,
			      struct psubs_s      *mutpxy_rna_paired_star,
			      struct psubs_s      *mut5pxy_rna_paired_star,
			      struct dos_s              dos, 
			      struct emodel_s          *emodel, 
			      struct dpdscanfast_s     *dpdscan, 
			      struct dpd_s             *dpd, 
			      struct dpf_s             *dpf, 
			      struct rnascfgscanfast_s *mxscan, 
			      struct rnascfg_s         *mx, 
			      struct scores_s          *sc, 
			      struct ali_s             *ali,
			      struct scanfast_s        *scanfast,
			      int add_codon, int add_hexamer, 
			      int alignment, int use_ribo_approx, int cyk, int changefreq, int changefreqoverall, int evd,
			      int fastintloop, int is_fix_time, int logodds, int use_ribo_oldrna, int pedantic,
			      int shuffle, int sre_shuffle, int con_shuffle, 
			      struct three_times_s tfactor, 
			      int traceback, int verbose, int ones, int parse, int rnass, int doends, 
			      int N, double k, int shift, int *histo_sc);
extern void EvolScoreWindow(FILE *ofp, 
			    FILE *printqfp,  char *printqfile, 
			    FILE *regressfp, char *regressionfile, 
			    int format, 
			    SQINFO sqinfoX, int *isegX, int *iseqX, double *freqX,
			    SQINFO sqinfoY, int *isegY, int *iseqY, double *freqY,
			    char *aliss,
			    int Lw, int leg, int win, int slide,
			    double id_ali, double id_win_mean, double id_win_sd,
			    double            ***cfg_node,
			    double             **hexa,
			    double              *codon_joint,
			    struct psubs_s      *pammodel_star,
			    struct psubs_s      *codprob_star,
			    struct psubs_s      *mutpxy_star,
			    struct psubs_s      *mut5pxy_star,
			    struct psubs_s      *riboprob_star,
			    struct pnonsubs_s   *pair5prob_star,
			    struct psubs_s      *mutpxy_rna_unpaired_star,
			    struct psubs_s      *mut5pxy_rna_unpaired_star,
			    struct psubs_s      *mut5pxy_rna_loop_star,
			    struct psubs_s      *mutpxy_rna_paired_star,
			    struct psubs_s      *mut5pxy_rna_paired_star,
			    struct dos_s         d, 
			    struct emodel_s     *emodel, 
			    struct dpd_s        *dpd, 
			    struct dpf_s        *dpf, 
			    struct rnascfg_s    *mx, 
			    struct scores_s     *sc, 
			    struct ali_s        *ali,
			    int add_codon, int add_hexamer, int alignment, int use_ribo_approx, 
			    int cyk, int changefreq, int changefreqoverall, int changefreqwin, int evd, 
			    int fastintloop, int is_fix_time, int logodds, int use_ribo_oldrna, int pedantic,
			    int shuffle, int sre_shuffle, int con_shuffle, int sweep, 
			    struct three_times_s  tfactor, 
			    int traceback, int verbose, int ones, int parse, int rnass, int doends, int shtoo, int twindow,
			    int N, double k, int shift, int *histo_sc);


/* from evolriboprob.c:
 */
extern void               EvolAddGapsRIBO5Probs(struct psubs_s *riboprob, struct psubs_s *mut5pxy, struct pnonsubs_s *pair5prob, 
						struct psubs_s **ret_ribo5prob, double *targetfreq, int verbose);
extern struct pnonsubs_s *EvolComputeRIBOMutConditionalsAndMarginals(FILE *ofp, struct psubs_s *riboprob, int islog, int verbose);
extern void               EvolCalRIBOMutRate (double *R, int L);
extern void               EvolCalculateRIBOMutConditionalsAndMarginals(FILE *ofp, struct pnonsubs_s *riboprob, int islog, int verbose);
extern void               EvolCalculateRIBOPairConditionalsAndMarginals(FILE *ofp, struct psubs_s *riboprob, int verbose);
extern void               EvolCalculateRIBOProbs(FILE *ofp, fullmat_t *ribomat, struct psubs_s **ret_riboprob_star, int verbose);
extern void               EvolCalculateRIBOProbsApprox(FILE *ofp, struct psubs_s *mutpxy_star, struct pnonsubs_s *pairprob_star, 
						       struct psubs_s **ret_riboprobapprox_star, int verbose);
extern void               EvolCalculateRIBO5MutUncorrelated(FILE *ofp, struct psubs_s *riboprob_star, 
							    struct psubs_s *mut5pxy, struct pnonsubs_s *pair5prob, 
							    struct psubs_s **ret_ribo5prob_MU, int verbose);
extern void               EvolCalculateRIBO5PairUncorrelated(FILE *ofp, struct psubs_s *riboprob_star, 
							     struct psubs_s *mut5pxy, struct pnonsubs_s *pair5prob, 
							     struct pnonsubs_s **ret_ribo5prob_PU, int verbose);
extern void               EvolCalculateRIBOProbsCummulative(FILE *ofp, int LSQ, double *riboprob, int islog);
extern void               EvolCalculateRIBOProbsSaturation(FILE *ofp, int LSQ, double *pairprob, int islog);
extern void               EvolCalculateRIBOTargetError (double *targerfreq, struct psubs_s *riboprob, int verbose);
extern void               EvolCalculateRIBO5TargetError (double *targerfreq, struct psubs_s *ribo5prob, int verbose);
extern void               EvolCalculateNaivePairTargetError(double *targetfreq, struct pnonsubs_s *pairprob_old, 
							    struct pnonsubs_s *pairprob, int verbose);
extern void               EvolChangePairProbsIterate(FILE *ofp, struct pnonsubs_s *pairprob, double *targetfreq, int hasindel, int verbose);
extern void               EvolChangePairProbsLambda(FILE *ofp, struct pnonsubs_s *pairprob, double *targetfreq, int hasindel, int verbose);
extern void               EvolChangePairProbsNaive(FILE *ofp, struct pnonsubs_s *pairprob, double *targetfreq, int hasindel, int verbose);
extern void               EvolChangePairProbsYuAltschul(FILE *ofp, struct pnonsubs_s *pairprob, double *targetfreq, int hasindel, int verbose);
extern void               EvolCombineRIBO5Probs_OldMethod(struct psubs_s *ribo5prob_MU, struct pnonsubs_s *ribo5prob_PU, 
							  struct psubs_s *mut5pxy, struct pnonsubs_s *pair5prob, 
							  struct psubs_s **ret_ribo5prob, int verbose);
extern void               EvolRateFromRIBOPairConditionals(FILE *ofp, struct psubs_s *riboprob, struct pnonsubs_s *pairprob, 
							   int changepair, int pedantic, int verbose);


/* from rnadp.c:
 */
extern void   EvolForwardRNADiag(FILE *ofp, SQINFO sqinfoX, int *seqX, SQINFO sqinfoY, int *seqY, char *gss, int start, int L, 
				 struct emodel_s *emodel, struct dpd_s *dp, struct rnascfg_s *mx, struct sc2_s *rnasc,
				 struct dpsc3_s *sc, int *ret_scfg_status, int *ret_scfgrv_status, 
				 int cyk, int fastintloop, int logodds, int do_nus, int ones, int parse);
extern void   EvolViterbiRNADiag(FILE *ofp, SQINFO sqinfoX, int *seqX, SQINFO sqinfoY, int *seqY, char *gss, 
				 int start, int L, struct emodel_s *emodel, struct dpd_s *dp, 
				 struct rnascfg_s *mx, struct sc2_s *rnasc, struct ali_s *ali, int *ret_scfg_status, int *ret_scfgrv_status, 
				 int alignment, int cyk, int fastintloop, int logoods, int do_nus, int ones, int parse, int traceback, 
				 int doends, struct windowends_s *windowends);

/* from evolrnadpscanfast.c:
 */
extern double EvolViterbiRNADiagScanFast(FILE *ofp, SQINFO sqinfoX, int *seqX, SQINFO sqinfoY, int *seqY, char *gss, 
					 int leg, int win, int st, int stmod, int l, int lmax, 
					 struct emodel_s *emodel, struct rnadpscanfast_s *dp, struct rnamtxscanfast_s *mtx,
					 struct ali_s *ali, int alignment, 
					 int cyk, int logodds, int revstrand, int parse, int traceback, 
					 int doends, struct end3scan_s *ends);

/* from evolrnamodel.c:
 */
extern void EvolConstructRNAModel(struct psubs_s *mutpxy_star, struct psubs_s *mut5pxy_star, 
				  struct psubs_s *mutpxy_rna_unpaired_star, struct psubs_s *mut5pxy_rna_unpaired_star,
				  struct psubs_s *mut5pxy_rna_loop_star, 
				  struct psubs_s *mutpxy_rna_paired_star, struct psubs_s *mut5pxy_rna_paired_star, 
				  struct pnonsubs_s *pair5prob_star, 
				  struct psubs_s *riboprob_star, double ***cfg_node, 
				  int win, double tfactor, struct rnamodel_s *rna, struct nullmodel_s *null, 
				  double *targetfreq, int changefreq, int use_ribo_oldrna, int pedantic, int verbose);

/* from evolrnascorealing.c:
 */
extern void EvolScoreWithRNA(FILE *ofp, SQINFO sqinfoX, int *sX, SQINFO sqinfoY, int *sY, char *gss, int start, int L, 
			     struct emodel_s *emodel, struct othdpd_s *othdp, struct rnascfg_s *mx, struct sc2_s *rnasc,
			     int *ret_scfg_status, int *ret_scfgrv_status, int cyk, int fastintloop, int logodds, 
			     int do_nus, int ones, int parse, int traceback);

/* from evolscorewitmmodels.c:
 */
extern void EvolScoreWithModels(FILE *ofp, 
				FILE *printqfp,  char *printqfile, 
				FILE *regressfp, char *regressionfile, 
				SQINFO sqinfoX, int *isegX, int *iseqX, 
				SQINFO sqinfoY, int *isegY, int *iseqY, 
				char *gss, int start, int leg, int Lmax, 
				struct dos_s dos, 
				struct emodel_s *emodel, 
				struct dpd_s *dpd, struct dpf_s *dpf, 
				struct rnascfg_s *mx, 
				struct scores_s *sc, 
				struct ali_s *ali,  
				int alignment, int cyk, int doends, int fastintloop, int logodds, int ones, int parse, int rnass, 
				int shuffle, int sre_shuffle, int con_shuffle,
				int sweep, int traceback, int verbose, int use_win_id, struct three_times_s time);

/* from evolscorewithmodelscanfast.c:
 */
extern int EvolScoreWithModelsScanFast(FILE *ofp, 
				       SQINFO sqinfoX, int *isegX,
				       SQINFO sqinfoY, int *isegY,
				       char *gss,
				       int L, int win, int slide, int j, int jmod, int l, int lmax, 
				       struct emodel_s          *emodel, 
				       struct dpdscanfast_s     *dpdscan, 		   
				       struct rnascfgscanfast_s *mx, 
				       struct scores_s          *sc, 
				       struct ali_s             *ali, 
				       struct scanfast_s        *scanfast,
				       int alignment, int cyk,  int doends, int fastintloop, int logodds, int ones, int parse, int rnass, 
				       int revstrand, int traceback, int verbose);


#endif /*FUNCSH_INCLUDED*/
