/*
 * Copyright 2019 TNG Technology Consulting GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tngtech.junit.dataprovider.format;

import java.lang.reflect.Method;
import java.util.List;

/** Provides the format for a dataprovider test using test method, invocation index and arguments list. */
public interface DataProviderTestNameFormatter {

    /**
     * Method formatting the given arguments to provide a test method name.
     *
     * @param testMethod the test method to be executed
     * @param invocationIndex the index within one dataprovider
     * @param arguments the arguments used to executed the test method
     * @return a formatted test method name
     */
    String format(Method testMethod, int invocationIndex, List<Object> arguments);
}
