/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.interval.ia_math;

public class RMath {
    static double Zero = 0.0;
    static double NegZero = -0.0;

    public static double nextfp(double d) {
        if (d == 0.0) {
            return Double.longBitsToDouble(1L);
        }
        if (d < Double.POSITIVE_INFINITY) {
            long l = Double.doubleToLongBits(d);
            double d2 = d > 0.0 ? Double.longBitsToDouble(l + 1L) : (d == 0.0 ? Double.longBitsToDouble(1L) : Double.longBitsToDouble(l - 1L));
            return d2;
        }
        return d;
    }

    public static double prevfp(double d) {
        if (d == 0.0) {
            return -RMath.nextfp(0.0);
        }
        return -RMath.nextfp(-d);
    }

    public static double add_lo(double d, double d2) {
        return RMath.prevfp(d + d2);
    }

    public static double add_hi(double d, double d2) {
        return RMath.nextfp(d + d2);
    }

    public static double sub_lo(double d, double d2) {
        return RMath.prevfp(d - d2);
    }

    public static double sub_hi(double d, double d2) {
        return RMath.nextfp(d - d2);
    }

    public static double mul_lo(double d, double d2) {
        if (d == 0.0 || d2 == 0.0) {
            return 0.0;
        }
        return RMath.prevfp(d * d2);
    }

    public static double mul_hi(double d, double d2) {
        if (d == 0.0 || d2 == 0.0) {
            return 0.0;
        }
        return RMath.nextfp(d * d2);
    }

    public static double div_lo(double d, double d2) {
        if (d == 0.0) {
            return 0.0;
        }
        return RMath.prevfp(d / d2);
    }

    public static double div_hi(double d, double d2) {
        if (d == 0.0) {
            return 0.0;
        }
        return RMath.nextfp(d / d2);
    }

    public static double exp_lo(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (d < Double.POSITIVE_INFINITY) {
            return Math.max(0.0, RMath.prevfp(Math.exp(d)));
        }
        return d;
    }

    public static double exp_hi(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (d < Double.POSITIVE_INFINITY) {
            return RMath.nextfp(Math.exp(d));
        }
        return d;
    }

    public static double log_lo(double d) {
        if (d < 0.0) {
            return Double.NaN;
        }
        if (d < Double.POSITIVE_INFINITY) {
            return RMath.prevfp(Math.log(d));
        }
        return d;
    }

    public static double log_hi(double d) {
        if (d < 0.0) {
            return Double.NaN;
        }
        if (d < Double.POSITIVE_INFINITY) {
            return RMath.nextfp(Math.log(d));
        }
        return d;
    }

    public static double sin_lo(double d) {
        return RMath.prevfp(Math.sin(d));
    }

    public static double sin_hi(double d) {
        return RMath.nextfp(Math.sin(d));
    }

    public static double cos_lo(double d) {
        return RMath.prevfp(Math.cos(d));
    }

    public static double cos_hi(double d) {
        return RMath.nextfp(Math.cos(d));
    }

    public static double tan_lo(double d) {
        return RMath.prevfp(Math.tan(d));
    }

    public static double tan_hi(double d) {
        return RMath.nextfp(Math.tan(d));
    }

    public static double asin_lo(double d) {
        return RMath.prevfp(Math.asin(d));
    }

    public static double asin_hi(double d) {
        return RMath.nextfp(Math.asin(d));
    }

    public static double acos_lo(double d) {
        return RMath.prevfp(Math.acos(d));
    }

    public static double acos_hi(double d) {
        return RMath.nextfp(Math.acos(d));
    }

    public static double atan_lo(double d) {
        return RMath.prevfp(Math.atan(d));
    }

    public static double atan_hi(double d) {
        return RMath.nextfp(Math.atan(d));
    }

    static double sin2pi_lo(double d) {
        return RMath.prevfp(Math.sin(RMath.prevfp(Math.PI * 2 * d)));
    }

    static double sin2pi_hi(double d) {
        return RMath.nextfp(Math.sin(RMath.nextfp(Math.PI * 2 * d)));
    }

    static double cos2pi_lo(double d) {
        if (d > 0.0) {
            return RMath.prevfp(Math.cos(RMath.nextfp(Math.PI * 2 * d)));
        }
        return RMath.prevfp(Math.cos(RMath.prevfp(Math.PI * 2 * d)));
    }

    static double cos2pi_hi(double d) {
        if (d > 0.0) {
            return RMath.nextfp(Math.cos(RMath.prevfp(Math.PI * 2 * d)));
        }
        return RMath.nextfp(Math.cos(RMath.nextfp(Math.PI * 2 * d)));
    }

    static double tan2pi_lo(double d) {
        return RMath.prevfp(Math.tan(RMath.prevfp(Math.PI * 2 * d)));
    }

    static double tan2pi_hi(double d) {
        return RMath.nextfp(Math.tan(RMath.nextfp(Math.PI * 2 * d)));
    }

    static double asin2pi_lo(double d) {
        return RMath.prevfp(Math.asin(d) / RMath.nextfp(Math.PI * 2));
    }

    static double asin2pi_hi(double d) {
        return RMath.nextfp(Math.asin(d) / RMath.prevfp(Math.PI * 2));
    }

    static double acos2pi_lo(double d) {
        return RMath.prevfp(Math.acos(d) / RMath.nextfp(Math.PI * 2));
    }

    static double acos2pi_hi(double d) {
        return RMath.nextfp(Math.acos(d) / RMath.prevfp(Math.PI * 2));
    }

    static double atan2pi_lo(double d) {
        return RMath.prevfp(Math.atan(d) / RMath.nextfp(Math.PI * 2));
    }

    static double atan2pi_hi(double d) {
        return RMath.nextfp(Math.atan(d) / RMath.prevfp(Math.PI * 2));
    }

    public static double pow_lo(double d, double d2) {
        if (d < 0.0) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d2 > 0.0) {
            if (d >= 1.0) {
                return RMath.exp_lo(RMath.mul_lo(d2, RMath.log_lo(d)));
            }
            if (d == 1.0) {
                return 1.0;
            }
            return RMath.exp_lo(RMath.mul_lo(d2, RMath.log_hi(d)));
        }
        if (d2 == 0.0) {
            return 1.0;
        }
        if (d >= 1.0) {
            return RMath.exp_lo(RMath.mul_lo(d2, RMath.log_hi(d)));
        }
        if (d == 1.0) {
            return 1.0;
        }
        return RMath.exp_lo(RMath.mul_lo(d2, RMath.log_lo(d)));
    }

    public static double pow_hi(double d, double d2) {
        if (d < 0.0) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d2 > 0.0) {
            if (d >= 1.0) {
                return RMath.exp_hi(RMath.mul_hi(d2, RMath.log_hi(d)));
            }
            if (d == 1.0) {
                return 1.0;
            }
            return RMath.exp_hi(RMath.mul_hi(d2, RMath.log_lo(d)));
        }
        if (d2 == 0.0) {
            return 1.0;
        }
        if (d >= 1.0) {
            return RMath.exp_lo(RMath.mul_hi(d2, RMath.log_lo(d)));
        }
        if (d == 1.0) {
            return 1.0;
        }
        return RMath.exp_lo(RMath.mul_hi(d2, RMath.log_hi(d)));
    }

    public static void main(String[] stringArray) {
        double d = 1.0E-300;
        System.out.println("   Zero = " + Zero);
        System.out.println("NegZero = " + NegZero);
        System.out.println("prevfp(Zero) = " + RMath.prevfp(Zero));
        System.out.println("nextfp(Zero) = " + RMath.nextfp(Zero));
        System.out.println("a = " + d);
        System.out.println("mul_lo(a,a) = " + RMath.mul_lo(d, d));
        System.out.println("mul_hi(a,a) = " + RMath.mul_hi(d, d));
    }
}

