/***************************************************************************
 *   Copyright (C) 2005 by Karye   *
 *   karye@users.sourceforge.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CACHEPORTAGEJOB_H
#define CACHEPORTAGEJOB_H

#include <QObject>
#include <ThreadWeaver/Job>
#include <ThreadWeaver/JobPointer>
#include <ThreadWeaver/QObjectDecorator>
#include <ThreadWeaver/Thread>
#include <threadweaver/jobinterface.h>  // for JobPointer

#include "progressjob.h"                // for ProgressJob

class DbConnection;

namespace ThreadWeaver {
class Thread;
}  // namespace ThreadWeaver

/**
 * @class CachePortageJob
 * @short Thread to cache package information from the Portage directory to speed up portage view refreshing.
 */
class CachePortageJob : public ProgressJob
{
	Q_OBJECT
public:
	CachePortageJob();
	~CachePortageJob();

protected:
	void run ( ThreadWeaver::JobPointer self, ThreadWeaver::Thread* ) override ;
	//void 						completeJob();

private:
	DbConnection* const 		m_db;
};

#endif
