#!/usr/bin/env perl
# is_valid_types_gen.pl

# Dynamically generate the list of valid types from object.h
# This is triggered to run on build, and the output is then included into the library as a source.
use strict;
# First step -- open object.h
open(my $file, "< ../include/object.h") or die "Failed to load object.h";
my $tmp;
my @arr;
my $max = 0;
my $search = 1;
# Look for a line with enum object_type
OUT: while(<$file>)
{
    if (/enum object_type/)
    {
        # Go until we find a };
        # Also move to the next line, since that is where the data starts.
        while (<$file>)
        {
            # If not the end of the enum
            last OUT if not (/^((?!.*};).*)$/);
            
            $tmp = $1; # Store the captured text.
            # Run it through a filter to get the data we want
            if ($tmp =~ /^\W*(\w+)\s*\=\s*(\d+)\,?.*$/)
            {
                $arr[$2] = 1;
                if ($1 == "OBJECT_TYPE_MAX")
                {
                    $max = $2;
                }
            }
        }
    }   
}
close($file);

# Now we build the output.
open(my $outfile, "> ./arch_types_valid.c") or die "Cannot write to file.";
print $outfile "/*****************************************\n";
print $outfile " * This file is automatically generated! *\n";
print $outfile " * Its contents will be overwritten on   *\n";
print $outfile " * the next build.                       *\n";
print $outfile " *                                       *\n";
print $outfile " * is_valid_types_gen.pl generates this. *\n";
print $outfile " *****************************************/\n";
print $outfile "\n/**\n";
print $outfile " * Checks if the specified type is a valid one for a Crossfire object.\n";
print $outfile " *\n";
print $outfile ' * @param type value to check.'."\n";
print $outfile ' * @return 1 if the type is valid, 0 else.'."\n";
print $outfile " */\n";
print $outfile "\#include <global.h>\n";
print $outfile "\#include <libproto.h>\n";
print $outfile "int is_type_valid(uint8_t type) {\n";
print $outfile "    if (type >= OBJECT_TYPE_MAX)\n";
print $outfile "        return 0;\n";
print $outfile "    switch (type){\n";
# Now we print the invalid types.
for (my $i = 1; $i < $max; ++$i)
{
    if ($arr[$i] != 1)
    {
        print $outfile "	case $i:\n";
    }
}
print $outfile "	    return 0;\n";
print $outfile "    }\n";
print $outfile "	return 1;\n";
print $outfile "}\n";
close($outfile);
