@ECHO OFF
REM ///////////////////////////////////////////////////////////////////////////
REM
REM Copyright (c) 2007-2009 Daniel Adler <dadler@uni-goettingen.de>, 
REM                         Tassilo Philipp <tphilipp@potion-studios.com>
REM
REM Permission to use, copy, modify, and distribute this software for any
REM purpose with or without fee is hereby granted, provided that the above
REM copyright notice and this permission notice appear in all copies.
REM
REM THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
REM WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
REM MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
REM ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
REM WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
REM ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
REM OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
REM
REM ///////////////////////////////////////////////////////////////////////////


SETLOCAL

REM Set default values.
SET PACKAGE=dyncall
SET CONFIG_HOST=windows
SET CONFIG_OS=windows
SET CONFIG_TOOL=msvc
SET CONFIG_ASM=ml
SET CONFIG_CONFIG=release
IF [%PROCESSOR_ARCHITECTURE%] == [AMD64] (
	SET CONFIG_ARCH=x64
) ELSE IF [%PROCESSOR_ARCHITEW6432%] == [AMD64] (
	SET CONFIG_ARCH=x64
) ELSE (
	SET CONFIG_ARCH=x86
)

REM Scan arguments.
:MAIN_LOOP


REM Help.
IF [%1]==[] (
	GOTO DONE
) ELSE IF [%1]==[/?] (
	ECHO.
	ECHO.dyncall configuration shell-script
	ECHO.Usage:
	ECHO.  configure.bat [ options ]
	ECHO.
	ECHO.Options:
	ECHO.  /?                print this page
	ECHO.
	ECHO.  /prefix PATH      set installation prefix ^(GNU make only^)
	ECHO.  /prefix-bd PATH   set build directory prefix ^(GNU make only^)
	ECHO.                    ^(only for use with gmake^)
	ECHO.
	ECHO.  /target-x86       build for x86 architecture
	ECHO.  /target-x64       build for x64 architecture
	ECHO.  /target-psp       build for PlayStation Portable ^(homebrew SDK^)
	ECHO.  /target-nds-arm   build for Nintendo DS ^(devkitPro, ARM mode^)
	ECHO.  /target-nds-thumb build for Nintendo DS ^(devkitPro, THUMB mode^)
	ECHO.
	ECHO.  /tool-msvc        use Microsoft Visual C++ compiler ^(default^)
	ECHO.  /tool-gcc         use GNU Compiler Collection
	ECHO.
	ECHO.  /asm-ml           use Microsoft Macro Assembler ^(default^)
	ECHO.  /asm-as           use the GNU Assembler
	ECHO.  /asm-nasm         use NASM Assembler
	ECHO.
	ECHO.  /config-release   build release version ^(default^)
	ECHO.  /config-debug     build debug version
	GOTO:EOF
) ELSE IF [%1]==[/prefix] (
	SET CONFIG_PREFIX=%2
	SHIFT
) ELSE IF [%1]==[/prefix-bd] (
	SET CONFIG_BUILDPREFIX=%2
	SHIFT
) ELSE IF [%1]==[/target-x86] (
	SET CONFIG_ARCH=x86
) ELSE IF [%1]==[/target-x64] (
	SET CONFIG_ARCH=x64
) ELSE IF [%1]==[/target-psp] (
	SET CONFIG_ARCH=mips32
	SET CONFIG_OS=psp
) ELSE IF [%1]==[/target-nds-arm] (
	SET CONFIG_ARCH=arm32_arm
	SET CONFIG_OS=nds
) ELSE IF [%1]==[/target-nds-thumb] (
	SET CONFIG_ARCH=arm32_thumb
	SET CONFIG_OS=nds
) ELSE IF [%1]==[/tool-gcc] (
	SET CONFIG_TOOL=gcc
	SET CONFIG_ASM=as
) ELSE IF [%1]==[/tool-msvc] (
	SET CONFIG_TOOL=msvc
	SET CONFIG_ASM=ml
) ELSE IF [%1]==[/asm-as] (
	SET CONFIG_ASM=as
) ELSE IF [%1]==[/asm-nasm] (
	SET CONFIG_ASM=nasm
) ELSE IF [%1]==[/asm-ml] (
	SET CONFIG_ASM=ml
) ELSE IF [%1]==[/config-release] (
	SET CONFIG_CONFIG=release
) ELSE IF [%1]==[/config-debug] (
	SET CONFIG_CONFIG=debug
) ELSE (
	ECHO Unknown parameter '%1'.
	GOTO DONE
)

SHIFT
GOTO MAIN_LOOP
:DONE

IF [%CONFIG_PREFIX%]==[] (
	SET CONFIG_PREFIX=%CD%\install_%CONFIG_OS%_%CONFIG_ARCH%_%CONFIG_TOOL%_%CONFIG_CONFIG%
)
IF [%CONFIG_BUILDPREFIX%]==[] (
	SET CONFIG_BUILDPREFIX=%CD%\build_out\%CONFIG_OS%_%CONFIG_ARCH%_%CONFIG_TOOL%_%CONFIG_CONFIG%
)

ECHO # auto-generated by configure.bat >ConfigVars
ECHO CONFIG_PACKAGE=%PACKAGE%#>>ConfigVars
ECHO CONFIG_HOST=%CONFIG_HOST%#>>ConfigVars
ECHO CONFIG_OS=%CONFIG_OS%#>>ConfigVars
ECHO CONFIG_ARCH=%CONFIG_ARCH%#>>ConfigVars
ECHO CONFIG_TOOL=%CONFIG_TOOL%#>>ConfigVars
ECHO CONFIG_ASM=%CONFIG_ASM%#>>ConfigVars
ECHO CONFIG_CONFIG=%CONFIG_CONFIG%#>>ConfigVars
ECHO CONFIG_PREFIX=%CONFIG_PREFIX%#>>ConfigVars
ECHO CONFIG_BUILDPREFIX=%CONFIG_BUILDPREFIX%#>>ConfigVars

ECHO Writing following configuration to ConfigVars:
ECHO.
ECHO Host OS:             %CONFIG_HOST%
ECHO Target OS:           %CONFIG_OS%
ECHO Target Architecture: %CONFIG_ARCH%
ECHO Compiler:            %CONFIG_TOOL%
ECHO Assembler:           %CONFIG_ASM%
ECHO Build configuration: %CONFIG_CONFIG%
ECHO Install prefix:      %CONFIG_PREFIX%
ECHO Build prefix:        %CONFIG_BUILDPREFIX%


REM We have to transform some pathes for the nds/devkitPro build.
IF [%CONFIG_OS%]==[nds] (
	REM Check if DEVKITPRO is set.
	IF [%DEVKITPRO%]==[] (
		ECHO ERROR: Environment variable DEVKITPRO must be set to absolute devkitPro path.
	) ELSE (
		buildsys\scripts\conf-nds.bat
	)
)
