/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.security;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.xmind.core.CoreException;
import org.xmind.core.IChecksumStream;
import org.xmind.core.internal.security.Base64;

public class ChecksumOutputStream
extends FilterOutputStream
implements IChecksumStream {
    private Digest digest = new MD5Digest();
    private String checksum = null;

    public ChecksumOutputStream(OutputStream output) throws CoreException {
        super(output);
    }

    public void write(int b) throws IOException {
        this.digest.update((byte)b);
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.digest.update(b, 0, b.length);
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.digest.update(b, off, len);
        this.out.write(b, off, len);
    }

    public String getChecksum() {
        if (this.checksum == null) {
            byte[] checksumBytes = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(checksumBytes, 0);
            this.checksum = Base64.byteArrayToBase64(checksumBytes);
        }
        return this.checksum;
    }
}

