/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.core.IFileEntry;
import org.xmind.core.ITopic;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.ui.internal.dialogs.DialogMessages;

public class SaveAttachmentAsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Program p;
        ITopic sourceTopic = this.getSourceTopic(event);
        if (sourceTopic == null) {
            return null;
        }
        String url = sourceTopic.getHyperlink();
        if (url == null || !HyperlinkUtils.isAttachmentURL((String)url)) {
            return null;
        }
        String entryPath = HyperlinkUtils.toAttachmentPath((String)url);
        final IFileEntry entry = sourceTopic.getOwnedWorkbook().getManifest().getFileEntry(entryPath);
        if (entry == null) {
            return null;
        }
        String ext = FileUtils.getExtension((String)entryPath);
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        dialog.setFilterExtensions(new String[]{"*" + ext, "*.*"});
        String extension = ext;
        if (ext != null && (p = Program.findProgram((String)ext)) != null) {
            extension = p.getName();
        }
        dialog.setFilterNames(new String[]{extension, NLS.bind((String)"{0} (*.*)", (Object)DialogMessages.AllFilesFilterName)});
        String name = sourceTopic.getTitleText();
        if (name != null && !name.endsWith(ext)) {
            name = String.valueOf(name) + ext;
        }
        if (name != null) {
            dialog.setFileName(name);
        }
        dialog.setOverwrite(true);
        final String targetPath = dialog.open();
        if (targetPath == null) {
            return null;
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                InputStream is = entry.openInputStream();
                try {
                    FileOutputStream os = new FileOutputStream(targetPath);
                    try {
                        FileUtils.transfer((InputStream)is, (OutputStream)os, (boolean)true);
                    }
                    finally {
                        os.close();
                    }
                }
                finally {
                    is.close();
                }
            }
        });
        return null;
    }

    private ITopic getSourceTopic(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof ITopic)) continue;
                return (ITopic)element;
            }
        }
        return null;
    }
}

