/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.ui.IMemento;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IDeserializer;
import org.xmind.core.IWorkbook;
import org.xmind.core.io.BundleResource;
import org.xmind.core.io.BundleResourceInputSource;
import org.xmind.core.io.DirectoryInputSource;
import org.xmind.core.io.IInputSource;
import org.xmind.core.util.IProgressReporter;
import org.xmind.core.util.ProgressReporter;
import org.xmind.ui.internal.editor.AbstractWorkbookRef;

public class URLWorkbookRef
extends AbstractWorkbookRef {
    private static final String SCHEME_PLATFORM = "platform";
    private static final String ATT_NAME = "name";
    private static Map<URLWorkbookRef, URI> cache = new WeakHashMap<URLWorkbookRef, URI>();
    private String name;

    private URLWorkbookRef(URI uri, String name, IMemento state) {
        super(uri, state);
        Assert.isNotNull((Object)uri);
        this.name = name == null ? (state == null ? null : state.getString(ATT_NAME)) : name;
    }

    public boolean canSave() {
        return false;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return super.getName();
    }

    @Override
    protected void saveState(IMemento memento) {
        if (this.name != null) {
            memento.putString(ATT_NAME, this.name);
        }
        super.saveState(memento);
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }

    public boolean equals(Object obj) {
        URI thatURI;
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof URLWorkbookRef)) {
            return false;
        }
        URLWorkbookRef that = (URLWorkbookRef)obj;
        URI thisURI = this.getURI();
        return thisURI == (thatURI = that.getURI()) || thisURI != null && thisURI.equals(thatURI);
    }

    public String toString() {
        return this.getURI().toString();
    }

    public static URLWorkbookRef create(URI uri, IMemento state) {
        URLWorkbookRef wr2;
        if (uri == null) {
            return null;
        }
        if (state != null) {
            return new URLWorkbookRef(uri, null, state);
        }
        for (URLWorkbookRef wr2 : cache.keySet()) {
            if (!uri.equals(wr2.getURI())) continue;
            return wr2;
        }
        wr2 = new URLWorkbookRef(uri, null, null);
        cache.put(wr2, uri);
        return wr2;
    }

    public static URLWorkbookRef create(URI uri, String name) {
        URLWorkbookRef wr2;
        if (uri == null) {
            return null;
        }
        for (URLWorkbookRef wr2 : cache.keySet()) {
            if (!uri.equals(wr2.getURI())) continue;
            return wr2;
        }
        wr2 = new URLWorkbookRef(uri, name, null);
        cache.put(wr2, uri);
        return wr2;
    }

    @Override
    protected IWorkbook doLoadWorkbookFromURI(IProgressMonitor monitor, URI uri) throws InterruptedException, InvocationTargetException {
        try {
            if (URIUtil.isFileURI((URI)uri)) {
                return this.loadFromFileURI(monitor, uri);
            }
            if (SCHEME_PLATFORM.equalsIgnoreCase(uri.getScheme())) {
                return this.loadFromPlatformURI(monitor, uri);
            }
            return this.loadFromGenericURI(monitor, uri);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private IWorkbook loadFromGenericURI(IProgressMonitor monitor, URI uri) throws IOException, CoreException {
        URL url = uri.toURL();
        InputStream stream = url.openStream();
        try {
            IDeserializer deserializer = Core.getWorkbookBuilder().newDeserializer();
            deserializer.setWorkbookStorage(this.getTempStorage());
            deserializer.setEntryStreamNormalizer(this.getEncryptionHandler());
            deserializer.setInputStream(stream);
            ProgressReporter reporter = new ProgressReporter(monitor);
            deserializer.deserialize((IProgressReporter)reporter);
            IWorkbook iWorkbook = deserializer.getWorkbook();
            return iWorkbook;
        }
        finally {
            stream.close();
        }
    }

    private IWorkbook loadFromFileURI(IProgressMonitor monitor, URI uri) throws IOException, CoreException {
        File file = URIUtil.toFile((URI)uri);
        if (file.isDirectory()) {
            IDeserializer deserializer = Core.getWorkbookBuilder().newDeserializer();
            deserializer.setWorkbookStorage(this.getTempStorage());
            deserializer.setInputSource((IInputSource)new DirectoryInputSource(file));
            deserializer.setEntryStreamNormalizer(this.getEncryptionHandler());
            deserializer.deserialize((IProgressReporter)new ProgressReporter(monitor));
            return deserializer.getWorkbook();
        }
        return this.loadFromGenericURI(monitor, uri);
    }

    private IWorkbook loadFromPlatformURI(IProgressMonitor monitor, URI uri) throws IOException, CoreException {
        BundleResource resolvedResource;
        BundleResource resource;
        URL url = new URL(uri.getScheme(), uri.getAuthority(), uri.getPath());
        try {
            resource = new BundleResource(url);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            resource = null;
        }
        if (resource != null && (resolvedResource = resource.resolve()) != null && resolvedResource.getPath().hasTrailingSeparator()) {
            IDeserializer deserializer = Core.getWorkbookBuilder().newDeserializer();
            deserializer.setWorkbookStorage(this.getTempStorage());
            deserializer.setInputSource((IInputSource)new BundleResourceInputSource(resolvedResource));
            deserializer.setEntryStreamNormalizer(this.getEncryptionHandler());
            deserializer.deserialize((IProgressReporter)new ProgressReporter(monitor));
            return deserializer.getWorkbook();
        }
        URL locatedURL = FileLocator.find((URL)url);
        if (locatedURL != null) {
            url = locatedURL;
        }
        InputStream stream = url.openStream();
        try {
            IDeserializer deserializer = Core.getWorkbookBuilder().newDeserializer();
            deserializer.setWorkbookStorage(this.getTempStorage());
            deserializer.setEntryStreamNormalizer(this.getEncryptionHandler());
            deserializer.setInputStream(stream);
            deserializer.deserialize((IProgressReporter)new ProgressReporter(monitor));
            IWorkbook iWorkbook = deserializer.getWorkbook();
            return iWorkbook;
        }
        finally {
            stream.close();
        }
    }
}

