/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4models;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.style.IStyle;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.e4models.IContextRunnable;
import org.xmind.ui.internal.e4models.ViewModelPart;
import org.xmind.ui.internal.editor.MindMapEditor;
import org.xmind.ui.internal.utils.ResourceUtils;
import org.xmind.ui.internal.views.CategorizedThemeViewer;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;

public class ThemesPart
extends ViewModelPart
implements ICoreEventListener,
IPageChangedListener {
    private CategorizedThemeViewer viewer;
    private ICoreEventRegister register = null;
    private IGraphicalEditor sourceEditor;
    private ICoreEventRegister topicRegister = null;
    private ITopic rootTopic;

    protected Control doCreateContent(Composite parent) {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ShowThemeCount");
        Composite container = new Composite(parent, 0);
        container.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.registerContextMenu(container, "org.xmind.ui.dialogPart.resourceManager.theme.popupMenu");
        this.viewer = new CategorizedThemeViewer(container){

            @Override
            protected void postInit() {
                this.getProperties().set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(240, 120));
                super.postInit();
            }
        };
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = Util.isMac() ? 8 : -2;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.setSelectionProvider((ISelectionProvider)this.viewer);
        ICoreEventSupport ces = (ICoreEventSupport)MindMapUI.getResourceManager().getUserThemeSheet().getAdapter(ICoreEventSupport.class);
        this.register = new CoreEventRegister((ICoreEventListener)this);
        this.register.setNextSupport(ces);
        this.register.register("styleAdd");
        this.register.register("styleRemove");
        this.register.register("name");
        return container;
    }

    public void handleCoreEvent(final CoreEvent event) {
        if (this.viewer == null) {
            return;
        }
        Control c = this.viewer.getControl();
        if (c == null || c.isDisposed()) {
            return;
        }
        c.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!"themeId".equals(event.getType())) {
                    if ("name".equals(event.getType())) {
                        ThemesPart.this.viewer.update(new Object[]{event.getSource()});
                    } else if ("styleAdd".equals(event.getType())) {
                        ThemesPart.this.viewer.refresh();
                        Object target = event.getTarget();
                        ThemesPart.this.viewer.setSelection((ISelection)(target == null ? StructuredSelection.EMPTY : new StructuredSelection(target)), true);
                    } else if ("styleRemove".equals(event.getType())) {
                        ThemesPart.this.viewer.setInput(ThemesPart.this.viewer.getInput());
                    } else if ("structureClass".endsWith(event.getType())) {
                        ThemesPart.this.viewer.refresh(true);
                    }
                }
            }
        });
    }

    public void dispose() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
        if (this.topicRegister != null) {
            this.topicRegister.unregisterAll();
            this.topicRegister = null;
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.removePageChangedListener((IPageChangedListener)this);
            this.sourceEditor = null;
        }
        super.dispose();
        this.viewer = null;
    }

    public void init() {
        super.init();
        this.registerRunnables();
        this.registerViewMenu("org.xmind.ui.modelPart.theme.viewMenu");
    }

    private void registerRunnables() {
        IEclipseContext ec = ((MPart)this.getAdapter(MPart.class)).getContext();
        ec.set("org.xmind.ui.modelPart.refreshPage", (Object)new IContextRunnable(){

            public void run() {
                if (ThemesPart.this.viewer != null && ThemesPart.this.viewer.getControl() != null && !ThemesPart.this.viewer.getControl().isDisposed()) {
                    ThemesPart.this.viewer.refresh();
                }
            }
        });
        ec.set("org.xmind.ui.modelPart.rename", (Object)new IContextRunnable(){

            public void run() {
                List themes;
                if (ThemesPart.this.viewer != null && ThemesPart.this.viewer.getControl() != null && !ThemesPart.this.viewer.getControl().isDisposed() && (themes = ThemesPart.this.getSelectedThemes()).size() == 1) {
                    ThemesPart.this.viewer.startEditing((IStyle)themes.get(0));
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                List themes = ThemesPart.this.getSelectedThemes();
                Set systemThemeSets = MindMapUI.getResourceManager().getSystemThemeSheet().getStyles("master-styles");
                boolean canExecute = themes.size() == 1;
                for (IStyle theme : themes) {
                    boolean bl = canExecute = canExecute && !systemThemeSets.contains(theme);
                }
                return canExecute;
            }
        });
        ec.set("org.xmind.ui.modelPart.duplicate", (Object)new IContextRunnable(){

            public void run() {
                List themes;
                if (ThemesPart.this.viewer != null && ThemesPart.this.viewer.getControl() != null && !ThemesPart.this.viewer.getControl().isDisposed() && !(themes = ThemesPart.this.getSelectedThemes()).isEmpty()) {
                    ResourceUtils.duplicateThemes(themes);
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                List themes = ThemesPart.this.getSelectedThemes();
                boolean canExecute = !themes.isEmpty();
                return canExecute;
            }
        });
        ec.set("org.xmind.ui.modelPart.delete", (Object)new IContextRunnable(){

            public void run() {
                List themes;
                if (ThemesPart.this.viewer != null && ThemesPart.this.viewer.getControl() != null && !ThemesPart.this.viewer.getControl().isDisposed() && !(themes = ThemesPart.this.getSelectedThemes()).isEmpty() && ResourceUtils.confirmToDeleteStyles(ThemesPart.this.viewer.getControl().getShell(), themes)) {
                    ResourceUtils.deleteStyles(themes);
                }
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                List themes = ThemesPart.this.getSelectedThemes();
                Set systemThemeSets = MindMapUI.getResourceManager().getSystemThemeSheet().getStyles("master-styles");
                boolean canExecute = !themes.isEmpty();
                for (IStyle theme : themes) {
                    boolean bl = canExecute = canExecute && !systemThemeSets.contains(theme);
                }
                return canExecute;
            }
        });
    }

    private List<IStyle> getSelectedThemes() {
        IStructuredSelection selection;
        ArrayList<IStyle> styles = new ArrayList<IStyle>();
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed() && (selection = this.viewer.getStructuredSelection()) instanceof IStructuredSelection) {
            for (Object element : selection.toList()) {
                styles.add((IStyle)element);
            }
        }
        return styles;
    }

    private ITopic findRootTopic(IGraphicalEditorPage page) {
        ISheet sheet = (ISheet)page.getAdapter(ISheet.class);
        if (sheet != null) {
            return sheet.getRootTopic();
        }
        return null;
    }

    private void setRootTopic(ITopic topic) {
        if (topic == this.rootTopic) {
            return;
        }
        if (this.topicRegister == null) {
            this.topicRegister = new CoreEventRegister((ICoreEventListener)this);
        }
        if (this.rootTopic != null) {
            this.topicRegister.unregisterAll();
        }
        if (topic != null) {
            if (this.viewer != null) {
                this.viewer.refresh(true);
            }
            this.topicRegister.setNextSourceFrom((Object)topic);
            this.topicRegister.register("structureClass");
        }
    }

    private void setEditor(IGraphicalEditor editor) {
        if (editor == this.sourceEditor) {
            return;
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.removePageChangedListener((IPageChangedListener)this);
        }
        this.sourceEditor = editor;
        if (this.sourceEditor != null) {
            this.sourceEditor.addPageChangedListener((IPageChangedListener)this);
            IGraphicalEditorPage page = this.sourceEditor.getActivePageInstance();
            if (page != null) {
                this.setRootTopic(this.findRootTopic(page));
            }
        }
    }

    protected void handlePartActivated(MPart part) {
        super.handlePartActivated(part);
        final IEditorPart editorPart = (IEditorPart)part.getContext().get(IEditorPart.class);
        if (editorPart instanceof MindMapEditor) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ThemesPart.this.setEditor((IGraphicalEditor)((MindMapEditor)editorPart));
                }
            });
        }
    }

    public void pageChanged(PageChangedEvent event) {
        final IGraphicalEditorPage page = (IGraphicalEditorPage)event.getSelectedPage();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (page.isDisposed() || page.getControl() == null || page.getControl().isDisposed()) {
                    return;
                }
                ThemesPart.this.setRootTopic(ThemesPart.this.findRootTopic(page));
            }
        });
    }
}

