/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.HashSet;
import java.util.Set;
import org.xmind.ui.branch.BranchStructureData;
import org.xmind.ui.mindmap.IBranchPart;

public class TimelineHorizontalData
extends BranchStructureData {
    private Set<Integer> upwardBranch = null;

    public TimelineHorizontalData(IBranchPart branch) {
        super(branch);
    }

    public boolean isUpwardBranch(int index) {
        return this.getUpwardBranch().contains(index);
    }

    public Set<Integer> getUpwardBranch() {
        if (this.upwardBranch == null) {
            this.upwardBranch = this.calcUpwardBranchs();
        }
        return this.upwardBranch;
    }

    private Set<Integer> calcUpwardBranchs() {
        HashSet<Integer> set = new HashSet<Integer>();
        int i = 0;
        IBranchPart lastChild = null;
        boolean upwards = true;
        for (IBranchPart sub : this.getBranch().getSubBranches()) {
            if (lastChild == null) {
                set.add(i);
            } else {
                if (!this.isInSameRange(lastChild, sub)) {
                    boolean bl = upwards = !upwards;
                }
                if (upwards) {
                    set.add(i);
                }
            }
            lastChild = sub;
            ++i;
        }
        return set;
    }
}

