/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.share.jobs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import net.xmind.share.FileValidationException;
import net.xmind.share.Info;
import net.xmind.share.Messages;
import net.xmind.share.Uploader;
import net.xmind.share.XmindSharePlugin;
import net.xmind.share.jobs.UploadSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.xmind.core.Core;
import org.xmind.core.ISerializer;
import org.xmind.core.IWorkbook;
import org.xmind.ui.exports.vector.svg.SVGGenerator;

public class UploadJob
extends Job {
    private Info info;
    private UploadSession session;
    private TransferWorker transferWorker;
    private SVGGenerator svgGenerator;
    private File svgFile;

    public UploadJob(Info info, SVGGenerator svgGenerator) {
        super(NLS.bind((String)Messages.UploadJob_name, (Object)info.getString("Title")));
        this.info = info;
        this.svgGenerator = svgGenerator;
    }

    public UploadSession getSession() {
        return this.session;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = this.upload(monitor);
        this.clearTemp();
        if (status.matches(4)) {
            XmindSharePlugin.getDefault().getLog().log(status);
            status = new Status(2, status.getPlugin(), status.getCode(), status.getMessage() == null || "".equals(status.getMessage()) ? Messages.UploadJob_Failure_message : status.getMessage(), status.getException());
        }
        return status;
    }

    private IStatus upload(IProgressMonitor monitor) {
        monitor.beginTask(null, 100);
        this.session = new UploadSession(this.info);
        monitor.subTask(Messages.UploadJob_Task_Prepare);
        this.session.prepare();
        if (this.session.hasError()) {
            return this.session.getError();
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(5);
        String permalink = this.session.getPermalink();
        if (permalink == null) {
            return new Status(4, "net.xmind.signin", "Upload session is prepared, but has no permalink to use.");
        }
        IStatus saved = this.savePermalink(permalink);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (saved != null && !saved.isOK()) {
            return saved;
        }
        monitor.worked(5);
        if (this.svgGenerator != null) {
            this.svgFile = this.svgGenerator.generate();
            if (this.svgFile != null) {
                this.session.setSvgFile(this.svgFile);
            }
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(40);
        monitor.subTask(Messages.UploadJob_Task_TransferFile);
        this.transferWorker = new TransferWorker();
        this.transferWorker.start();
        if (this.session.hasError()) {
            return this.session.getError();
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        ProgressWorker progressWorker = new ProgressWorker(monitor, 89);
        progressWorker.start();
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                return Status.CANCEL_STATUS;
            }
            if (this.session.hasError()) {
                return this.session.getError();
            }
            if (!monitor.isCanceled()) continue;
            monitor.subTask(Messages.UploadJob_Task_Cancel);
            this.session.cancel();
            progressWorker.cancel();
            if (this.session.hasError()) {
                return this.session.getError();
            }
            return Status.CANCEL_STATUS;
        } while (!progressWorker.isCompleted());
        monitor.done();
        return Status.OK_STATUS;
    }

    private IStatus savePermalink(String permalink) {
        IWorkbook workbook = (IWorkbook)this.info.getProperty("Workbook");
        if (workbook == null) {
            return new Status(4, "com.xmindshare.uploader", "Failed to save source URL. No workbook available");
        }
        workbook.getMeta().setValue("Share/SourceUrl", permalink);
        File file = (File)this.info.getProperty("File");
        if (file == null) {
            return new Status(4, "com.xmindshare.uploader", "Failed to save source URL. No file available.");
        }
        try {
            FileOutputStream output = new FileOutputStream(file);
            try {
                ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
                serializer.setWorkbook(workbook);
                serializer.setOutputStream((OutputStream)output);
                serializer.serialize(null);
            }
            finally {
                ((OutputStream)output).close();
            }
        }
        catch (Throwable e) {
            return new Status(4, "com.xmindshare.uploader", "Failed to save source URL due to error: " + e.getLocalizedMessage(), e);
        }
        String path = file.getAbsolutePath();
        try {
            Uploader.validateUploadFile(path);
        }
        catch (FileValidationException e) {
            return new Status(4, "com.xmindshare.uploader", "Failed to save source URL due to file corruption: " + e.getLocalizedMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected void canceling() {
        if (this.session != null) {
            this.session.cancel();
        }
        super.canceling();
    }

    private void clearTemp() {
        if (this.svgFile != null) {
            this.svgFile.delete();
            this.svgFile = null;
        }
    }

    private class ProgressWorker
    implements Runnable {
        private IProgressMonitor monitor;
        private int ticks;
        private Thread thread = null;
        private int ticksUploaded = 0;

        public ProgressWorker(IProgressMonitor monitor, int ticks) {
            this.monitor = monitor;
            this.ticks = ticks;
        }

        public void start() {
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread(this);
            this.thread.setName("ProgressWorker:" + UploadJob.this.info.getString("Title"));
            this.thread.setDaemon(true);
            this.thread.setPriority(1);
            this.thread.start();
        }

        public void cancel() {
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
        }

        public boolean isCompleted() {
            return UploadJob.this.session.getStatus() == 3;
        }

        public void run() {
            while (!(this.monitor.isCanceled() || UploadJob.this.session.hasError() || this.isCompleted())) {
                UploadJob.this.session.retrieveProgress();
                if (this.monitor.isCanceled() || UploadJob.this.session.hasError()) {
                    return;
                }
                if (this.isCompleted()) {
                    this.monitor.worked(this.ticks - this.ticksUploaded);
                    this.ticksUploaded = this.ticks;
                    return;
                }
                int newUploaded = (int)(UploadJob.this.session.getUploadProgress() * (double)this.ticks);
                if (newUploaded > this.ticksUploaded) {
                    this.monitor.worked(newUploaded - this.ticksUploaded);
                    this.ticksUploaded = newUploaded;
                }
                try {
                    Thread.sleep(760L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    private class TransferWorker
    implements Runnable {
        private Thread thread = null;

        private TransferWorker() {
        }

        public void start() {
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread(this);
            this.thread.setName("Upload:" + UploadJob.this.info.getString("Title"));
            this.thread.setDaemon(false);
            this.thread.setPriority(5);
            this.thread.start();
        }

        public void run() {
            UploadJob.this.session.transfer();
        }
    }
}

