/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SourceLocationProvider;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInListType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.LexicalHandler;

public class ReceivingContentHandler
implements ContentHandler,
LexicalHandler,
DTDHandler {
    private PipelineConfiguration pipe;
    private Receiver receiver;
    private boolean inDTD = false;
    private Locator locator;
    private LocalLocator localLocator = new LocalLocator();
    private char[] buffer = new char[512];
    private int charsUsed = 0;
    private CharSlice slice = new CharSlice(this.buffer, 0, 0);
    private NamespaceBinding[] namespaces = new NamespaceBinding[20];
    private int namespacesUsed = 0;
    private boolean ignoreIgnorable = false;
    private boolean retainDTDAttributeTypes = false;
    private boolean suppressDTDAttributeDefaults = false;
    private boolean allowDisableOutputEscaping = false;
    private boolean escapingDisabled = false;
    private boolean afterStartTag = true;
    private HashMap<String, HashMap<Object, NodeName>> nameCache = new HashMap(10);
    private HashMap<Object, NodeName> noNamespaceNameCache = new HashMap(10);

    public void reset() {
        this.pipe = null;
        this.receiver = null;
        this.ignoreIgnorable = false;
        this.retainDTDAttributeTypes = false;
        this.charsUsed = 0;
        this.slice.setLength(0);
        this.namespacesUsed = 0;
        this.locator = null;
        this.allowDisableOutputEscaping = false;
        this.escapingDisabled = false;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
        pipe.setLocationProvider(this.localLocator);
        Configuration config = pipe.getConfiguration();
        this.ignoreIgnorable = pipe.getParseOptions().getStripSpace() != 0;
        this.retainDTDAttributeTypes = config.getBooleanProperty("http://saxon.sf.net/feature/retain-dtd-attribute-types");
        this.suppressDTDAttributeDefaults = !pipe.getParseOptions().isExpandAttributeDefaults();
        this.allowDisableOutputEscaping = (Boolean)config.getConfigurationProperty("http://saxon.sf.net/feature/use-pi-disable-output-escaping");
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public Configuration getConfiguration() {
        return this.pipe.getConfiguration();
    }

    public void setIgnoreIgnorableWhitespace(boolean ignore) {
        this.ignoreIgnorable = ignore;
    }

    public boolean isIgnoringIgnorableWhitespace() {
        return this.ignoreIgnorable;
    }

    public void startDocument() throws SAXException {
        try {
            this.charsUsed = 0;
            this.namespacesUsed = 0;
            this.pipe.setLocationProvider(this.localLocator);
            this.receiver.setPipelineConfiguration(this.pipe);
            this.receiver.setSystemId(this.localLocator.getSystemId());
            this.receiver.open();
            this.receiver.startDocument(0);
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.flush(true);
            this.receiver.endDocument();
            this.receiver.close();
        }
        catch (ValidationException err) {
            err.setLocator(this.locator);
            throw new SAXException(err);
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix.equals("xmlns")) {
            return;
        }
        if (this.namespacesUsed >= this.namespaces.length) {
            NamespaceBinding[] n2 = new NamespaceBinding[this.namespacesUsed * 2];
            System.arraycopy(this.namespaces, 0, n2, 0, this.namespacesUsed);
            this.namespaces = n2;
        }
        this.namespaces[this.namespacesUsed++] = new NamespaceBinding(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localname, String rawname, Attributes atts) throws SAXException {
        try {
            this.flush(true);
            NodeName elementName = this.getNodeName(uri, localname, rawname);
            this.receiver.startElement(elementName, Untyped.getInstance(), 0, 64);
            for (int n = 0; n < this.namespacesUsed; ++n) {
                this.receiver.namespace(this.namespaces[n], 0);
            }
            for (int a = 0; a < atts.getLength(); ++a) {
                int properties = 64;
                String qname = atts.getQName(a);
                if (qname.startsWith("xmlns") && (qname.equals("xmlns") || qname.startsWith("xmlns:")) || this.suppressDTDAttributeDefaults && atts instanceof Attributes2 && !((Attributes2)atts).isSpecified(qname)) continue;
                NodeName attCode = this.getNodeName(atts.getURI(a), atts.getLocalName(a), atts.getQName(a));
                String type = atts.getType(a);
                SimpleType typeCode = BuiltInAtomicType.UNTYPED_ATOMIC;
                if (this.retainDTDAttributeTypes) {
                    if (!type.equals("CDATA")) {
                        if (type.equals("ID")) {
                            typeCode = BuiltInAtomicType.ID;
                        } else if (type.equals("IDREF")) {
                            typeCode = BuiltInAtomicType.IDREF;
                        } else if (type.equals("IDREFS")) {
                            typeCode = BuiltInListType.IDREFS;
                        } else if (type.equals("NMTOKEN")) {
                            typeCode = BuiltInAtomicType.NMTOKEN;
                        } else if (type.equals("NMTOKENS")) {
                            typeCode = BuiltInListType.NMTOKENS;
                        } else if (type.equals("ENTITY")) {
                            typeCode = BuiltInAtomicType.ENTITY;
                        } else if (type.equals("ENTITIES")) {
                            typeCode = BuiltInListType.ENTITIES;
                        }
                    }
                } else if (type.equals("ID")) {
                    properties |= 0x800;
                } else if (type.equals("IDREF")) {
                    properties |= 0x1000;
                } else if (type.equals("IDREFS")) {
                    properties |= 0x1000;
                }
                this.receiver.attribute(attCode, typeCode, atts.getValue(a), 0, properties);
            }
            this.afterStartTag = true;
            this.receiver.startContent();
            this.namespacesUsed = 0;
        }
        catch (ValidationException err) {
            if (err.getLineNumber() == -1) {
                err.setLocator(this.locator);
            }
            throw new SAXException(err);
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    private NodeName getNodeName(String uri, String localname, String rawname) throws SAXException {
        NodeName n;
        HashMap<Object, NodeName> map2;
        if (rawname.length() == 0) {
            throw new SAXException("Saxon requires an XML parser that reports the QName of each element");
        }
        if (localname.length() == 0) {
            throw new SAXException("Parser configuration problem: namespace reporting is not enabled");
        }
        HashMap<Object, NodeName> hashMap = map2 = uri.length() == 0 ? this.noNamespaceNameCache : this.nameCache.get(uri);
        if (map2 == null) {
            map2 = new HashMap(50);
            this.nameCache.put(uri, map2);
            if (uri.length() == 0) {
                this.noNamespaceNameCache = map2;
            }
        }
        if ((n = map2.get(rawname)) == null) {
            if (uri.length() == 0) {
                NoNamespaceName qn = new NoNamespaceName(localname);
                map2.put(rawname, qn);
                return qn;
            }
            String prefix = NameChecker.getPrefix(rawname);
            FingerprintedQName qn = new FingerprintedQName(prefix, uri, localname);
            map2.put(rawname, qn);
            return qn;
        }
        return n;
    }

    public void endElement(String uri, String localname, String rawname) throws SAXException {
        try {
            this.flush(!this.afterStartTag);
            this.receiver.endElement();
        }
        catch (ValidationException err) {
            err.maybeSetLocation(ExpressionLocation.makeFromSax(this.locator));
            if (!err.hasBeenReported()) {
                this.pipe.getErrorListener().fatalError(err);
            }
            err.setHasBeenReported(true);
            throw new SAXException(err);
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
        this.afterStartTag = false;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        while (this.charsUsed + length > this.buffer.length) {
            char[] newbuffer = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newbuffer, 0, this.charsUsed);
            this.buffer = newbuffer;
            this.slice = new CharSlice(this.buffer, 0, 0);
        }
        System.arraycopy(ch, start, this.buffer, this.charsUsed, length);
        this.charsUsed += length;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.ignoreIgnorable) {
            this.characters(ch, start, length);
        }
    }

    public void processingInstruction(String name, String remainder) throws SAXException {
        try {
            this.flush(true);
            if (!this.inDTD) {
                if (name == null) {
                    this.comment(remainder.toCharArray(), 0, remainder.length());
                } else {
                    if (!NameChecker.isValidNCName(name)) {
                        throw new SAXException("Invalid processing instruction name (" + name + ')');
                    }
                    if (this.allowDisableOutputEscaping) {
                        if (name.equals("javax.xml.transform.disable-output-escaping")) {
                            this.escapingDisabled = true;
                            return;
                        }
                        if (name.equals("javax.xml.transform.enable-output-escaping")) {
                            this.escapingDisabled = false;
                            return;
                        }
                    }
                    this.receiver.processingInstruction(name, Whitespace.removeLeadingWhitespace(remainder), 0, 0);
                }
            }
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.flush(true);
            if (!this.inDTD) {
                this.receiver.comment(new CharSlice(ch, start, length), 0, 0);
            }
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    private void flush(boolean compress) throws XPathException {
        if (this.charsUsed > 0) {
            this.slice.setLength(this.charsUsed);
            CharSequence cs = compress ? CompressedWhitespace.compress(this.slice) : this.slice;
            this.receiver.characters(cs, 0, this.escapingDisabled ? 1 : 1024);
            this.charsUsed = 0;
            this.escapingDisabled = false;
        }
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        String uri = systemId;
        if (this.locator != null) {
            try {
                String baseURI;
                URI suppliedURI = new URI(systemId);
                if (!suppliedURI.isAbsolute() && (baseURI = this.locator.getSystemId()) != null) {
                    URI absoluteURI = new URI(baseURI).resolve(systemId);
                    uri = absoluteURI.toString();
                }
            }
            catch (URISyntaxException err) {
                uri = systemId;
            }
        }
        try {
            this.receiver.setUnparsedEntity(name, uri, publicId);
        }
        catch (XPathException err) {
            throw new SAXException(err);
        }
    }

    private class LocalLocator
    implements SourceLocationProvider {
        private LocalLocator() {
        }

        public String getSystemId() {
            return ReceivingContentHandler.this.locator == null ? null : ReceivingContentHandler.this.locator.getSystemId();
        }

        public String getPublicId() {
            return ReceivingContentHandler.this.locator == null ? null : ReceivingContentHandler.this.locator.getPublicId();
        }

        public int getLineNumber() {
            return ReceivingContentHandler.this.locator == null ? -1 : ReceivingContentHandler.this.locator.getLineNumber();
        }

        public int getColumnNumber() {
            return ReceivingContentHandler.this.locator == null ? -1 : ReceivingContentHandler.this.locator.getColumnNumber();
        }

        public int getLineNumber(int locationId) {
            return ReceivingContentHandler.this.locator == null ? -1 : ReceivingContentHandler.this.locator.getLineNumber();
        }

        public int getColumnNumber(int locationId) {
            return ReceivingContentHandler.this.locator == null ? -1 : ReceivingContentHandler.this.locator.getColumnNumber();
        }

        public String getSystemId(int locationId) {
            return ReceivingContentHandler.this.locator == null ? null : ReceivingContentHandler.this.locator.getSystemId();
        }
    }
}

