/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ClassCache;
import java.io.InvalidClassException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.internal.misc.Unsafe;
import jdk.internal.util.ByteArray;
import sun.reflect.ReflectionFactory;

public class ObjectStreamClass
implements Serializable {
    public static final ObjectStreamField[] NO_FIELDS;
    private static final long serialVersionUID = -6120832682080437368L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final ReflectionFactory reflFactory;
    private Class<?> cl;
    private String name;
    private volatile Long suid;
    private boolean isProxy;
    private boolean isEnum;
    private boolean serializable;
    private boolean externalizable;
    private boolean hasWriteObjectData;
    private boolean hasBlockExternalData;
    private ClassNotFoundException resolveEx;
    private ExceptionInfo deserializeEx;
    private ExceptionInfo serializeEx;
    private ExceptionInfo defaultSerializeEx;
    private ObjectStreamField[] fields;
    private int primDataSize;
    private int numObjFields;
    private FieldReflector fieldRefl;
    private volatile ClassDataSlot[] dataLayout;
    private Constructor<?> cons;
    private ProtectionDomain[] domains;
    private Method writeObjectMethod;
    private Method readObjectMethod;
    private Method readObjectNoDataMethod;
    private Method writeReplaceMethod;
    private Method readResolveMethod;
    private ObjectStreamClass localDesc;
    private ObjectStreamClass superDesc;
    private boolean initialized;

    public static ObjectStreamClass lookup(Class<?> clazz) {
        return null;
    }

    public static ObjectStreamClass lookupAny(Class<?> clazz) {
        return null;
    }

    public String getName() {
        return null;
    }

    public long getSerialVersionUID() {
        return 0L;
    }

    public Class<?> forClass() {
        return null;
    }

    public ObjectStreamField[] getFields() {
        return null;
    }

    public ObjectStreamField getField(String string) {
        return null;
    }

    public String toString() {
        return null;
    }

    private static class FieldReflectorKey {
        private final String[] sigs;
        private final int hash;

        FieldReflectorKey(ObjectStreamField[] fields) {
            this.sigs = new String[2 * fields.length];
            int j = 0;
            for (int i = 0; i < fields.length; ++i) {
                ObjectStreamField f = fields[i];
                this.sigs[j++] = f.getName();
                this.sigs[j++] = f.getSignature();
            }
            this.hash = Arrays.hashCode(this.sigs);
        }

        public int hashCode() {
            return this.hash;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof FieldReflectorKey)) return false;
            FieldReflectorKey other = (FieldReflectorKey)obj;
            if (!Arrays.equals(this.sigs, other.sigs)) return false;
            return true;
        }
    }

    private static final class FieldReflector {
        private static final Unsafe UNSAFE = Unsafe.getUnsafe();
        private final ObjectStreamField[] fields;
        private final int numPrimFields;
        private final long[] readKeys;
        private final long[] writeKeys;
        private final int[] offsets;
        private final char[] typeCodes;
        private final Class<?>[] types;

        FieldReflector(ObjectStreamField[] fields) {
            this.fields = fields;
            int nfields = fields.length;
            this.readKeys = new long[nfields];
            this.writeKeys = new long[nfields];
            this.offsets = new int[nfields];
            this.typeCodes = new char[nfields];
            ArrayList typeList = new ArrayList();
            HashSet<Long> usedKeys = new HashSet<Long>();
            for (int i = 0; i < nfields; ++i) {
                long key;
                ObjectStreamField f = fields[i];
                Field rf = f.getField();
                this.readKeys[i] = key = rf != null ? UNSAFE.objectFieldOffset(rf) : -1L;
                this.writeKeys[i] = usedKeys.add(key) ? key : -1L;
                this.offsets[i] = f.getOffset();
                this.typeCodes[i] = f.getTypeCode();
                if (f.isPrimitive()) continue;
                typeList.add(rf != null ? rf.getType() : null);
            }
            this.types = typeList.toArray(new Class[typeList.size()]);
            this.numPrimFields = nfields - this.types.length;
        }

        ObjectStreamField[] getFields() {
            return this.fields;
        }

        void getPrimFieldValues(Object obj, byte[] buf) {
            if (obj == null) {
                throw new NullPointerException();
            }
            block10: for (int i = 0; i < this.numPrimFields; ++i) {
                long key = this.readKeys[i];
                int off = this.offsets[i];
                switch (this.typeCodes[i]) {
                    case 'Z': {
                        ByteArray.setBoolean(buf, off, UNSAFE.getBoolean(obj, key));
                        continue block10;
                    }
                    case 'B': {
                        buf[off] = UNSAFE.getByte(obj, key);
                        continue block10;
                    }
                    case 'C': {
                        ByteArray.setChar(buf, off, UNSAFE.getChar(obj, key));
                        continue block10;
                    }
                    case 'S': {
                        ByteArray.setShort(buf, off, UNSAFE.getShort(obj, key));
                        continue block10;
                    }
                    case 'I': {
                        ByteArray.setInt(buf, off, UNSAFE.getInt(obj, key));
                        continue block10;
                    }
                    case 'F': {
                        ByteArray.setFloat(buf, off, UNSAFE.getFloat(obj, key));
                        continue block10;
                    }
                    case 'J': {
                        ByteArray.setLong(buf, off, UNSAFE.getLong(obj, key));
                        continue block10;
                    }
                    case 'D': {
                        ByteArray.setDouble(buf, off, UNSAFE.getDouble(obj, key));
                        continue block10;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void setPrimFieldValues(Object obj, byte[] buf) {
            if (obj == null) {
                throw new NullPointerException();
            }
            block10: for (int i = 0; i < this.numPrimFields; ++i) {
                long key = this.writeKeys[i];
                if (key == -1L) continue;
                int off = this.offsets[i];
                switch (this.typeCodes[i]) {
                    case 'Z': {
                        UNSAFE.putBoolean(obj, key, ByteArray.getBoolean(buf, off));
                        continue block10;
                    }
                    case 'B': {
                        UNSAFE.putByte(obj, key, buf[off]);
                        continue block10;
                    }
                    case 'C': {
                        UNSAFE.putChar(obj, key, ByteArray.getChar(buf, off));
                        continue block10;
                    }
                    case 'S': {
                        UNSAFE.putShort(obj, key, ByteArray.getShort(buf, off));
                        continue block10;
                    }
                    case 'I': {
                        UNSAFE.putInt(obj, key, ByteArray.getInt(buf, off));
                        continue block10;
                    }
                    case 'F': {
                        UNSAFE.putFloat(obj, key, ByteArray.getFloat(buf, off));
                        continue block10;
                    }
                    case 'J': {
                        UNSAFE.putLong(obj, key, ByteArray.getLong(buf, off));
                        continue block10;
                    }
                    case 'D': {
                        UNSAFE.putDouble(obj, key, ByteArray.getDouble(buf, off));
                        continue block10;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void getObjFieldValues(Object obj, Object[] vals) {
            if (obj == null) {
                throw new NullPointerException();
            }
            for (int i = this.numPrimFields; i < this.fields.length; ++i) {
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
                vals[this.offsets[i]] = UNSAFE.getReference(obj, this.readKeys[i]);
            }
        }

        void checkObjectFieldValueTypes(Object obj, Object[] vals) {
            this.setObjFieldValues(obj, vals, true);
        }

        void setObjFieldValues(Object obj, Object[] vals) {
            this.setObjFieldValues(obj, vals, false);
        }

        private void setObjFieldValues(Object obj, Object[] vals, boolean dryRun) {
            if (obj == null) {
                throw new NullPointerException();
            }
            block3: for (int i = this.numPrimFields; i < this.fields.length; ++i) {
                long key = this.writeKeys[i];
                if (key == -1L) continue;
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        Object val = vals[this.offsets[i]];
                        if (val != null && !this.types[i - this.numPrimFields].isInstance(val)) {
                            Field f = this.fields[i].getField();
                            throw new ClassCastException("cannot assign instance of " + val.getClass().getName() + " to field " + f.getDeclaringClass().getName() + "." + f.getName() + " of type " + f.getType().getName() + " in instance of " + obj.getClass().getName());
                        }
                        if (dryRun) continue block3;
                        UNSAFE.putReference(obj, key, val);
                        continue block3;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }
    }

    private static final class MemberSignature {
        public final Member member;
        public final String name;
        public final String signature;

        public MemberSignature(Field field) {
            this.member = field;
            this.name = field.getName();
            this.signature = field.getType().descriptorString();
        }

        public MemberSignature(Constructor<?> cons) {
            this.member = cons;
            this.name = cons.getName();
            this.signature = ObjectStreamClass.getMethodSignature((Class[])cons.getParameterTypes(), Void.TYPE);
        }

        public MemberSignature(Method meth) {
            this.member = meth;
            this.name = meth.getName();
            this.signature = ObjectStreamClass.getMethodSignature((Class[])meth.getParameterTypes(), meth.getReturnType());
        }
    }

    static class ClassDataSlot {
        final ObjectStreamClass desc;
        final boolean hasData;

        ClassDataSlot(ObjectStreamClass desc, boolean hasData) {
            this.desc = desc;
            this.hasData = hasData;
        }
    }

    private static class ExceptionInfo {
        private final String className;
        private final String message;

        ExceptionInfo(String cn, String msg) {
            this.className = cn;
            this.message = msg;
        }

        InvalidClassException newInvalidClassException() {
            return new InvalidClassException(this.className, this.message);
        }
    }

    private static class Caches {
        static final ClassCache<ObjectStreamClass> localDescs = new ClassCache<ObjectStreamClass>(){

            @Override
            protected ObjectStreamClass computeValue(Class<?> type) {
                return new ObjectStreamClass(type);
            }
        };
        static final ClassCache<Map<FieldReflectorKey, FieldReflector>> reflectors = new ClassCache<Map<FieldReflectorKey, FieldReflector>>(){

            @Override
            protected Map<FieldReflectorKey, FieldReflector> computeValue(Class<?> type) {
                return new ConcurrentHashMap<FieldReflectorKey, FieldReflector>();
            }
        };

        private Caches() {
        }
    }
}

