#ifndef ELF32_H
#define ELF32_H


#define EI_NIDENT 16
typedef struct {
	unsigned char	e_ident[EI_NIDENT];	/* ident bytes */
	unsigned short	e_type;			/* file type */
	unsigned short	e_machine;		/* target machine */
	unsigned int	e_version;		/* file version */
	unsigned int	e_entry;		/* start address */
	unsigned int	e_phoff;		/* phdr file offset */
	unsigned int	e_shoff;		/* shdr file offset */
	unsigned int	e_flags;		/* file flags */
	unsigned short	e_ehsize;		/* sizeof ehdr */
	unsigned short	e_phentsize;		/* sizeof phdr */
	unsigned short	e_phnum;		/* number phdrs */
	unsigned short	e_shentsize;		/* sizeof shdr */
	unsigned short	e_shnum;		/* number shdrs */
	unsigned short	e_shstrndx;		/* shdr string index */
} Elf32_Ehdr;

#define swap_Ehdr(x)			\
	swap16(&((x)->e_type));		\
	swap16(&((x)->e_machine));	\
	swap32(&((x)->e_version));	\
	swap32(&((x)->e_entry));	\
	swap32(&((x)->e_phoff));	\
	swap32(&((x)->e_shoff));	\
	swap32(&((x)->e_flags));	\
	swap16(&((x)->e_ehsize));	\
	swap16(&((x)->e_phentsize));	\
	swap16(&((x)->e_phnum));	\
	swap16(&((x)->e_shentsize));	\
	swap16(&((x)->e_shnum));	\
	swap16(&((x)->e_shstrndx));


/* sh_type */
#define SHT_NULL	0
#define SHT_PROGBITS	1
#define SHT_SYMTAB	2
#define SHT_STRTAB	3
#define SHT_RELA	4
#define SHT_HASH	5
#define SHT_DYNAMIC	6
#define SHT_NOTE	7
#define SHT_NOBITS	8
#define SHT_REL		9
#define SHT_SHLIB	10
#define SHT_DYNSYM	11
#define SHT_LOPROC	0x70000000
#define SHT_REGINFO	0x70000006

/* sh_flags */
#define SHF_WRITE	0x1
#define SHF_ALLOC	0x2
#define SHF_EXECINSTR	0x4

typedef struct {
	unsigned int	sh_name;	/* section name */
	unsigned int	sh_type;	/* SHT_... */
	unsigned int	sh_flags;	/* SHF_... */
	unsigned int	sh_addr;	/* virtual address */
	unsigned int	sh_offset;	/* file offset */
	unsigned int	sh_size;	/* section size */
	unsigned int	sh_link;	/* misc info */
	unsigned int	sh_info;	/* misc info */
	unsigned int	sh_addralign;	/* memory alignment */
	unsigned int	sh_entsize;	/* entry size if table */
} Elf32_Shdr;

#define swap_Shdr(x)			\
	swap32(&((x)->sh_name));	\
	swap32(&((x)->sh_type));	\
	swap32(&((x)->sh_flags));	\
	swap32(&((x)->sh_addr));	\
	swap32(&((x)->sh_offset));	\
	swap32(&((x)->sh_size));	\
	swap32(&((x)->sh_link));	\
	swap32(&((x)->sh_info));	\
	swap32(&((x)->sh_addralign));	\
	swap32(&((x)->sh_entsize));


#define SHN_UNDEF	0x0000
#define SHN_LORESERVE	0xFF00
#define SHN_ABS		0xFFF1

#define STT_MASK	0x0F
#define STT_NOTYPE	0x00
#define STT_OBJECT	0x01
#define STT_FUNCTION	0x02
#define STT_SECTION	0x03
#define STT_FILE	0x04

typedef struct {
	unsigned int	st_name;
	unsigned int	st_value;
	unsigned int	st_size;
	unsigned char	st_info;	/* bind, type: ELF_32_ST_... */
	unsigned char	st_other;
	unsigned short	st_shndx;	/* SHN_... */
} Elf32_Sym;

#define swap_Sym(x)			\
	swap32(&((x)->st_name));	\
	swap32(&((x)->st_value));	\
	swap32(&((x)->st_size));	\
	swap16(&((x)->st_shndx));


#define R_MIPS_NONE		0
#define R_MIPS_16		1
#define R_MIPS_32		2
#define R_MIPS_ADD		R_MIPS_32
#define R_MIPS_REL		3
#define R_MIPS_REL32		R_MIPS_REL
#define R_MIPS_26		4
#define R_MIPS_HI16		5
#define R_MIPS_LO16		6
#define R_MIPS_GPREL		7
#define R_MIPS_GPREL16		R_MIPS_GPREL
#define R_MIPS_LITERAL		8
#define R_MIPS_GOT		9
#define R_MIPS_GOT16		R_MIPS_GOT
#define R_MIPS_PC16		10
#define R_MIPS_CALL		11
#define R_MIPS_CALL16		R_MIPS_CALL
#define R_MIPS_GPREL32		12

#define R_MIPS_SHIFT5		16
#define R_MIPS_SHIFT6		17
#define R_MIPS_64		18
#define R_MIPS_GOT_DISP		19
#define R_MIPS_GOT_PAGE		20
#define R_MIPS_GOT_OFST		21
#define R_MIPS_GOT_HI16		22
#define R_MIPS_GOT_LO16		23
#define R_MIPS_SUB		24
#define R_MIPS_INSERT_A		25
#define R_MIPS_INSERT_B		26
#define R_MIPS_DELETE		27
#define R_MIPS_HIGHER		28
#define R_MIPS_HIGHEST		29
#define R_MIPS_CALL_HI16	30
#define R_MIPS_CALL_LO16	31
#define R_MIPS_SCN_DISP		32
#define	R_MIPS_REL16		33
#define R_MIPS_ADD_IMMEDIATE	34
#define R_MIPS_PJUMP		35
#define R_MIPS_RELGOT		36
#define R_MIPS_JALR		37

typedef struct {
	unsigned int	r_offset;
	unsigned int	r_info;		/* sym, type: ELF32_R_... */
} Elf32_Rel;

#define swap_Rel(x)			\
	swap32(&((x)->r_offset));	\
	swap32(&((x)->r_info));

typedef struct {
	unsigned int	r_offset;
	unsigned int	r_info;		/* sym, type: ELF32_R_... */
	int		r_addend;
} Elf32_Rela;

#define swap_Rela(x)			\
	swap32(&((x)->r_offset));	\
	swap32(&((x)->r_info));		\
	swap32(&((x)->r_addend));


#define ELF32_R_SYM(info)	((info) >> 8)
#define ELF32_R_TYPE(info)	((unsigned char)(info))
typedef struct
{
	unsigned int	ri_gprmask;
	unsigned int	ri_cprmask[4];
	int		ri_gp_value;
} Elf32_RegInfo;

#define swap_RegInfo(x)			\
	swap32(&((x)->ri_gprmask));	\
	swap32(&((x)->ri_cprmask[0]));	\
	swap32(&((x)->ri_cprmask[1]));	\
	swap32(&((x)->ri_cprmask[2]));	\
	swap32(&((x)->ri_cprmask[3]));	\
	swap32(&((x)->ri_gp_value));


#endif /* ELF32_H */
