/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.graph;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import net.gcalc.calc.main.HackHack;
import net.gcalc.calc.models.ModelList;
import net.gcalc.calc.models.RenderableModel;
import net.gcalc.plugin.plane.graph.DrawingThread;

public abstract class LayeredDrawingThread
extends DrawingThread {
    protected ModelList modelList;
    protected int modelIdx = 0;
    protected int modelIdxMax = 1;

    protected LayeredDrawingThread(Component parent, Graphics g, ModelList m) {
        super(parent, g, "Rendering in progress...");
        this.modelList = m;
    }

    public void run() {
        BufferedImage image = null;
        Object[] notDrawnModel = this.modelList.getNotDrawnModels();
        this.modelIdxMax = notDrawnModel.length;
        this.progressMonitor.setMaximum(notDrawnModel.length * 100);
        this.progressMonitor.setMinimum(0);
        int i = 0;
        while (i < notDrawnModel.length) {
            RenderableModel model = (RenderableModel)notDrawnModel[i];
            image = model.getImage();
            this.modelIdx = i;
            if (image == null) {
                image = new BufferedImage(this.parent.getWidth(), this.parent.getHeight(), 2);
                this.render(i, image.getGraphics(), model);
            }
            if (!this.isDead()) {
                this.graphics.drawImage(image, 0, 0, null);
                model.setDrawn(true);
                model.setImage(image);
                model.setThumbnailImage(HackHack.generateThumbnailImage(image, 40, 40));
            }
            if (this.isDead()) break;
            ++i;
        }
        this.progressMonitor.close();
        this.finishRun();
        this.modelList.poke();
    }

    protected abstract void finishRun();

    protected abstract void render(int var1, Graphics var2, RenderableModel var3);
}

