/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane;

import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.BadSyntaxException;
import net.gcalc.plugin.gui.InputPanel;
import net.gcalc.plugin.gui.TextInputPanel;
import net.gcalc.plugin.plane.CartesianGraphPlugin;
import net.gcalc.plugin.plane.graph.ImplicitFunctionGraph;
import net.gcalc.plugin.plane.gui.FlagPanel;

public class ImplicitFunctionPlugin
extends CartesianGraphPlugin {
    public ImplicitFunctionPlugin() {
        this.graph = new ImplicitFunctionGraph(this);
    }

    protected JPanel makeFlagPanel() {
        return new FlagPanel(this.graph.getProperties());
    }

    protected InputPanel getInputPanel() {
        return new TextInputPanel("Function", this.getModelLabels(), null);
    }

    public String getDescription() {
        return "<p>Graphs the zero set of functions of x and y.  </p><p>The <i>zero set</i> of a function f(x,y) is the set of points where f(x,y)=0.</p>";
    }

    public String getPluginName() {
        return "Implicit Function Plugin";
    }

    protected String[] getModelLabels() {
        return new String[]{"f(x,y)="};
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.ip) {
            String s = this.ip.getValues()[0].trim();
            Function f = null;
            try {
                f = FunctionFactory.getFunction(s);
            }
            catch (BadSyntaxException e) {
                this.popupMessageDialog("Bad Syntax in '" + s + "'!\n" + e.getMessage(), 0);
                return;
            }
            if (f != null) {
                this.drawGraph(f, s);
                this.statusBar.setText("Graphing: " + s);
            }
        }
    }
}

