%define name xlogical
%define version 1.0
%define release 7

Summary: parallel thinking puzzle game with ray traced graphics, music, sound
Name: %{name}
Version: %{version}
Release: %{release}
Source: http://changeling.dynip.com/xlogical/downloads/%{name}-%{version}-%{release}.tar.gz
URL: http://changeling.dynip.com/xlogical/
Group: X11/Games/Video
Buildroot: %{_tmppath}/%{name}-buildroot
License: GPL

%description
This is a puzzle game based on a game by Rainbow Arts called "Logical!" which
was released on the Commodore Amiga in the 1980's.  It requires parallel
thinking and quick reflexes.

%prep
rm -rf $RPM_BUILD_ROOT
%setup -q

%build
%configure
%make

%install
%makeinstall

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,bin,games)
%doc README COPYING ChangeLog AUTHORS NEWS TODO LICENSE
%{_bindir}/xlogical
%{_datadir}/xlogical/images/arrow_d.bmp
%{_datadir}/xlogical/images/arrow_l.bmp
%{_datadir}/xlogical/images/arrow_r.bmp
%{_datadir}/xlogical/images/arrow_u.bmp
%{_datadir}/xlogical/images/background_complete.bmp
%{_datadir}/xlogical/images/background_game.bmp
%{_datadir}/xlogical/images/background_gameover.bmp
%{_datadir}/xlogical/images/background_hiscore.bmp
%{_datadir}/xlogical/images/background_start.bmp
%{_datadir}/xlogical/images/background_time.bmp
%{_datadir}/xlogical/images/background_won.bmp
%{_datadir}/xlogical/images/ball_c1.bmp
%{_datadir}/xlogical/images/ball_c2.bmp
%{_datadir}/xlogical/images/ball_c3.bmp
%{_datadir}/xlogical/images/ball_c4.bmp
%{_datadir}/xlogical/images/ballmove3_0.bmp
%{_datadir}/xlogical/images/ballmove3_1.bmp
%{_datadir}/xlogical/images/ballmove3_2.bmp
%{_datadir}/xlogical/images/ballmove3_3.bmp
%{_datadir}/xlogical/images/ballmove4_0.bmp
%{_datadir}/xlogical/images/ballmove4_1.bmp
%{_datadir}/xlogical/images/ballmove4_2.bmp
%{_datadir}/xlogical/images/ballmove4_3.bmp
%{_datadir}/xlogical/images/ballmove4_4.bmp
%{_datadir}/xlogical/images/ballmove5_0.bmp
%{_datadir}/xlogical/images/ballmove5_1.bmp
%{_datadir}/xlogical/images/ballmove5_2.bmp
%{_datadir}/xlogical/images/ballmove5_3.bmp
%{_datadir}/xlogical/images/ballmove5_4.bmp
%{_datadir}/xlogical/images/ballmove5_5.bmp
%{_datadir}/xlogical/images/block_base.bmp
%{_datadir}/xlogical/images/cover_center.bmp
%{_datadir}/xlogical/images/cover_d.bmp
%{_datadir}/xlogical/images/cover_l.bmp
%{_datadir}/xlogical/images/cover_lr.bmp
%{_datadir}/xlogical/images/cover_r.bmp
%{_datadir}/xlogical/images/cover_u.bmp
%{_datadir}/xlogical/images/cover_ud.bmp
%{_datadir}/xlogical/images/finish_1.bmp
%{_datadir}/xlogical/images/finish_2.bmp
%{_datadir}/xlogical/images/finish_3.bmp
%{_datadir}/xlogical/images/finish_4.bmp
%{_datadir}/xlogical/images/font_1.bmp
%{_datadir}/xlogical/images/font_2.bmp
%{_datadir}/xlogical/images/font_3.bmp
%{_datadir}/xlogical/images/font_4.bmp
%{_datadir}/xlogical/images/gem_c1.bmp
%{_datadir}/xlogical/images/gem_c2.bmp
%{_datadir}/xlogical/images/gem_c3.bmp
%{_datadir}/xlogical/images/gem_c4.bmp
%{_datadir}/xlogical/images/next_base.bmp
%{_datadir}/xlogical/images/numbers.bmp
%{_datadir}/xlogical/images/order_disp.bmp
%{_datadir}/xlogical/images/paint_base.bmp
%{_datadir}/xlogical/images/pattern_disp.bmp
%{_datadir}/xlogical/images/scrollblock.bmp
%{_datadir}/xlogical/images/sel_back_1.bmp
%{_datadir}/xlogical/images/sel_back_2.bmp
%{_datadir}/xlogical/images/sel_back_3.bmp
%{_datadir}/xlogical/images/sel_back_4.bmp
%{_datadir}/xlogical/images/slider.bmp
%{_datadir}/xlogical/images/slider_thumb.bmp
%{_datadir}/xlogical/images/spin_0.bmp
%{_datadir}/xlogical/images/spin_1.bmp
%{_datadir}/xlogical/images/spin_2.bmp
%{_datadir}/xlogical/images/spincover_0.bmp
%{_datadir}/xlogical/images/spincover_1.bmp
%{_datadir}/xlogical/images/spincover_2.bmp
%{_datadir}/xlogical/images/spincoverred_0.bmp
%{_datadir}/xlogical/images/spincoverred_1.bmp
%{_datadir}/xlogical/images/spincoverred_2.bmp
%{_datadir}/xlogical/images/spindark.bmp
%{_datadir}/xlogical/images/spinred_0.bmp
%{_datadir}/xlogical/images/spinred_1.bmp
%{_datadir}/xlogical/images/spinred_2.bmp
%{_datadir}/xlogical/images/spinring.bmp
%{_datadir}/xlogical/images/spinring_d.bmp
%{_datadir}/xlogical/images/spinring_l.bmp
%{_datadir}/xlogical/images/spinring_r.bmp
%{_datadir}/xlogical/images/spinring_u.bmp
%{_datadir}/xlogical/images/spintopoff.bmp
%{_datadir}/xlogical/images/spintopon.bmp
%{_datadir}/xlogical/images/start_c.bmp
%{_datadir}/xlogical/images/start_d.bmp
%{_datadir}/xlogical/images/start_l.bmp
%{_datadir}/xlogical/images/start_r.bmp
%{_datadir}/xlogical/images/starttimer_00.bmp
%{_datadir}/xlogical/images/starttimer_01.bmp
%{_datadir}/xlogical/images/starttimer_02.bmp
%{_datadir}/xlogical/images/starttimer_03.bmp
%{_datadir}/xlogical/images/starttimer_04.bmp
%{_datadir}/xlogical/images/starttimer_05.bmp
%{_datadir}/xlogical/images/starttimer_06.bmp
%{_datadir}/xlogical/images/starttimer_07.bmp
%{_datadir}/xlogical/images/starttimer_08.bmp
%{_datadir}/xlogical/images/starttimer_09.bmp
%{_datadir}/xlogical/images/starttimer_10.bmp
%{_datadir}/xlogical/images/starttimer_11.bmp
%{_datadir}/xlogical/images/starttimer_12.bmp
%{_datadir}/xlogical/images/starttimer_13.bmp
%{_datadir}/xlogical/images/starttimer_14.bmp
%{_datadir}/xlogical/images/starttimer_15.bmp
%{_datadir}/xlogical/images/starttimer_16.bmp
%{_datadir}/xlogical/images/starttimer_17.bmp
%{_datadir}/xlogical/images/starttimer_18.bmp
%{_datadir}/xlogical/images/starttimer_19.bmp
%{_datadir}/xlogical/images/starttimer_20.bmp
%{_datadir}/xlogical/images/start_u.bmp
%{_datadir}/xlogical/images/teleport_base.bmp
%{_datadir}/xlogical/images/teleport_lr.bmp
%{_datadir}/xlogical/images/teleport_ud.bmp
%{_datadir}/xlogical/images/timer.bmp
%{_datadir}/xlogical/images/title_text_1.bmp
%{_datadir}/xlogical/images/title_text_2.bmp
%{_datadir}/xlogical/images/title_text_3.bmp
%{_datadir}/xlogical/images/title_text_4.jpg
%{_datadir}/xlogical/images/track_d.bmp
%{_datadir}/xlogical/images/track_dl.bmp
%{_datadir}/xlogical/images/track_dlr.bmp
%{_datadir}/xlogical/images/track_dr.bmp
%{_datadir}/xlogical/images/track_l.bmp
%{_datadir}/xlogical/images/track_lr.bmp
%{_datadir}/xlogical/images/track_r.bmp
%{_datadir}/xlogical/images/track_u.bmp
%{_datadir}/xlogical/images/track_ud.bmp
%{_datadir}/xlogical/images/track_udl.bmp
%{_datadir}/xlogical/images/track_udlr.bmp
%{_datadir}/xlogical/images/track_udr.bmp
%{_datadir}/xlogical/images/track_ul.bmp
%{_datadir}/xlogical/images/track_ulr.bmp
%{_datadir}/xlogical/images/track_ur.bmp
%{_datadir}/xlogical/music/endgame.mod
%{_datadir}/xlogical/music/highscore.mod
%{_datadir}/xlogical/music/ingame.mod
%{_datadir}/xlogical/music/intro.mod
%{_datadir}/xlogical/music/pregame.mod
%{_datadir}/xlogical/music/wongame.mod
%{_datadir}/xlogical/sound/block_ball.wav
%{_datadir}/xlogical/sound/bonus_life.wav
%{_datadir}/xlogical/sound/catch_ball.wav
%{_datadir}/xlogical/sound/eject_ball.wav
%{_datadir}/xlogical/sound/finish_level.wav
%{_datadir}/xlogical/sound/finish_spinner.wav
%{_datadir}/xlogical/sound/menu_click.wav
%{_datadir}/xlogical/sound/new_ball.wav
%{_datadir}/xlogical/sound/new_pattern.wav
%{_datadir}/xlogical/sound/one_way.wav
%{_datadir}/xlogical/sound/paint_ball.wav
%{_datadir}/xlogical/sound/spinner_click.wav
%{_datadir}/xlogical/sound/teleport.wav
%{_datadir}/xlogical/sound/time_warning.wav
%{_datadir}/xlogical/xlogical.levels
%{_datadir}/xlogical/xlogical.properties
%{_localstatedir}/xlogical/xlogical.scores

%changelog
* Tue Jul 31 2001 Tom Warkentin <tom@changeling.dynip.com>
- prepared xlogical-1.0-7 release
- fixed ball lost in tunnel bug
  (reported by Kevin Turner <acapnotic@users.sourceforge.net>)
- abstracted system time calls to Cgraph class to be more portable and did
  some general code cleanup.  This should help FreeBSD builds.
  (reported by <wazm@rm-f.net>)
- fixed fullscreen flickering problem with the Win32 port
- updated Visual C++ project files to SDL-1.2.2

* Sat Mar 17 2001 Tom Warkentin <tom@changeling.dynip.com>
- ported the code to Win32 using Visual C++ 6.0sp5
- added a new splash screen courtesy of Sloane.
- rewrote some of the code to fix inconsistencies between Linux and Win32
  versions of SDL.
- fixed up some intermittent bugs with the middle of tile checks where blocker
  tiles sometimes missed a ball, painter tils sometimes missed, etc..
- added ability for user to type in name instead of using user's login name.
  This was to make it more consistent with the Win32 port.
- removed samples and music files from properties file to be more consistent
  with the way images are hangled by xlogical.  The data filenames are all
  compiled directly into the executable now.

* Wed Dec 27 2000 Tom Warkentin <tom@changeling.dynip.com>
- changed install so that owner is user 'bin' and group 'games' instead of
  root (reported by <mac@dgp.toronto.edu>)
- added SDL cleanup code so that X desktop resolution is restored if playing
  in fullscreen mode (reported by <gjohnson@totalsports.net>)
- implemented video mode switching on the fly

* Sat Nov 18 2000 Tom Warkentin <tom@changeling.dynip.com>
- fixed infinite loop when calculating time bonus after finishing "DIMLIGHTS"
  level
  (reported by <wuff@writeme.com>
- fixed disappearing ball bug when balls were bouncing back and forth between
  full spinners
  (reported by <wuff@writeme.com>
- fixed compiler errors/warnings from RedHat 7.0 C++ compiler
  (reported by <Nat.Pryce@quokka.com>)
- implemented and tested 'make uninstall'
  (reported by <Nat.Pryce@quokka.com>)
- changed install target to install data files into ${prefix}/share/xlogical
  (reported by <Nat.Pryce@quokka.com>)
- changed install target to install high score file into
  ${localstatedir}/var/xlogical
  (reported by <Nat.Pryce@quokka.com>)

* Fri Oct 13 2000 Tom Warkentin <tom@changeling.dynip.com>
- added usage information if invalid command line arguments are supplied
  (reported by <Daniel_Burrows@brown.edu>)
- fixed core dump when no module info is available (only shows up with audio
  disabled)
  (reported by <Daniel_Burrows@brown.edu>)
- changed generation of xlogical.properties file to be a build dependency
  instead of an install dependency.  "make install prefix=/usr/foobar" will
  not modify any configuration files now - they are all generated as needed
  during the build.
  (reported by <Daniel_Burrows@brown.edu>)

* Mon Oct 9 2000 Tom Warkentin <tom@changeling.dynip.com>
- fixed a large memory leak in graphics routines that were called constantly
- fix is in xlogical-1.0-2

* Sat Oct 7 2000 Tom Warkentin <tom@changeling.dynip.com>
- initial release

