/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.io.File;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.inspector.RrdNode;

class MainTreeModel
extends DefaultTreeModel {
    private static final DefaultMutableTreeNode INVALID_NODE = new DefaultMutableTreeNode("No valid RRD file specified");
    private File file;

    MainTreeModel() {
        super(INVALID_NODE);
    }

    boolean setFile(File file) {
        try {
            this.file = file;
            RrdDb rrdDb = new RrdDb(this.file.getAbsolutePath());
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new RrdNode(rrdDb));
            int n = rrdDb.getRrdDef().getDsCount();
            int n2 = rrdDb.getRrdDef().getArcCount();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new RrdNode(rrdDb, i));
                for (int j = 0; j < n2; ++j) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new RrdNode(rrdDb, i, j));
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
            rrdDb.close();
            this.setRoot(defaultMutableTreeNode);
            return true;
        }
        catch (IOException iOException) {
            this.setRoot(INVALID_NODE);
        }
        catch (RrdException rrdException) {
            this.setRoot(INVALID_NODE);
        }
        return false;
    }
}

