/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.client;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.xmlrpc.XmlRpcException;
import org.jrobin.mrtg.client.LinkInfo;
import org.jrobin.mrtg.client.RouterInfo;
import org.jrobin.mrtg.client.RpcClient;
import org.jrobin.mrtg.client.ServerInfo;

class MrtgData {
    private static MrtgData instance;
    private Vector hardwareInfo = new Vector();
    private Hashtable serverInfo = new Hashtable();
    private String mrtgHost;
    private RpcClient client;

    static synchronized MrtgData getInstance() {
        if (instance == null) {
            instance = new MrtgData();
        }
        return instance;
    }

    private MrtgData() {
    }

    void setHost(String string) throws IOException, XmlRpcException {
        this.mrtgHost = string;
        this.reload();
    }

    void reload() throws IOException, XmlRpcException {
        this.client = new RpcClient(this.mrtgHost);
        Hashtable hashtable = this.client.getMrtgInfo();
        this.serverInfo = (Hashtable)hashtable.get("serverInfo");
        this.hardwareInfo = (Vector)hashtable.get("routers");
    }

    String getMrtgHost() {
        return this.mrtgHost;
    }

    int getRouterCount() {
        return this.hardwareInfo.size();
    }

    String getRouterHost(int n) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        return (String)hashtable.get("host");
    }

    String getRouterDescr(int n) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        return (String)hashtable.get("descr");
    }

    String getRouterCommunity(int n) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        return (String)hashtable.get("community");
    }

    boolean getRouterActive(int n) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        Boolean bl = (Boolean)hashtable.get("active");
        return bl;
    }

    int getLinkCount(int n) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        Vector vector = (Vector)hashtable.get("links");
        return vector.size();
    }

    String getLinkIfDescr(int n, int n2) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        Vector vector = (Vector)hashtable.get("links");
        Hashtable hashtable2 = (Hashtable)vector.get(n2);
        return (String)hashtable2.get("ifDescr");
    }

    String getLinkIfAlias(int n, int n2) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        Vector vector = (Vector)hashtable.get("links");
        Hashtable hashtable2 = (Hashtable)vector.get(n2);
        return (String)hashtable2.get("ifAlias");
    }

    String getLinkDescr(int n, int n2) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        Vector vector = (Vector)hashtable.get("links");
        Hashtable hashtable2 = (Hashtable)vector.get(n2);
        return (String)hashtable2.get("descr");
    }

    int getLinkIfIndex(int n, int n2) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        Vector vector = (Vector)hashtable.get("links");
        Hashtable hashtable2 = (Hashtable)vector.get(n2);
        return (Integer)hashtable2.get("ifIndex");
    }

    int getLinkSamplingInterval(int n, int n2) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        Vector vector = (Vector)hashtable.get("links");
        Hashtable hashtable2 = (Hashtable)vector.get(n2);
        return (Integer)hashtable2.get("samplingInterval");
    }

    boolean getLinkActive(int n, int n2) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        Vector vector = (Vector)hashtable.get("links");
        Hashtable hashtable2 = (Hashtable)vector.get(n2);
        return (Boolean)hashtable2.get("active");
    }

    Date getLinkLastSampleTime(int n, int n2) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        Vector vector = (Vector)hashtable.get("links");
        Hashtable hashtable2 = (Hashtable)vector.get(n2);
        return (Date)hashtable2.get("lastSampleTime");
    }

    long getLinkIfInOctets(int n, int n2) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        Vector vector = (Vector)hashtable.get("links");
        Hashtable hashtable2 = (Hashtable)vector.get(n2);
        String string = (String)hashtable2.get("ifInOctets");
        return string != null ? Long.parseLong(string) : 0L;
    }

    long getLinkIfOutOctets(int n, int n2) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        Vector vector = (Vector)hashtable.get("links");
        Hashtable hashtable2 = (Hashtable)vector.get(n2);
        String string = (String)hashtable2.get("ifOutOctets");
        return string != null ? Long.parseLong(string) : 0L;
    }

    int getLinkSampleCount(int n, int n2) {
        Hashtable hashtable = (Hashtable)this.hardwareInfo.get(n);
        Vector vector = (Vector)hashtable.get("links");
        Hashtable hashtable2 = (Hashtable)vector.get(n2);
        Integer n3 = (Integer)hashtable2.get("sampleCount");
        return n3;
    }

    RouterInfo getRouterInfo(int n) {
        RouterInfo routerInfo = new RouterInfo();
        routerInfo.setActive(this.getRouterActive(n));
        routerInfo.setCommunity(this.getRouterCommunity(n));
        routerInfo.setDescr(this.getRouterDescr(n));
        routerInfo.setHost(this.getRouterHost(n));
        Vector<LinkInfo> vector = new Vector<LinkInfo>();
        for (int i = 0; i < this.getLinkCount(n); ++i) {
            vector.add(this.getLinkInfo(n, i));
        }
        Collections.sort(vector, LinkInfo.getComparator());
        routerInfo.setLinkInfo(vector.toArray(new LinkInfo[0]));
        return routerInfo;
    }

    LinkInfo getLinkInfo(int n, int n2) {
        LinkInfo linkInfo = new LinkInfo();
        linkInfo.setActive(this.getLinkActive(n, n2));
        linkInfo.setIfDescr(this.getLinkIfDescr(n, n2));
        linkInfo.setDescr(this.getLinkDescr(n, n2));
        linkInfo.setIfAlias(this.getLinkIfAlias(n, n2));
        linkInfo.setIfIndex(this.getLinkIfIndex(n, n2));
        linkInfo.setIfInOctets(this.getLinkIfInOctets(n, n2));
        linkInfo.setIfOutOctets(this.getLinkIfOutOctets(n, n2));
        linkInfo.setLastSampleTime(this.getLinkLastSampleTime(n, n2));
        linkInfo.setSamplingInterval(this.getLinkSamplingInterval(n, n2));
        linkInfo.setSampleCount(this.getLinkSampleCount(n, n2));
        return linkInfo;
    }

    RouterInfo[] getInfo() {
        Vector<RouterInfo> vector = new Vector<RouterInfo>();
        for (int i = 0; i < this.getRouterCount(); ++i) {
            vector.add(this.getRouterInfo(i));
        }
        Collections.sort(vector, RouterInfo.getComparator());
        return vector.toArray(new RouterInfo[0]);
    }

    ServerInfo getServerInfo() {
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.setServerHost(this.mrtgHost);
        serverInfo.setBadSavesCount(Integer.parseInt(this.serverInfo.get("badSavesCount").toString()));
        serverInfo.setGoodSavesCount(Integer.parseInt(this.serverInfo.get("goodSavesCount").toString()));
        serverInfo.setSavesCount(Integer.parseInt(this.serverInfo.get("savesCount").toString()));
        serverInfo.setSampleCount(Integer.parseInt(this.serverInfo.get("sampleCount").toString()));
        serverInfo.setPoolEfficency(Double.parseDouble(this.serverInfo.get("poolEfficency").toString()));
        serverInfo.setStartDate((Date)this.serverInfo.get("startDate"));
        return serverInfo;
    }

    int addRouter(RouterInfo routerInfo) throws XmlRpcException, IOException {
        int n = this.client.addRouter(routerInfo);
        this.reload();
        return n;
    }

    int updateRouter(RouterInfo routerInfo) throws XmlRpcException, IOException {
        int n = this.client.updateRouter(routerInfo);
        this.reload();
        return n;
    }

    int deleteRouter(RouterInfo routerInfo) throws XmlRpcException, IOException {
        int n = this.client.deleteRouter(routerInfo);
        this.reload();
        return n;
    }

    String[] getAvailableLinks(RouterInfo routerInfo) throws IOException, XmlRpcException {
        Vector vector = this.client.getAvailableLinks(routerInfo);
        Collections.sort(vector);
        return vector.toArray(new String[0]);
    }

    int addLink(RouterInfo routerInfo, LinkInfo linkInfo) throws XmlRpcException, IOException {
        int n = this.client.addLink(routerInfo, linkInfo);
        this.reload();
        return n;
    }

    int updateLink(RouterInfo routerInfo, LinkInfo linkInfo) throws XmlRpcException, IOException {
        int n = this.client.updateLink(routerInfo, linkInfo);
        this.reload();
        return n;
    }

    int removeLink(RouterInfo routerInfo, LinkInfo linkInfo) throws XmlRpcException, IOException {
        int n = this.client.removeLink(routerInfo, linkInfo);
        this.reload();
        return n;
    }

    byte[] getPngGraph(RouterInfo routerInfo, LinkInfo linkInfo, Date date, Date date2) throws IOException, XmlRpcException {
        return this.client.getPngGraph(routerInfo, linkInfo, date, date2);
    }

    TreeModel getTreeModel() {
        ServerInfo serverInfo = this.getServerInfo();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(serverInfo);
        RouterInfo[] routerInfoArray = this.getInfo();
        for (int i = 0; i < routerInfoArray.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(routerInfoArray[i]);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            LinkInfo[] linkInfoArray = routerInfoArray[i].getLinkInfo();
            for (int j = 0; j < linkInfoArray.length; ++j) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(linkInfoArray[j]);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
        }
        return new DefaultTreeModel(defaultMutableTreeNode);
    }
}

