/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import snmp.SNMPBERCodec;
import snmp.SNMPBadValueException;
import snmp.SNMPObject;

public class SNMPInteger
extends SNMPObject {
    protected BigInteger value;
    protected byte tag = (byte)2;

    public SNMPInteger() {
        this(0L);
    }

    public SNMPInteger(long l) {
        this.value = new BigInteger(new Long(l).toString());
    }

    protected SNMPInteger(byte[] byArray) throws SNMPBadValueException {
        this.extractValueFromBEREncoding(byArray);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) throws SNMPBadValueException {
        if (object instanceof BigInteger) {
            this.value = (BigInteger)object;
        } else if (object instanceof Integer) {
            this.value = new BigInteger(((Integer)object).toString());
        } else if (object instanceof String) {
            this.value = new BigInteger((String)object);
        } else {
            throw new SNMPBadValueException(" Integer: bad object supplied to set value ");
        }
    }

    protected byte[] getBEREncoding() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = this.value.toByteArray();
        byte[] byArray2 = SNMPBERCodec.encodeLength(byArray.length);
        byteArrayOutputStream.write(this.tag);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        return byteArrayOutputStream.toByteArray();
    }

    public void extractValueFromBEREncoding(byte[] byArray) throws SNMPBadValueException {
        try {
            this.value = new BigInteger(byArray);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SNMPBadValueException(" Integer: bad BER encoding supplied to set value ");
        }
    }

    public String toString() {
        return this.value.toString();
    }
}

