// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcesettings/v1/resource_settings.proto

#include "google/cloud/resourcesettings/v1/internal/resource_settings_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/resourcesettings/v1/resource_settings.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace resourcesettings_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ResourceSettingsServiceLogging::ResourceSettingsServiceLogging(
    std::shared_ptr<ResourceSettingsServiceStub> child,
    TracingOptions tracing_options, std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::cloud::resourcesettings::v1::ListSettingsResponse>
ResourceSettingsServiceLogging::ListSettings(
    grpc::ClientContext& context,
    google::cloud::resourcesettings::v1::ListSettingsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::resourcesettings::v1::ListSettingsRequest const&
                 request) { return child_->ListSettings(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::resourcesettings::v1::Setting>
ResourceSettingsServiceLogging::GetSetting(
    grpc::ClientContext& context,
    google::cloud::resourcesettings::v1::GetSettingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::resourcesettings::v1::GetSettingRequest const&
                 request) { return child_->GetSetting(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::resourcesettings::v1::Setting>
ResourceSettingsServiceLogging::UpdateSetting(
    grpc::ClientContext& context,
    google::cloud::resourcesettings::v1::UpdateSettingRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::resourcesettings::v1::UpdateSettingRequest const&
                 request) { return child_->UpdateSetting(context, request); },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcesettings_v1_internal
}  // namespace cloud
}  // namespace google
