// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/instance_group_managers/v1/instance_group_managers.proto

#include "google/cloud/compute/instance_group_managers/v1/instance_group_managers_connection.h"
#include "google/cloud/compute/instance_group_managers/v1/instance_group_managers_options.h"
#include "google/cloud/compute/instance_group_managers/v1/internal/instance_group_managers_option_defaults.h"
#include "google/cloud/compute/instance_group_managers/v1/internal/instance_group_managers_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_instance_group_managers_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

InstanceGroupManagersConnection::~InstanceGroupManagersConnection() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::AbandonInstances(
    google::cloud::cpp::compute::instance_group_managers::v1::
        AbandonInstancesRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<
    std::pair<std::string,
              google::cloud::cpp::compute::v1::InstanceGroupManagersScopedList>>
InstanceGroupManagersConnection::AggregatedListInstanceGroupManagers(
    google::cloud::cpp::compute::instance_group_managers::v1::
        AggregatedListInstanceGroupManagersRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<StreamRange<
      std::pair<std::string, google::cloud::cpp::compute::v1::
                                 InstanceGroupManagersScopedList>>>();
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::ApplyUpdatesToInstances(
    google::cloud::cpp::compute::instance_group_managers::v1::
        ApplyUpdatesToInstancesRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::CreateInstances(
    google::cloud::cpp::compute::instance_group_managers::v1::
        CreateInstancesRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::DeleteInstanceGroupManager(
    google::cloud::cpp::compute::instance_group_managers::v1::
        DeleteInstanceGroupManagerRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::DeleteInstances(
    google::cloud::cpp::compute::instance_group_managers::v1::
        DeleteInstancesRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::DeletePerInstanceConfigs(
    google::cloud::cpp::compute::instance_group_managers::v1::
        DeletePerInstanceConfigsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::InstanceGroupManager>
InstanceGroupManagersConnection::GetInstanceGroupManager(
    google::cloud::cpp::compute::instance_group_managers::v1::
        GetInstanceGroupManagerRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::InsertInstanceGroupManager(
    google::cloud::cpp::compute::instance_group_managers::v1::
        InsertInstanceGroupManagerRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::cpp::compute::v1::InstanceGroupManager>
InstanceGroupManagersConnection::ListInstanceGroupManagers(
    google::cloud::cpp::compute::instance_group_managers::v1::
        ListInstanceGroupManagersRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::cpp::compute::v1::InstanceGroupManager>>();
}

StreamRange<google::cloud::cpp::compute::v1::InstanceManagedByIgmError>
InstanceGroupManagersConnection::ListErrors(
    google::cloud::cpp::compute::instance_group_managers::v1::
        ListErrorsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<StreamRange<
      google::cloud::cpp::compute::v1::InstanceManagedByIgmError>>();
}

StatusOr<google::cloud::cpp::compute::v1::
             InstanceGroupManagersListManagedInstancesResponse>
InstanceGroupManagersConnection::ListManagedInstances(
    google::cloud::cpp::compute::instance_group_managers::v1::
        ListManagedInstancesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::cpp::compute::v1::PerInstanceConfig>
InstanceGroupManagersConnection::ListPerInstanceConfigs(
    google::cloud::cpp::compute::instance_group_managers::v1::
        ListPerInstanceConfigsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::cpp::compute::v1::PerInstanceConfig>>();
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::PatchInstanceGroupManager(
    google::cloud::cpp::compute::instance_group_managers::v1::
        PatchInstanceGroupManagerRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::PatchPerInstanceConfigs(
    google::cloud::cpp::compute::instance_group_managers::v1::
        PatchPerInstanceConfigsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::RecreateInstances(
    google::cloud::cpp::compute::instance_group_managers::v1::
        RecreateInstancesRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::Resize(
    google::cloud::cpp::compute::instance_group_managers::v1::
        ResizeRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::SetInstanceTemplate(
    google::cloud::cpp::compute::instance_group_managers::v1::
        SetInstanceTemplateRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::SetTargetPools(
    google::cloud::cpp::compute::instance_group_managers::v1::
        SetTargetPoolsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagersConnection::UpdatePerInstanceConfigs(
    google::cloud::cpp::compute::instance_group_managers::v1::
        UpdatePerInstanceConfigsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instance_group_managers_v1
}  // namespace cloud
}  // namespace google
