// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/external_vpn_gateways/v1/external_vpn_gateways.proto

#include "google/cloud/compute/external_vpn_gateways/v1/internal/external_vpn_gateways_option_defaults.h"
#include "google/cloud/compute/external_vpn_gateways/v1/external_vpn_gateways_connection.h"
#include "google/cloud/compute/external_vpn_gateways/v1/external_vpn_gateways_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_external_vpn_gateways_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options ExternalVpnGatewaysDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_EXTERNAL_VPN_GATEWAYS_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_EXTERNAL_VPN_GATEWAYS_AUTHORITY",
      "compute.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<compute_external_vpn_gateways_v1::
                       ExternalVpnGatewaysRetryPolicyOption>()) {
    options.set<
        compute_external_vpn_gateways_v1::ExternalVpnGatewaysRetryPolicyOption>(
        compute_external_vpn_gateways_v1::
            ExternalVpnGatewaysLimitedTimeRetryPolicy(std::chrono::minutes(30))
                .clone());
  }
  if (!options.has<compute_external_vpn_gateways_v1::
                       ExternalVpnGatewaysBackoffPolicyOption>()) {
    options.set<compute_external_vpn_gateways_v1::
                    ExternalVpnGatewaysBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<compute_external_vpn_gateways_v1::
                       ExternalVpnGatewaysPollingPolicyOption>()) {
    options.set<compute_external_vpn_gateways_v1::
                    ExternalVpnGatewaysPollingPolicyOption>(
        GenericPollingPolicy<compute_external_vpn_gateways_v1::
                                 ExternalVpnGatewaysRetryPolicyOption::Type,
                             compute_external_vpn_gateways_v1::
                                 ExternalVpnGatewaysBackoffPolicyOption::Type>(
            options
                .get<compute_external_vpn_gateways_v1::
                         ExternalVpnGatewaysRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options
           .has<compute_external_vpn_gateways_v1::
                    ExternalVpnGatewaysConnectionIdempotencyPolicyOption>()) {
    options.set<compute_external_vpn_gateways_v1::
                    ExternalVpnGatewaysConnectionIdempotencyPolicyOption>(
        compute_external_vpn_gateways_v1::
            MakeDefaultExternalVpnGatewaysConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_external_vpn_gateways_v1_internal
}  // namespace cloud
}  // namespace google
