#include "sig.h"

static sigset_t defaultmask, blocked;

static void sig_init(void) {
 static bool init_done=FALSE;
 if (!init_done) {
  /* we save the old signal stuff, for restoring with sig_restore() */
  (void)sigprocmask(SIG_SETMASK, NULL, &blocked);
  defaultmask=blocked;
  init_done=TRUE;
 }
}

/* catch some signal with the function func */
void sig_set(int signum, sig_function *func) {
 struct sigaction sa;
 sig_init();
 sa.sa_handler=func;
 sigemptyset(&sa.sa_mask);
 sigaddset(&sa.sa_mask,signum);
 sa.sa_flags=SA_RESTART;
 sigaction(signum, &sa, 0);
}

void sig_block(int signum) {
 sig_init();
 (void)sigaddset(&blocked, signum);
 (void)sigprocmask(SIG_BLOCK, &blocked, NULL);
}

void sig_restore(void) {
 sig_init();
 (void)sigprocmask(SIG_SETMASK, &defaultmask, NULL);
}
